/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.text.Collator;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.xerces.validators.datatype.AbstractStringValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class QNameDatatypeValidator
extends AbstractStringValidator {
    private static DatatypeValidator fgStrValidator = null;

    public QNameDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public QNameDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        super(datatypeValidator, hashtable, bl);
    }

    protected void assignAdditionalFacets(String string, Hashtable hashtable) throws InvalidDatatypeFacetException {
        throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_STRING_FACET, 0, new Object[]{string}));
    }

    protected void checkValueSpace(String string) throws InvalidDatatypeValueException {
        try {
            int n = string.indexOf(58);
            if (n >= 0) {
                fgStrValidator.validate(string.substring(0, n), null);
            }
            fgStrValidator.validate(string.substring(n + 1), null);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new InvalidDatatypeValueException("Value '" + string + "' is not a valid QName");
        }
    }

    public int compare(String string, String string2) {
        Locale locale = Locale.getDefault();
        Collator collator = Collator.getInstance(locale);
        return collator.compare(string, string2);
    }

    protected static void setNCNameValidator(DatatypeValidator datatypeValidator) {
        if (fgStrValidator == null) {
            fgStrValidator = datatypeValidator;
        }
    }
}

