/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.ComplexVector;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispInteger;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class BasicVector_UnsignedByte32
extends AbstractVector {
    private int capacity;
    private long[] elements;

    public BasicVector_UnsignedByte32(int capacity) {
        this.elements = new long[capacity];
        this.capacity = capacity;
    }

    public BasicVector_UnsignedByte32(LispObject[] array) {
        this.capacity = array.length;
        this.elements = new long[this.capacity];
        int i = array.length;
        while (i-- > 0) {
            this.elements[i] = array[i].longValue();
        }
    }

    @Override
    public LispObject typeOf() {
        return Lisp.list(Symbol.SIMPLE_ARRAY, Lisp.UNSIGNED_BYTE_32, new Cons(Fixnum.getInstance(this.capacity)));
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.VECTOR;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        if (type == BuiltInClass.SIMPLE_ARRAY) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public LispObject getElementType() {
        return Lisp.UNSIGNED_BYTE_32;
    }

    @Override
    public boolean isSimpleVector() {
        return false;
    }

    @Override
    public boolean hasFillPointer() {
        return false;
    }

    @Override
    public boolean isAdjustable() {
        return false;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int length() {
        return this.capacity;
    }

    @Override
    public LispObject elt(int index) {
        try {
            return Lisp.number(this.elements[index]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
            return Lisp.NIL;
        }
    }

    @Override
    public int aref(int index) {
        try {
            return (int)this.elements[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.elements.length);
            return -1;
        }
    }

    @Override
    public long aref_long(int index) {
        try {
            return this.elements[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.elements.length);
            return -1L;
        }
    }

    @Override
    public LispObject AREF(int index) {
        try {
            return Lisp.number(this.elements[index]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.elements.length);
            return Lisp.NIL;
        }
    }

    @Override
    public void aset(int index, LispObject newValue) {
        try {
            this.elements[index] = newValue.longValue();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.badIndex(index, this.capacity);
        }
    }

    @Override
    public LispObject subseq(int start, int end) {
        BasicVector_UnsignedByte32 v = new BasicVector_UnsignedByte32(end - start);
        int i = start;
        int j = 0;
        try {
            while (i < end) {
                v.elements[j++] = this.elements[i++];
            }
            return v;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Lisp.error(new TypeError("Array index out of bounds: " + i + "."));
        }
    }

    @Override
    public void fill(LispObject obj) {
        if (!(obj instanceof LispInteger)) {
            Lisp.type_error(obj, Symbol.INTEGER);
            return;
        }
        if (obj.isLessThan(Fixnum.ZERO) || obj.isGreaterThan(Lisp.UNSIGNED_BYTE_32_MAX_VALUE)) {
            Lisp.type_error(obj, Lisp.UNSIGNED_BYTE_32);
        }
        long value = obj.longValue();
        int i = this.capacity;
        while (i-- > 0) {
            this.elements[i] = value;
        }
    }

    @Override
    public void shrink(int n) {
        if (n < this.capacity) {
            long[] newArray = new long[n];
            System.arraycopy(this.elements, 0, newArray, 0, n);
            this.elements = newArray;
            this.capacity = n;
            return;
        }
        if (n == this.capacity) {
            return;
        }
        Lisp.error(new LispError());
    }

    @Override
    public LispObject reverse() {
        BasicVector_UnsignedByte32 result = new BasicVector_UnsignedByte32(this.capacity);
        int i = 0;
        int j = this.capacity - 1;
        while (i < this.capacity) {
            result.elements[i] = this.elements[j];
            ++i;
            --j;
        }
        return result;
    }

    @Override
    public LispObject nreverse() {
        int i = 0;
        for (int j = this.capacity - 1; i < j; ++i, --j) {
            long temp = this.elements[i];
            this.elements[i] = this.elements[j];
            this.elements[j] = temp;
        }
        return this;
    }

    @Override
    public AbstractVector adjustArray(int newCapacity, LispObject initialElement, LispObject initialContents) {
        if (initialContents != null) {
            LispObject[] newElements = new LispObject[newCapacity];
            if (initialContents.listp()) {
                LispObject list = initialContents;
                for (int i = 0; i < newCapacity; ++i) {
                    newElements[i] = list.car();
                    list = list.cdr();
                }
            } else if (initialContents.vectorp()) {
                for (int i = 0; i < newCapacity; ++i) {
                    newElements[i] = initialContents.elt(i);
                }
            } else {
                Lisp.type_error(initialContents, Symbol.SEQUENCE);
            }
            return new BasicVector_UnsignedByte32(newElements);
        }
        if (this.capacity != newCapacity) {
            LispObject[] newElements = new LispObject[newCapacity];
            System.arraycopy(this.elements, 0, newElements, 0, Math.min(this.capacity, newCapacity));
            if (initialElement != null) {
                for (int i = this.capacity; i < newCapacity; ++i) {
                    newElements[i] = initialElement;
                }
            }
            return new BasicVector_UnsignedByte32(newElements);
        }
        return this;
    }

    @Override
    public AbstractVector adjustArray(int newCapacity, AbstractArray displacedTo, int displacement) {
        return new ComplexVector(newCapacity, displacedTo, displacement);
    }
}

