/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.ConnectController;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.option.Option;

public abstract class FreeColAction
extends AbstractAction
implements Option<FreeColAction> {
    protected static final Logger logger = Logger.getLogger(FreeColAction.class.getName());
    public static final String TAG = "action";
    private static final int ORDER_BUTTON_COUNT = 4;
    public static final String ACTION_ID = "ACTION_ID";
    public static final String BUTTON_IMAGE = "BUTTON_IMAGE";
    public static final String BUTTON_ROLLOVER_IMAGE = "BUTTON_ROLLOVER_IMAGE";
    public static final String BUTTON_PRESSED_IMAGE = "BUTTON_PRESSED_IMAGE";
    public static final String BUTTON_DISABLED_IMAGE = "BUTTON_DISABLED_IMAGE";
    protected final FreeColClient freeColClient;
    private int orderButtonImageCount = 0;
    private List<String> imageIconKeys = new ArrayList<String>();
    private static final String ACCELERATOR_TAG = "accelerator";

    protected FreeColAction(FreeColClient freeColClient, String id) {
        super(Messages.getName(id));
        String acceleratorKey;
        String accelerator;
        this.freeColClient = freeColClient;
        this.putValue(ACTION_ID, id);
        String shortDescription = Messages.getDescription(id);
        if (!shortDescription.equals(Messages.descriptionKey(id))) {
            this.putValue("ShortDescription", shortDescription);
        }
        if (!(accelerator = Messages.message(acceleratorKey = id + ".accelerator")).equals(acceleratorKey)) {
            this.setAccelerator(KeyStroke.getKeyStroke(accelerator));
        }
    }

    protected FreeColClient getFreeColClient() {
        return this.freeColClient;
    }

    protected Game getGame() {
        return this.freeColClient.getGame();
    }

    protected Map getMap() {
        Game game = this.getGame();
        return game == null ? null : game.getMap();
    }

    protected GUI getGUI() {
        return this.freeColClient.getGUI();
    }

    protected InGameController igc() {
        return this.freeColClient.getInGameController();
    }

    protected ConnectController getConnectController() {
        return this.freeColClient.getConnectController();
    }

    protected ActionManager getActionManager() {
        return this.freeColClient.getActionManager();
    }

    protected ClientOptions getClientOptions() {
        return this.freeColClient.getClientOptions();
    }

    public FreeColAction cloneOption() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("FreeColAction can not be cloned:" + this);
    }

    public Integer getMnemonic() {
        return (Integer)this.getValue("MnemonicKey");
    }

    public void setMnemonic(int mnemonic) {
        this.putValue("MnemonicKey", mnemonic);
    }

    public boolean hasOrderButtons() {
        return this.orderButtonImageCount == 4;
    }

    protected void addImageIcons(String key) {
        this.imageIconKeys.add(key);
        SwingUtilities.invokeLater(() -> this.updateImageIcon(key));
    }

    public void updateRegisteredImageIcons() {
        for (String key : this.imageIconKeys) {
            this.updateImageIcon(key);
        }
    }

    private void updateImageIcon(String key) {
        ImageLibrary lib = this.getGUI().getFixedImageLibrary();
        List<BufferedImage> images = lib.getButtonImages(key);
        this.orderButtonImageCount = images.size();
        if (this.hasOrderButtons()) {
            this.putValue(BUTTON_IMAGE, new ImageIcon(images.remove(0)));
            this.putValue(BUTTON_ROLLOVER_IMAGE, new ImageIcon(images.remove(0)));
            this.putValue(BUTTON_PRESSED_IMAGE, new ImageIcon(images.remove(0)));
            this.putValue(BUTTON_DISABLED_IMAGE, new ImageIcon(images.remove(0)));
        } else {
            logger.warning("Found only " + this.orderButtonImageCount + " order button images for " + this.getId() + "/" + key);
        }
    }

    public final void setAccelerator(KeyStroke accelerator) {
        this.putValue("AcceleratorKey", accelerator);
    }

    public final KeyStroke getAccelerator() {
        return (KeyStroke)this.getValue("AcceleratorKey");
    }

    public final String getShortDescription() {
        return (String)this.getValue("ShortDescription");
    }

    @Override
    public final String getId() {
        return (String)this.getValue(ACTION_ID);
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    private static String getKeyStrokeText(KeyStroke keyStroke) {
        return keyStroke == null ? "" : keyStroke.toString();
    }

    public MenuKeyListener getMenuKeyListener() {
        return new InnerMenuKeyListener();
    }

    protected boolean shouldBeEnabled() {
        return !this.getGUI().isClientOptionsDialogShowing();
    }

    public void update() {
        this.setEnabled(this.shouldBeEnabled());
    }

    @Override
    public String getGroup() {
        return this.getActionManager().getId();
    }

    @Override
    public void setGroup(String group) {
        logger.warning("Unsupported method FreeColAction.setGroup.");
    }

    @Override
    public FreeColAction getValue() {
        return this;
    }

    @Override
    public void setValue(FreeColAction value) {
        logger.warning("Unsupported method FreeColAction.setValue.");
    }

    @Override
    public String getEnabledBy() {
        return null;
    }

    @Override
    public void toXML(FreeColXMLWriter xw) throws XMLStreamException {
        xw.writeStartElement(TAG);
        xw.writeAttribute("id", this.getId());
        xw.writeAttribute(ACCELERATOR_TAG, FreeColAction.getKeyStrokeText(this.getAccelerator()));
        xw.writeEndElement();
    }

    @Override
    public void readFromXML(FreeColXMLReader xr) throws XMLStreamException {
        String acc = xr.getAttribute(ACCELERATOR_TAG, "");
        this.putValue("AcceleratorKey", acc == null || acc.isEmpty() ? null : KeyStroke.getKeyStroke(acc));
        xr.closeTag(TAG);
    }

    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public class InnerMenuKeyListener
    implements MenuKeyListener {
        final int mnemonic;

        public InnerMenuKeyListener() {
            this.mnemonic = (Integer)FreeColAction.this.getValue("MnemonicKey");
        }

        @Override
        public void menuKeyPressed(MenuKeyEvent e) {
            if (e.getKeyCode() == this.mnemonic) {
                ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), (String)FreeColAction.this.getValue("Name"), e.getModifiersEx());
                FreeColAction.this.actionPerformed(ae);
                e.consume();
            }
        }

        @Override
        public void menuKeyReleased(MenuKeyEvent e) {
        }

        @Override
        public void menuKeyTyped(MenuKeyEvent e) {
        }
    }
}

