/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.colopedia;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaPanel;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.util.CollectionUtils;

public class NationDetailPanel
extends ColopediaGameObjectTypePanel<Nation> {
    public NationDetailPanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel) {
        super(freeColClient, colopediaPanel, ColopediaAction.PanelType.NATIONS.getKey());
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        ArrayList<Nation> nations = new ArrayList<Nation>();
        nations.addAll(this.getSpecification().getEuropeanNations());
        nations.addAll(this.getSpecification().getIndianNations());
        super.addSubTrees(root, nations);
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        if (this.getId().equals(id)) {
            return;
        }
        Nation nation = this.getSpecification().getNation(id);
        Player player = CollectionUtils.find(this.getGame().getLivePlayers(new Player[0]), p -> p.getNation() == nation);
        NationType currentNationType = player == null ? nation.getType() : player.getNationType();
        panel.setLayout(new MigLayout("wrap 3, fillx, gapx 20", "", ""));
        JLabel name = Utility.localizedHeaderLabel(nation, Utility.FONTSPEC_SUBTITLE);
        panel.add((Component)name, "span, align center, wrap 40");
        JLabel artLabel = new JLabel(new ImageIcon(ImageLibrary.getMonarchImage(nation)));
        panel.add((Component)artLabel, "spany, gap 40, top");
        panel.add(Utility.localizedLabel("colopedia.nation.ruler"));
        panel.add(new JLabel(nation.getRulerName()));
        panel.add(Utility.localizedLabel("colopedia.nation.defaultAdvantage"));
        panel.add(this.getButton(nation.getType()));
        panel.add(Utility.localizedLabel("colopedia.nation.currentAdvantage"));
        panel.add((Component)this.getButton(currentNationType), "wrap push");
    }
}

