/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation.generator;

import org.apache.commons.lang.StringUtils;
import org.gradle.api.Describable;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.internal.DisplayName;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.instantiation.PropertyRoleAnnotationHandler;
import org.gradle.internal.serialization.Cached;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.state.ModelObject;
import org.gradle.internal.state.OwnerAware;

public class ManagedObjectFactory {
    private final ServiceLookup serviceLookup;
    private final InstanceGenerator instantiator;
    private final PropertyRoleAnnotationHandler roleHandler;

    public ManagedObjectFactory(ServiceLookup serviceLookup, InstanceGenerator instantiator, PropertyRoleAnnotationHandler roleHandler) {
        this.serviceLookup = serviceLookup;
        this.instantiator = instantiator;
        this.roleHandler = roleHandler;
    }

    public static <T> T attachOwner(T instance, ModelObject owner, String propertyName) {
        if (instance instanceof OwnerAware) {
            ((OwnerAware)instance).attachOwner(owner, ManagedObjectFactory.displayNameFor(owner, propertyName));
        }
        return instance;
    }

    public void applyRole(Object value, ModelObject owner) {
        this.roleHandler.applyRoleTo(owner, value);
    }

    public Object newInstance(ModelObject owner, String propertyName, Class<?> type) {
        if (type.isAssignableFrom(ConfigurableFileCollection.class)) {
            return ManagedObjectFactory.attachOwner(this.getObjectFactory().fileCollection(), owner, propertyName);
        }
        if (type.isAssignableFrom(ConfigurableFileTree.class)) {
            return ManagedObjectFactory.attachOwner(this.getObjectFactory().fileTree(), owner, propertyName);
        }
        if (type.isAssignableFrom(DirectoryProperty.class)) {
            return ManagedObjectFactory.attachOwner(this.getObjectFactory().directoryProperty(), owner, propertyName);
        }
        if (type.isAssignableFrom(RegularFileProperty.class)) {
            return ManagedObjectFactory.attachOwner(this.getObjectFactory().fileProperty(), owner, propertyName);
        }
        return ManagedObjectFactory.attachOwner(this.instantiator.newInstanceWithDisplayName(type, (Describable)ManagedObjectFactory.displayNameFor(owner, propertyName), new Object[0]), owner, propertyName);
    }

    public Object newInstance(ModelObject owner, String propertyName, Class<?> type, Class<?> paramType) {
        if (type.isAssignableFrom(Property.class)) {
            return ManagedObjectFactory.attachOwner(this.getObjectFactory().property(paramType), owner, propertyName);
        }
        if (type.isAssignableFrom(ListProperty.class)) {
            return ManagedObjectFactory.attachOwner(this.getObjectFactory().listProperty(paramType), owner, propertyName);
        }
        if (type.isAssignableFrom(SetProperty.class)) {
            return ManagedObjectFactory.attachOwner(this.getObjectFactory().setProperty(paramType), owner, propertyName);
        }
        if (type.isAssignableFrom(DomainObjectSet.class)) {
            return ManagedObjectFactory.attachOwner(this.getObjectFactory().domainObjectSet(paramType), owner, propertyName);
        }
        if (type.isAssignableFrom(NamedDomainObjectContainer.class)) {
            return ManagedObjectFactory.attachOwner(this.getObjectFactory().domainObjectContainer(paramType), owner, propertyName);
        }
        if (type.isAssignableFrom(ExtensiblePolymorphicDomainObjectContainer.class)) {
            return ManagedObjectFactory.attachOwner(this.getObjectFactory().polymorphicDomainObjectContainer(paramType), owner, propertyName);
        }
        throw new IllegalArgumentException("Don't know how to create an instance of type " + type.getName());
    }

    public Object newInstance(ModelObject owner, String propertyName, Class<?> type, Class<?> keyType, Class<?> valueType) {
        if (type.isAssignableFrom(MapProperty.class)) {
            return ManagedObjectFactory.attachOwner(this.getObjectFactory().mapProperty(keyType, valueType), owner, propertyName);
        }
        throw new IllegalArgumentException("Don't know how to create an instance of type " + type.getName());
    }

    private static ManagedPropertyName displayNameFor(ModelObject owner, String propertyName) {
        if (owner.getModelIdentityDisplayName() instanceof ManagedPropertyName) {
            ManagedPropertyName root = (ManagedPropertyName)owner.getModelIdentityDisplayName();
            return new ManagedPropertyName((Cached<String>)root.ownerDisplayName, root.propertyName + "." + propertyName);
        }
        return new ManagedPropertyName(ManagedObjectFactory.cachedOwnerDisplayNameOf(owner), propertyName);
    }

    private static Cached<String> cachedOwnerDisplayNameOf(ModelObject owner) {
        return Cached.of(() -> {
            Describable ownerModelIdentityDisplayName = owner.getModelIdentityDisplayName();
            if (ownerModelIdentityDisplayName != null) {
                return ownerModelIdentityDisplayName.getDisplayName();
            }
            return null;
        });
    }

    private ObjectFactory getObjectFactory() {
        return (ObjectFactory)this.serviceLookup.get(ObjectFactory.class);
    }

    private static class ManagedPropertyName
    implements DisplayName {
        private final Cached<String> ownerDisplayName;
        private final String propertyName;

        public ManagedPropertyName(Cached<String> ownerDisplayName, String propertyName) {
            this.ownerDisplayName = ownerDisplayName;
            this.propertyName = propertyName;
        }

        public String toString() {
            return this.getDisplayName();
        }

        public String getCapitalizedDisplayName() {
            return StringUtils.capitalize((String)this.getDisplayName());
        }

        public String getDisplayName() {
            if (this.ownerDisplayName.get() != null) {
                return (String)this.ownerDisplayName.get() + " property '" + this.propertyName + "'";
            }
            return "property '" + this.propertyName + "'";
        }
    }
}

