/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.annotations.impl;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.gradle.internal.reflect.annotations.PropertyAnnotationMetadata;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadata;
import org.gradle.internal.reflect.validation.ReplayingTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationContext;

public class DefaultTypeAnnotationMetadata
implements TypeAnnotationMetadata {
    private final ImmutableBiMap<Class<? extends Annotation>, Annotation> annotations;
    private final ImmutableSortedSet<PropertyAnnotationMetadata> properties;
    private final ReplayingTypeValidationContext validationProblems;

    public DefaultTypeAnnotationMetadata(Iterable<? extends Annotation> annotations, Iterable<? extends PropertyAnnotationMetadata> properties, ReplayingTypeValidationContext validationProblems) {
        this.annotations = ImmutableBiMap.copyOf((Map)Maps.uniqueIndex(annotations, Annotation::annotationType));
        this.properties = ImmutableSortedSet.copyOf(properties);
        this.validationProblems = validationProblems;
    }

    @Override
    public ImmutableSet<Annotation> getAnnotations() {
        return this.annotations.values();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.annotations.containsKey(annotationType);
    }

    @Override
    public ImmutableSortedSet<PropertyAnnotationMetadata> getPropertiesAnnotationMetadata() {
        return this.properties;
    }

    @Override
    public void visitValidationFailures(TypeValidationContext validationContext) {
        this.validationProblems.replay(null, validationContext);
    }
}

