/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.configurations.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportAttribute;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportConfiguration;

public final class ConfigurationReportModel {
    private final String projectName;
    private final List<ReportConfiguration> allConfigs;
    private final ImmutableList<ReportAttribute> attributesWithCompatibilityRules;
    private final ImmutableList<ReportAttribute> attributesWithDisambiguationRules;

    ConfigurationReportModel(String projectName, List<ReportConfiguration> allConfigs, List<ReportAttribute> attributesWithCompatibilityRules, List<ReportAttribute> attributesWithDisambiguationRules) {
        this.projectName = projectName;
        this.allConfigs = allConfigs;
        this.attributesWithCompatibilityRules = ImmutableList.copyOf(attributesWithCompatibilityRules);
        this.attributesWithDisambiguationRules = ImmutableList.copyOf(attributesWithDisambiguationRules);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public List<ReportAttribute> getAttributesWithCompatibilityRules() {
        return this.attributesWithCompatibilityRules;
    }

    public List<ReportAttribute> getAttributesWithDisambiguationRules() {
        return this.attributesWithDisambiguationRules;
    }

    public List<ReportConfiguration> getAllConfigs() {
        return this.allConfigs;
    }

    public List<ReportConfiguration> getPurelyResolvableConfigs() {
        return this.allConfigs.stream().filter(ReportConfiguration::isPurelyResolvable).collect(Collectors.toList());
    }

    public List<ReportConfiguration> getPurelyConsumableConfigs() {
        return this.allConfigs.stream().filter(ReportConfiguration::isPurelyConsumable).collect(Collectors.toList());
    }

    public Optional<ReportConfiguration> getConfigNamed(String configName) {
        return this.allConfigs.stream().filter(config -> config.getName().equals(configName)).findFirst();
    }
}

