/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Cast;
import org.gradle.internal.Pair;
import org.gradle.internal.metaobject.DynamicObjectUtil;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;
import org.gradle.plugins.ide.eclipse.model.internal.PathUtil;
import org.gradle.util.internal.CollectionUtils;

public class SourceFoldersCreator {
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');

    public List<SourceFolder> createSourceFolders(EclipseClasspath classpath) {
        List<SourceFolder> sourceFolders = this.configureProjectRelativeFolders(classpath.getSourceSets(), (Collection)classpath.getTestSourceSets().getOrElse(Collections.emptySet()), (Function<File, String>)((Function)input -> classpath.getProject().relativePath(input)), classpath.getDefaultOutputDir(), (String)classpath.getBaseSourceOutputDir().map(dir -> classpath.getProject().relativePath(dir)).getOrElse((Object)"bin"));
        return (List)this.collectRegularAndExternalSourceFolders(sourceFolders, (sourceFoldersLeft, sourceFoldersRight) -> ImmutableList.builder().addAll((Iterable)sourceFoldersLeft).addAll((Iterable)sourceFoldersRight).build());
    }

    public List<SourceFolder> getBasicExternalSourceFolders(Iterable<SourceSet> sourceSets, Function<File, String> provideRelativePath, File defaultOutputDir) {
        List<SourceFolder> basicSourceFolders = this.basicProjectRelativeFolders(sourceSets, provideRelativePath, defaultOutputDir);
        return (List)this.collectRegularAndExternalSourceFolders(basicSourceFolders, (sourceFoldersLeft, sourceFoldersRight) -> ImmutableList.copyOf((Collection)sourceFoldersRight));
    }

    private <T> T collectRegularAndExternalSourceFolders(List<SourceFolder> sourceFolder, BiFunction<Collection<SourceFolder>, Collection<SourceFolder>, T> collector) {
        Pair partitionedFolders = CollectionUtils.partition(sourceFolder, sf -> sf.getPath().contains(".."));
        Collection externalSourceFolders = (Collection)partitionedFolders.getLeft();
        Collection regularSourceFolders = (Collection)partitionedFolders.getRight();
        ArrayList sources = Lists.newArrayList((Iterable)Collections2.transform((Collection)regularSourceFolders, SourceFolder::getName));
        List<SourceFolder> dedupedExternalSourceFolders = this.trimAndDedup(externalSourceFolders, sources);
        return collector.apply(regularSourceFolders, dedupedExternalSourceFolders);
    }

    private List<SourceFolder> configureProjectRelativeFolders(Iterable<SourceSet> sourceSets, Collection<SourceSet> testSourceSets, Function<File, String> provideRelativePath, File defaultOutputDir, String baseSourceOutputDir) {
        String defaultOutputPath = PathUtil.normalizePath((String)provideRelativePath.apply((Object)defaultOutputDir));
        ImmutableList.Builder entries = ImmutableList.builder();
        List<SourceSet> sortedSourceSets = this.sortSourceSetsAsPerUsualConvention(sourceSets);
        Map<SourceSet, String> sourceSetOutputPaths = this.collectSourceSetOutputPaths(sortedSourceSets, defaultOutputPath, baseSourceOutputDir);
        Multimap<SourceSet, SourceSet> sourceSetUsages = this.getSourceSetUsages(sortedSourceSets);
        for (SourceSet sourceSet : sortedSourceSets) {
            List<DirectoryTree> sortedSourceDirs = this.sortSourceDirsAsPerUsualConvention(sourceSet.getAllSource().getSrcDirTrees());
            for (DirectoryTree tree : sortedSourceDirs) {
                File dir = tree.getDir();
                if (!dir.isDirectory()) continue;
                SourceFolder folder = this.createSourceFolder(testSourceSets, provideRelativePath, sourceSetOutputPaths, sourceSetUsages, sourceSet, tree, dir);
                entries.add((Object)folder);
            }
        }
        return entries.build();
    }

    private SourceFolder createSourceFolder(Collection<SourceSet> testSourceSets, Function<File, String> provideRelativePath, Map<SourceSet, String> sourceSetOutputPaths, Multimap<SourceSet, SourceSet> sourceSetUsages, SourceSet sourceSet, DirectoryTree tree, File dir) {
        String relativePath = (String)provideRelativePath.apply((Object)dir);
        SourceFolder folder = new SourceFolder(relativePath, null);
        folder.setDir(dir);
        folder.setName(dir.getName());
        folder.setIncludes(this.getIncludesForTree(sourceSet, tree));
        folder.setExcludes(this.getExcludesForTree(sourceSet, tree));
        folder.setOutput(sourceSetOutputPaths.get(sourceSet));
        this.addScopeAttributes(folder, sourceSet, sourceSetUsages);
        this.addSourceSetAttributeIfNeeded(sourceSet, folder, testSourceSets);
        return folder;
    }

    private List<SourceFolder> basicProjectRelativeFolders(Iterable<SourceSet> sourceSets, Function<File, String> provideRelativePath, File defaultOutputDir) {
        ImmutableList.Builder entries = ImmutableList.builder();
        List<SourceSet> sortedSourceSets = this.sortSourceSetsAsPerUsualConvention(sourceSets);
        for (SourceSet sourceSet : sortedSourceSets) {
            List<DirectoryTree> sortedSourceDirs = this.sortSourceDirsAsPerUsualConvention(sourceSet.getAllSource().getSrcDirTrees());
            for (DirectoryTree tree : sortedSourceDirs) {
                File dir = tree.getDir();
                if (!dir.isDirectory()) continue;
                entries.add((Object)SourceFoldersCreator.createSourceFolder(provideRelativePath, dir));
            }
        }
        return entries.build();
    }

    private static SourceFolder createSourceFolder(Function<File, String> provideRelativePath, File dir) {
        SourceFolder folder = new SourceFolder((String)provideRelativePath.apply((Object)dir), null);
        folder.setDir(dir);
        folder.setName(dir.getName());
        return folder;
    }

    private List<SourceFolder> trimAndDedup(Collection<SourceFolder> externalSourceFolders, List<String> givenSources) {
        ArrayList trimmedSourceFolders = Lists.newArrayList();
        for (SourceFolder folder : externalSourceFolders) {
            folder.trim();
            for (File parentFile = folder.getDir().getParentFile(); givenSources.contains(folder.getName()) && parentFile != null; parentFile = parentFile.getParentFile()) {
                folder.trim(parentFile.getName());
            }
            givenSources.add(folder.getName());
            trimmedSourceFolders.add(folder);
        }
        return trimmedSourceFolders;
    }

    private void addScopeAttributes(SourceFolder folder, SourceSet sourceSet, Multimap<SourceSet, SourceSet> sourceSetUsages) {
        folder.getEntryAttributes().put("gradle_scope", this.sanitizeNameForAttribute(sourceSet));
        folder.getEntryAttributes().put("gradle_used_by_scope", COMMA_JOINER.join(this.getUsingSourceSetNames(sourceSet, sourceSetUsages)));
    }

    private List<String> getUsingSourceSetNames(SourceSet sourceSet, Multimap<SourceSet, SourceSet> sourceSetUsages) {
        return sourceSetUsages.get((Object)sourceSet).stream().map(this::sanitizeNameForAttribute).collect(Collectors.toList());
    }

    private String sanitizeNameForAttribute(SourceSet sourceSet) {
        return sourceSet.getName().replaceAll(",", "");
    }

    private Multimap<SourceSet, SourceSet> getSourceSetUsages(Iterable<SourceSet> sourceSets) {
        LinkedHashMultimap usages = LinkedHashMultimap.create();
        for (SourceSet sourceSet : sourceSets) {
            for (SourceSet otherSourceSet : sourceSets) {
                if (!this.containsOutputOf(sourceSet, otherSourceSet)) continue;
                usages.put((Object)otherSourceSet, (Object)sourceSet);
            }
        }
        return usages;
    }

    private boolean containsOutputOf(SourceSet sourceSet, SourceSet otherSourceSet) {
        try {
            return this.containsAll(sourceSet.getRuntimeClasspath(), (FileCollection)otherSourceSet.getOutput());
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean containsAll(FileCollection first, FileCollection second) {
        for (File file : second) {
            if (first.contains(file)) continue;
            return false;
        }
        return true;
    }

    private void addSourceSetAttributeIfNeeded(SourceSet sourceSet, SourceFolder folder, Collection<SourceSet> testSourceSets) {
        if (testSourceSets.contains(sourceSet)) {
            folder.getEntryAttributes().put("test", "true");
        }
    }

    private Map<SourceSet, String> collectSourceSetOutputPaths(Iterable<SourceSet> sourceSets, String defaultOutputPath, String baseSourceOutputDir) {
        HashSet existingPaths = Sets.newHashSet((Object[])new String[]{defaultOutputPath});
        HashMap result = Maps.newHashMap();
        for (SourceSet sourceSet : sourceSets) {
            String path = this.collectSourceSetOutputPath(sourceSet.getName(), existingPaths, "", baseSourceOutputDir);
            existingPaths.add(path);
            result.put(sourceSet, path);
        }
        return result;
    }

    private String collectSourceSetOutputPath(String sourceSetName, Set<String> existingPaths, String suffix, String baseSourceOutputDir) {
        String path = baseSourceOutputDir + "/" + sourceSetName + suffix;
        return existingPaths.contains(path) ? this.collectSourceSetOutputPath(sourceSetName, existingPaths, suffix + "_", baseSourceOutputDir) : path;
    }

    private List<String> getExcludesForTree(SourceSet sourceSet, DirectoryTree directoryTree) {
        List<Set<String>> excludesByType = this.getFiltersForTreeGroupedByType(sourceSet, directoryTree, "excludes");
        return CollectionUtils.intersection(excludesByType);
    }

    private List<String> getIncludesForTree(SourceSet sourceSet, DirectoryTree directoryTree) {
        List<Set<String>> includesByType = this.getFiltersForTreeGroupedByType(sourceSet, directoryTree, "includes");
        if (includesByType.stream().anyMatch(Set::isEmpty)) {
            return Collections.emptyList();
        }
        List allIncludes = CollectionUtils.flattenCollections(String.class, (Object[])new Object[]{includesByType});
        return ImmutableSet.copyOf((Collection)allIncludes).asList();
    }

    private List<Set<String>> getFiltersForTreeGroupedByType(SourceSet sourceSet, DirectoryTree directoryTree, String filterOperation) {
        Set resSrcDirs;
        Set javaSrcDirs = sourceSet.getAllJava().getSrcDirs();
        List srcDirs = CollectionUtils.intersection((Collection)ImmutableList.of((Object)javaSrcDirs, (Object)(resSrcDirs = sourceSet.getResources().getSrcDirs())));
        if (!srcDirs.contains(directoryTree.getDir())) {
            return ImmutableList.of(this.collectFilters(directoryTree.getPatterns(), filterOperation));
        }
        Set<String> resourcesFilter = this.collectFilters(sourceSet.getResources().getSrcDirTrees(), directoryTree.getDir(), filterOperation);
        Set<String> sourceFilter = this.collectFilters(sourceSet.getAllJava().getSrcDirTrees(), directoryTree.getDir(), filterOperation);
        return ImmutableList.of(resourcesFilter, sourceFilter);
    }

    private Set<String> collectFilters(Set<DirectoryTree> directoryTrees, File targetDir, String filterOperation) {
        for (DirectoryTree directoryTree : directoryTrees) {
            if (!directoryTree.getDir().equals(targetDir)) continue;
            PatternSet patterns = directoryTree.getPatterns();
            return this.collectFilters(patterns, filterOperation);
        }
        return Collections.emptySet();
    }

    private Set<String> collectFilters(PatternSet patterns, String filterOperation) {
        return (Set)Cast.uncheckedCast((Object)DynamicObjectUtil.asDynamicObject((Object)patterns).getProperty(filterOperation));
    }

    private List<SourceSet> sortSourceSetsAsPerUsualConvention(Iterable<SourceSet> sourceSets) {
        return CollectionUtils.sort(sourceSets, Comparator.comparing(SourceFoldersCreator::toComparable));
    }

    private List<DirectoryTree> sortSourceDirsAsPerUsualConvention(Iterable<DirectoryTree> sourceDirs) {
        return CollectionUtils.sort(sourceDirs, Comparator.comparing(SourceFoldersCreator::toComparable));
    }

    private static Integer toComparable(SourceSet sourceSet) {
        String name = sourceSet.getName();
        if ("main".equals(name)) {
            return 0;
        }
        if ("test".equals(name)) {
            return 1;
        }
        return 2;
    }

    private static Integer toComparable(DirectoryTree tree) {
        String path = tree.getDir().getPath();
        if (path.endsWith("java")) {
            return 0;
        }
        if (path.endsWith("resources")) {
            return 2;
        }
        return 1;
    }
}

