/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.enterprise.impl.legacy;

import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.internal.BuildType;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginAdapter;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginManager;
import org.gradle.internal.enterprise.impl.legacy.UnsupportedBuildScanPluginVersionException;
import org.gradle.internal.scan.config.BuildScanConfig;
import org.gradle.internal.scan.config.BuildScanConfigProvider;
import org.gradle.internal.scan.config.BuildScanPluginMetadata;
import org.gradle.internal.scan.eob.BuildScanEndOfBuildNotifier;
import org.gradle.util.internal.VersionNumber;

public class LegacyGradleEnterprisePluginCheckInService
implements BuildScanConfigProvider,
BuildScanEndOfBuildNotifier {
    public static final String FIRST_GRADLE_ENTERPRISE_PLUGIN_VERSION_DISPLAY = "3.0";
    public static final VersionNumber FIRST_GRADLE_ENTERPRISE_PLUGIN_VERSION = VersionNumber.parse((String)"3.0");
    public static final String UNSUPPORTED_TOGGLE = "org.gradle.internal.unsupported-scan-plugin";
    public static final String UNSUPPORTED_TOGGLE_MESSAGE = "Build scan support disabled by secret toggle";
    private static final VersionNumber FIRST_VERSION_AWARE_OF_UNSUPPORTED = VersionNumber.parse((String)"1.11");
    private final GradleInternal gradle;
    private final BuildModelParameters buildModelParameters;
    private final GradleEnterprisePluginManager manager;
    private final BuildType buildType;
    private BuildScanEndOfBuildNotifier.Listener listener;

    @Inject
    public LegacyGradleEnterprisePluginCheckInService(GradleInternal gradle, BuildModelParameters buildModelParameters, GradleEnterprisePluginManager manager, BuildType buildType) {
        this.gradle = gradle;
        this.buildModelParameters = buildModelParameters;
        this.manager = manager;
        this.buildType = buildType;
    }

    @Nullable
    private String unsupportedReason(VersionNumber pluginVersion) {
        if (Boolean.getBoolean(UNSUPPORTED_TOGGLE)) {
            return UNSUPPORTED_TOGGLE_MESSAGE;
        }
        if (this.buildModelParameters.isConfigurationCache()) {
            return "Build scans have been disabled due to incompatibility between your Gradle Enterprise plugin version (" + pluginVersion.toString() + ") and configuration caching. Please use Gradle Enterprise plugin version 3.4 or later for compatibility with configuration caching.";
        }
        return null;
    }

    @Override
    public BuildScanConfig collect(BuildScanPluginMetadata pluginMetadata) {
        if (this.manager.isPresent()) {
            throw new IllegalStateException("Configuration has already been collected.");
        }
        VersionNumber pluginVersion = VersionNumber.parse((String)pluginMetadata.getVersion()).getBaseVersion();
        if (pluginVersion.compareTo(FIRST_GRADLE_ENTERPRISE_PLUGIN_VERSION) < 0) {
            throw new UnsupportedBuildScanPluginVersionException("The build scan plugin is not compatible with this version of Gradle.\nPlease see https://gradle.com/help/gradle-6-build-scan-plugin for more information.");
        }
        String unsupportedReason = this.unsupportedReason(pluginVersion);
        if (unsupportedReason == null) {
            this.manager.registerAdapter((GradleEnterprisePluginAdapter)new Adapter());
        } else {
            this.manager.unsupported();
            if (!this.isPluginAwareOfUnsupported(pluginVersion)) {
                throw new UnsupportedBuildScanPluginVersionException(unsupportedReason);
            }
        }
        return new Config(Requestedness.from(this.gradle), new Attributes(this.buildType), unsupportedReason);
    }

    @Override
    public void notify(BuildScanEndOfBuildNotifier.Listener listener) {
        if (this.listener != null) {
            throw new IllegalStateException("listener already set to " + this.listener);
        }
        this.listener = listener;
    }

    private boolean isPluginAwareOfUnsupported(VersionNumber pluginVersion) {
        return pluginVersion.compareTo(FIRST_VERSION_AWARE_OF_UNSUPPORTED) >= 0;
    }

    private class Adapter
    implements GradleEnterprisePluginAdapter {
        private Adapter() {
        }

        public boolean shouldSaveToConfigurationCache() {
            return false;
        }

        public void onLoadFromConfigurationCache() {
            throw new UnsupportedOperationException();
        }

        public void buildFinished(final @Nullable Throwable buildFailure) {
            if (LegacyGradleEnterprisePluginCheckInService.this.listener != null) {
                LegacyGradleEnterprisePluginCheckInService.this.listener.execute(new BuildScanEndOfBuildNotifier.BuildResult(){

                    @Override
                    @Nullable
                    public Throwable getFailure() {
                        return buildFailure;
                    }
                });
            }
        }
    }

    private static class Attributes
    implements BuildScanConfig.Attributes {
        private final BuildType buildType;

        public Attributes(BuildType buildType) {
            this.buildType = buildType;
        }

        @Override
        public boolean isRootProjectHasVcsMappings() {
            return false;
        }

        @Override
        public boolean isTaskExecutingBuild() {
            boolean forceTaskExecutingBuild = System.getProperty("org.gradle.internal.ide.scan") != null;
            return forceTaskExecutingBuild || this.buildType == BuildType.TASKS;
        }
    }

    private static enum Requestedness {
        DEFAULTED(false, false),
        ENABLED(true, false),
        DISABLED(false, true);

        private final boolean enabled;
        private final boolean disabled;

        private Requestedness(boolean enabled, boolean disabled) {
            this.enabled = enabled;
            this.disabled = disabled;
        }

        private static Requestedness from(GradleInternal gradle) {
            StartParameterInternal startParameter = gradle.getStartParameter();
            if (startParameter.isNoBuildScan()) {
                return DISABLED;
            }
            if (startParameter.isBuildScan()) {
                return ENABLED;
            }
            return DEFAULTED;
        }
    }

    private static class Config
    implements BuildScanConfig {
        private final Requestedness requestedness;
        private final String unsupported;
        private final BuildScanConfig.Attributes attributes;

        public Config(Requestedness requestedness, BuildScanConfig.Attributes attributes, String unsupported) {
            this.requestedness = requestedness;
            this.unsupported = unsupported;
            this.attributes = attributes;
        }

        @Override
        public boolean isEnabled() {
            return this.requestedness.enabled;
        }

        @Override
        public boolean isDisabled() {
            return this.requestedness.disabled;
        }

        @Override
        public String getUnsupportedMessage() {
            return this.unsupported;
        }

        @Override
        public BuildScanConfig.Attributes getAttributes() {
            return this.attributes;
        }
    }
}

