/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data.attributes.types;

import jadx.plugins.input.java.data.attributes.IJavaAttribute;
import jadx.plugins.input.java.data.attributes.IJavaAttributeReader;
import jadx.plugins.input.java.data.attributes.types.data.RawBootstrapMethod;
import java.util.ArrayList;
import java.util.List;

public class JavaBootstrapMethodsAttr
implements IJavaAttribute {
    private final List<RawBootstrapMethod> list;

    public JavaBootstrapMethodsAttr(List<RawBootstrapMethod> list) {
        this.list = list;
    }

    public List<RawBootstrapMethod> getList() {
        return this.list;
    }

    public static IJavaAttributeReader reader() {
        return (clsData, reader) -> {
            int len = reader.readU2();
            ArrayList<RawBootstrapMethod> list = new ArrayList<RawBootstrapMethod>(len);
            for (int i = 0; i < len; ++i) {
                int methodHandleIdx = reader.readU2();
                int argsCount = reader.readU2();
                int[] args = new int[argsCount];
                for (int j = 0; j < argsCount; ++j) {
                    args[j] = reader.readU2();
                }
                list.add(new RawBootstrapMethod(methodHandleIdx, args));
            }
            return new JavaBootstrapMethodsAttr(list);
        };
    }
}

