/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.uriloader;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import org.jd.gui.api.API;
import org.jd.gui.service.extension.ExtensionService;
import org.jd.gui.spi.UriLoader;

public class UriLoaderService {
    protected static final UriLoaderService URI_LOADER_SERVICE = new UriLoaderService();
    protected HashMap<String, UriLoader> mapProviders = new HashMap();

    public static UriLoaderService getInstance() {
        return URI_LOADER_SERVICE;
    }

    protected UriLoaderService() {
        Collection<UriLoader> providers = ExtensionService.getInstance().load(UriLoader.class);
        for (UriLoader provider : providers) {
            for (String scheme : provider.getSchemes()) {
                this.mapProviders.put(scheme, provider);
            }
        }
    }

    public UriLoader get(API api, URI uri) {
        UriLoader provider = this.mapProviders.get(uri.getScheme());
        if (provider.accept(api, uri)) {
            return provider;
        }
        return null;
    }
}

