/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi_modified.sctp4j;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SctpNotification {
    public static final int SCTP_ASSOC_CHANGE = 1;
    public static final int SCTP_PEER_ADDR_CHANGE = 2;
    public static final int SCTP_REMOTE_ERROR = 3;
    public static final int SCTP_SEND_FAILED = 4;
    public static final int SCTP_SHUTDOWN_EVENT = 5;
    public static final int SCTP_ADAPTATION_INDICATION = 6;
    public static final int SCTP_PARTIAL_DELIVERY_EVENT = 7;
    public static final int SCTP_AUTHENTICATION_EVENT = 8;
    public static final int SCTP_STREAM_RESET_EVENT = 9;
    public static final int SCTP_SENDER_DRY_EVENT = 10;
    public static final int SCTP_NOTIFICATIONS_STOPPED_EVENT = 11;
    public static final int SCTP_ASSOC_RESET_EVENT = 12;
    public static final int SCTP_STREAM_CHANGE_EVENT = 13;
    public static final int SCTP_SEND_FAILED_EVENT = 14;
    public final int sn_type;
    public final int sn_flags;
    public final int sn_length;
    protected final ByteBuffer buffer;

    private SctpNotification(byte[] data) {
        this.buffer = ByteBuffer.wrap(data);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.sn_type = this.buffer.getChar();
        this.sn_flags = this.buffer.getChar();
        this.sn_length = this.buffer.getInt();
    }

    public String toString() {
        switch (this.sn_type) {
            case 1: {
                return "SCTP_ASSOC_CHANGE";
            }
            case 2: {
                return "SCTP_PEER_ADDR_CHANGE";
            }
            case 3: {
                return "SCTP_REMOTE_ERROR";
            }
            case 4: {
                return "SCTP_SEND_FAILED";
            }
            case 5: {
                return "SCTP_SHUTDOWN_EVENT";
            }
            case 6: {
                return "SCTP_ADAPTATION_INDICATION";
            }
            case 7: {
                return "SCTP_PARTIAL_DELIVERY_EVENT";
            }
            case 8: {
                return "SCTP_AUTHENTICATION_EVENT";
            }
            case 9: {
                return "SCTP_STREAM_RESET_EVENT";
            }
            case 10: {
                return "SCTP_SENDER_DRY_EVENT";
            }
            case 11: {
                return "SCTP_NOTIFICATIONS_STOPPED_EVENT";
            }
            case 12: {
                return "SCTP_ASSOC_RESET_EVENT";
            }
            case 13: {
                return "SCTP_STREAM_CHANGE_EVENT";
            }
            case 14: {
                return "SCTP_SEND_FAILED_EVENT";
            }
        }
        return "SCTP_NOTIFICATION_0x" + Integer.toHexString(this.sn_type);
    }

    public static SctpNotification parse(byte[] data) {
        int type = (data[1] & 0xFF) << 8 | data[0] & 0xFF;
        switch (type) {
            case 1: {
                return new AssociationChange(data);
            }
            case 2: {
                return new PeerAddressChange(data);
            }
            case 4: {
                return new SendFailed(data);
            }
            case 10: {
                return new SenderDry(data);
            }
            case 9: {
                return new StreamReset(data);
            }
        }
        return new SctpNotification(data);
    }

    public static class StreamReset
    extends SctpNotification {
        public static final int SCTP_STREAM_RESET_INCOMING_SSN = 1;
        public static final int SCTP_STREAM_RESET_OUTGOING_SSN = 2;
        public static final int SCTP_STREAM_RESET_DENIED = 4;
        public static final int SCTP_STREAM_RESET_FAILED = 8;
        public static final int SCTP_STREAM_CHANGED_DENIED = 16;
        public static final int SCTP_STREAM_RESET_INCOMING = 1;
        public static final int SCTP_STREAM_RESET_OUTGOING = 2;

        private StreamReset(byte[] data) {
            super(data);
        }
    }

    public static class SenderDry
    extends SctpNotification {
        private final long assocId;

        private SenderDry(byte[] data) {
            super(data);
            this.assocId = this.buffer.getInt();
        }

        @Override
        public String toString() {
            Object base = super.toString();
            base = (String)base + ",assocID:0x" + Long.toHexString(this.assocId);
            return base;
        }
    }

    public static class SendFailed
    extends SctpNotification {
        public static final int SCTP_DATA_UNSENT = 1;
        public static final int SCTP_DATA_SENT = 2;
        public final long error;

        private SendFailed(byte[] data) {
            super(data);
            this.error = this.buffer.getInt();
        }

        @Override
        public String toString() {
            Object base = super.toString();
            if ((this.sn_flags & 2) > 0) {
                base = (String)base + ",DATA_SENT";
            }
            if ((this.sn_flags & 1) > 0) {
                base = (String)base + ",DATA_UNSENT";
            }
            base = (String)base + ",err0x" + Long.toHexString(this.error);
            return base;
        }
    }

    public static class PeerAddressChange
    extends SctpNotification {
        public static final int SCTP_ADDR_AVAILABLE = 1;
        public static final int SCTP_ADDR_UNREACHABLE = 2;
        public static final int SCTP_ADDR_REMOVED = 3;
        public static final int SCTP_ADDR_ADDED = 4;
        public static final int SCTP_ADDR_MADE_PRIM = 5;
        public static final int SCTP_ADDR_CONFIRMED = 6;
        public final int state;
        public final long error;
        public final long assocId;

        private PeerAddressChange(byte[] data) {
            super(data);
            int sockAddrStorageLen = data.length - 24;
            this.buffer.position(this.buffer.position() + sockAddrStorageLen);
            this.state = this.buffer.getInt();
            this.error = this.buffer.getInt();
            this.assocId = this.buffer.getInt();
        }

        @Override
        public String toString() {
            Object base = super.toString();
            base = (String)base + ",assocId:0x" + Long.toHexString(this.assocId);
            switch (this.state) {
                case 1: {
                    base = (String)base + ",ADDR_AVAILABLE";
                    break;
                }
                case 2: {
                    base = (String)base + ",ADDR_UNREACHABLE";
                    break;
                }
                case 3: {
                    base = (String)base + ",ADDR_REMOVED";
                    break;
                }
                case 4: {
                    base = (String)base + ",ADDR_ADDED";
                    break;
                }
                case 5: {
                    base = (String)base + ",ADDR_MADE_PRIM";
                    break;
                }
                case 6: {
                    base = (String)base + ",ADDR_CONFIRMED";
                    break;
                }
                default: {
                    base = (String)base + "," + Integer.toHexString(this.state);
                }
            }
            base = (String)base + ",err:" + Long.toHexString(this.error);
            return base;
        }
    }

    public static class AssociationChange
    extends SctpNotification {
        public static final int SCTP_COMM_UP = 1;
        public static final int SCTP_COMM_LOST = 2;
        public static final int SCTP_RESTART = 3;
        public static final int SCTP_SHUTDOWN_COMP = 4;
        public static final int SCTP_CANT_STR_ASSOC = 5;
        public static final int SCTP_ASSOC_SUPPORTS_PR = 1;
        public static final int SCTP_ASSOC_SUPPORTS_AUTH = 2;
        public static final int SCTP_ASSOC_SUPPORTS_ASCONF = 3;
        public static final int SCTP_ASSOC_SUPPORTS_MULTIBUF = 4;
        public static final int SCTP_ASSOC_SUPPORTS_RE_CONFIG = 5;
        public static final int SCTP_ASSOC_SUPPORTS_MAX = 5;
        public final int state;
        public final int error;
        public final int outboundStreams;
        public final int inboundStreams;
        public final long assocId;

        private AssociationChange(byte[] data) {
            super(data);
            this.state = this.buffer.getChar();
            this.error = this.buffer.getChar();
            this.outboundStreams = this.buffer.getChar();
            this.inboundStreams = this.buffer.getChar();
            this.assocId = this.buffer.getInt();
        }

        @Override
        public String toString() {
            Object str = super.toString();
            str = (String)str + ":assocId:0x" + Long.toHexString(this.assocId);
            switch (this.state) {
                case 1: {
                    str = (String)str + ",COMM_UP";
                    break;
                }
                case 2: {
                    str = (String)str + ",COMM_LOST";
                    break;
                }
                case 3: {
                    str = (String)str + ",RESTART";
                    break;
                }
                case 4: {
                    str = (String)str + ",SHUTDOWN_COMP";
                    break;
                }
                case 5: {
                    str = (String)str + ",CANT_STR_ASSOC";
                    break;
                }
                default: {
                    str = (String)str + ",0x" + Integer.toHexString(this.state);
                }
            }
            str = (String)str + ",(in/out)(" + this.inboundStreams + "/" + this.outboundStreams + ")";
            str = (String)str + ",err0x" + Integer.toHexString(this.error);
            return str;
        }
    }
}

