/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddColumnStatement;
import liquibase.statement.core.CreateDatabaseChangeLogTableStatement;
import liquibase.statement.core.SetNullableStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.structure.core.Column;
import liquibase.structure.core.Table;
import liquibase.util.StreamUtil;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.entityprovider.JpaEntityProvider;
import org.keycloak.connections.jpa.updater.JpaUpdaterProvider;
import org.keycloak.connections.jpa.updater.liquibase.ThreadLocalSessionContext;
import org.keycloak.connections.jpa.updater.liquibase.conn.CustomChangeLogHistoryService;
import org.keycloak.connections.jpa.updater.liquibase.conn.KeycloakLiquibase;
import org.keycloak.connections.jpa.updater.liquibase.conn.LiquibaseConnectionProvider;
import org.keycloak.connections.jpa.util.JpaUtils;
import org.keycloak.models.KeycloakSession;

public class LiquibaseJpaUpdaterProvider
implements JpaUpdaterProvider {
    private static final Logger logger = Logger.getLogger(LiquibaseJpaUpdaterProvider.class);
    public static final String CHANGELOG = "META-INF/jpa-changelog-master.xml";
    public static final String DEPLOYMENT_ID_COLUMN = "DEPLOYMENT_ID";
    private final KeycloakSession session;

    public LiquibaseJpaUpdaterProvider(KeycloakSession session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Connection connection, String defaultSchema) {
        Class<LiquibaseJpaUpdaterProvider> clazz = LiquibaseJpaUpdaterProvider.class;
        synchronized (LiquibaseJpaUpdaterProvider.class) {
            this.updateSynch(connection, null, defaultSchema);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(Connection connection, String defaultSchema, File file) {
        Class<LiquibaseJpaUpdaterProvider> clazz = LiquibaseJpaUpdaterProvider.class;
        synchronized (LiquibaseJpaUpdaterProvider.class) {
            this.updateSynch(connection, file, defaultSchema);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private void updateSynch(Connection connection, File file, String defaultSchema) {
        logger.debug((Object)"Starting database update");
        ThreadLocalSessionContext.setCurrentSession(this.session);
        Writer exportWriter = null;
        try {
            KeycloakLiquibase liquibase = this.getLiquibaseForKeycloakUpdate(connection, defaultSchema);
            if (file != null) {
                exportWriter = new FileWriter(file);
            }
            this.updateChangeSet(liquibase, exportWriter);
            Set jpaProviders = this.session.getAllProviders(JpaEntityProvider.class);
            for (JpaEntityProvider jpaProvider : jpaProviders) {
                String customChangelog = jpaProvider.getChangelogLocation();
                if (customChangelog == null) continue;
                String factoryId = jpaProvider.getFactoryId();
                String changelogTableName = JpaUtils.getCustomChangelogTableName(factoryId);
                liquibase = this.getLiquibaseForCustomProviderUpdate(connection, defaultSchema, customChangelog, jpaProvider.getClass().getClassLoader(), changelogTableName);
                this.updateChangeSet(liquibase, exportWriter);
            }
        }
        catch (IOException | SQLException | LiquibaseException e) {
            logger.error((Object)"Error has occurred while updating the database", e);
            throw new RuntimeException("Failed to update database", e);
        }
        finally {
            ThreadLocalSessionContext.removeCurrentSession();
            if (exportWriter != null) {
                try {
                    exportWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void updateChangeSet(KeycloakLiquibase liquibase, Writer exportWriter) throws LiquibaseException, SQLException {
        List<ChangeSet> changeSets;
        String changelog = liquibase.getChangeLogFile();
        Database database = liquibase.getDatabase();
        Table changelogTable = SnapshotGeneratorFactory.getInstance().getDatabaseChangeLogTable(new SnapshotControl(database, false, new Class[]{Table.class, Column.class}), database);
        if (changelogTable != null) {
            boolean hasDeploymentIdColumn;
            boolean bl = hasDeploymentIdColumn = changelogTable.getColumn(DEPLOYMENT_ID_COLUMN) != null;
            if (!hasDeploymentIdColumn) {
                ChangeLogHistoryService changelogHistoryService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database);
                changelogHistoryService.generateDeploymentId();
                String deploymentId = changelogHistoryService.getDeploymentId();
                logger.debugv("Adding missing column {0}={1} to {2} table", (Object)DEPLOYMENT_ID_COLUMN, (Object)deploymentId, (Object)changelogTable.getName());
                ArrayList<Object> statementsToExecute = new ArrayList<Object>();
                statementsToExecute.add(new AddColumnStatement(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), changelogTable.getName(), DEPLOYMENT_ID_COLUMN, "VARCHAR(10)", null, new ColumnConstraint[0]));
                statementsToExecute.add(new UpdateStatement(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), changelogTable.getName()).addNewColumnValue(DEPLOYMENT_ID_COLUMN, (Object)deploymentId));
                statementsToExecute.add(new SetNullableStatement(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), changelogTable.getName(), DEPLOYMENT_ID_COLUMN, "VARCHAR(10)", false));
                ExecutorService executorService = (ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class);
                Executor executor = executorService.getExecutor("jdbc", liquibase.getDatabase());
                for (SqlStatement sqlStatement : statementsToExecute) {
                    executor.execute(sqlStatement);
                    database.commit();
                }
            }
        }
        if (!(changeSets = this.getLiquibaseUnrunChangeSets(liquibase)).isEmpty()) {
            List ranChangeSets = liquibase.getDatabase().getRanChangeSetList();
            if (ranChangeSets.isEmpty()) {
                logger.infov("Initializing database schema. Using changelog {0}", (Object)changelog);
            } else if (logger.isDebugEnabled()) {
                logger.debugv("Updating database from {0} to {1}. Using changelog {2}", (Object)((RanChangeSet)ranChangeSets.get(ranChangeSets.size() - 1)).getId(), (Object)changeSets.get(changeSets.size() - 1).getId(), (Object)changelog);
            } else {
                logger.infov("Updating database. Using changelog {0}", (Object)changelog);
            }
            if (exportWriter != null) {
                if (ranChangeSets.isEmpty()) {
                    this.outputChangeLogTableCreationScript(liquibase, exportWriter);
                }
                liquibase.update(null, new LabelExpression(), exportWriter, false);
            } else {
                liquibase.update(null);
            }
            logger.debugv("Completed database update for changelog {0}", (Object)changelog);
        } else {
            logger.debugv("Database is up to date for changelog {0}", (Object)changelog);
        }
        this.resetLiquibaseServices(liquibase);
    }

    private void outputChangeLogTableCreationScript(Liquibase liquibase, Writer exportWriter) throws DatabaseException {
        Database database = liquibase.getDatabase();
        ExecutorService executorService = (ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class);
        Executor oldTemplate = executorService.getExecutor("jdbc", database);
        LoggingExecutor loggingExecutor = new LoggingExecutor(oldTemplate, exportWriter, database);
        executorService.setExecutor("jdbc", database, (Executor)loggingExecutor);
        loggingExecutor.comment("*********************************************************************");
        loggingExecutor.comment("* Keycloak database creation script - apply this script to empty DB *");
        loggingExecutor.comment("*********************************************************************" + StreamUtil.getLineSeparator());
        loggingExecutor.execute((SqlStatement)new CreateDatabaseChangeLogTableStatement());
        loggingExecutor.comment("*********************************************************************" + StreamUtil.getLineSeparator());
        executorService.setExecutor("jdbc", database, oldTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JpaUpdaterProvider.Status validate(Connection connection, String defaultSchema) {
        Class<LiquibaseJpaUpdaterProvider> clazz = LiquibaseJpaUpdaterProvider.class;
        synchronized (LiquibaseJpaUpdaterProvider.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.validateSynch(connection, defaultSchema);
        }
    }

    protected JpaUpdaterProvider.Status validateSynch(Connection connection, String defaultSchema) {
        logger.debug((Object)"Validating if database is updated");
        ThreadLocalSessionContext.setCurrentSession(this.session);
        try {
            KeycloakLiquibase liquibase = this.getLiquibaseForKeycloakUpdate(connection, defaultSchema);
            JpaUpdaterProvider.Status status = this.validateChangeSet(liquibase, liquibase.getChangeLogFile());
            if (status != JpaUpdaterProvider.Status.VALID) {
                return status;
            }
            Set jpaProviders = this.session.getAllProviders(JpaEntityProvider.class);
            for (JpaEntityProvider jpaProvider : jpaProviders) {
                String customChangelog = jpaProvider.getChangelogLocation();
                if (customChangelog == null) continue;
                String factoryId = jpaProvider.getFactoryId();
                String changelogTableName = JpaUtils.getCustomChangelogTableName(factoryId);
                liquibase = this.getLiquibaseForCustomProviderUpdate(connection, defaultSchema, customChangelog, jpaProvider.getClass().getClassLoader(), changelogTableName);
                if (this.validateChangeSet(liquibase, liquibase.getChangeLogFile()) == JpaUpdaterProvider.Status.VALID) continue;
                return JpaUpdaterProvider.Status.OUTDATED;
            }
        }
        catch (LiquibaseException e) {
            throw new RuntimeException("Failed to validate database", e);
        }
        return JpaUpdaterProvider.Status.VALID;
    }

    protected JpaUpdaterProvider.Status validateChangeSet(KeycloakLiquibase liquibase, String changelog) throws LiquibaseException {
        JpaUpdaterProvider.Status result;
        List<ChangeSet> changeSets = this.getLiquibaseUnrunChangeSets(liquibase);
        if (!changeSets.isEmpty()) {
            if (changeSets.size() == liquibase.getDatabaseChangeLog().getChangeSets().size()) {
                result = JpaUpdaterProvider.Status.EMPTY;
            } else {
                logger.debugf("Validation failed. Database is not up-to-date for changelog %s", (Object)changelog);
                result = JpaUpdaterProvider.Status.OUTDATED;
            }
        } else {
            logger.debugf("Validation passed. Database is up-to-date for changelog %s", (Object)changelog);
            result = JpaUpdaterProvider.Status.VALID;
        }
        this.resetLiquibaseServices(liquibase);
        return result;
    }

    private void resetLiquibaseServices(KeycloakLiquibase liquibase) {
        liquibase.resetServices();
        ChangeLogHistoryServiceFactory.getInstance().register((ChangeLogHistoryService)new CustomChangeLogHistoryService());
    }

    private List<ChangeSet> getLiquibaseUnrunChangeSets(Liquibase liquibase) throws LiquibaseException {
        return liquibase.listUnrunChangeSets(null, new LabelExpression(), false);
    }

    private KeycloakLiquibase getLiquibaseForKeycloakUpdate(Connection connection, String defaultSchema) throws LiquibaseException {
        LiquibaseConnectionProvider liquibaseProvider = (LiquibaseConnectionProvider)this.session.getProvider(LiquibaseConnectionProvider.class);
        return liquibaseProvider.getLiquibase(connection, defaultSchema);
    }

    private KeycloakLiquibase getLiquibaseForCustomProviderUpdate(Connection connection, String defaultSchema, String changelogLocation, ClassLoader classloader, String changelogTableName) throws LiquibaseException {
        LiquibaseConnectionProvider liquibaseProvider = (LiquibaseConnectionProvider)this.session.getProvider(LiquibaseConnectionProvider.class);
        return liquibaseProvider.getLiquibaseForCustomUpdate(connection, defaultSchema, changelogLocation, classloader, changelogTableName);
    }

    public void close() {
    }

    public static String getTable(String table, String defaultSchema) {
        return defaultSchema != null ? defaultSchema + "." + table : table;
    }
}

