/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

@ProtoTypeId(value=65555)
public class SessionEntityWrapper<S extends SessionEntity> {
    private final UUID version;
    private final S entity;
    private final Map<String, String> localMetadata;

    protected SessionEntityWrapper(UUID version, Map<String, String> localMetadata, S entity) {
        if (version == null) {
            throw new IllegalArgumentException("Version UUID can't be null");
        }
        this.version = version;
        this.localMetadata = localMetadata;
        this.entity = entity;
    }

    public SessionEntityWrapper(Map<String, String> localMetadata, S entity) {
        this(UUID.randomUUID(), localMetadata, entity);
    }

    public SessionEntityWrapper(S entity) {
        this(new ConcurrentHashMap<String, String>(), entity);
    }

    private SessionEntityWrapper(S entity, boolean forTransport) {
        if (!forTransport) {
            throw new IllegalArgumentException("This constructor is only for transport entities");
        }
        this.version = null;
        this.localMetadata = null;
        this.entity = entity;
    }

    public static <S extends SessionEntity> SessionEntityWrapper<S> forTransport(S entity) {
        return new SessionEntityWrapper<S>(entity, true);
    }

    public SessionEntityWrapper<S> forTransport() {
        return new SessionEntityWrapper<S>(this.entity, true);
    }

    private boolean isForTransport() {
        return this.version == null;
    }

    @ProtoField(value=1)
    public UUID getVersion() {
        return this.version;
    }

    public S getEntity() {
        return this.entity;
    }

    @ProtoField(value=2)
    WrappedMessage getEntityPS() {
        return new WrappedMessage(this.getEntity());
    }

    @ProtoField(value=3, mapImplementation=ConcurrentHashMap.class)
    public Map<String, String> getLocalMetadata() {
        return this.localMetadata;
    }

    @ProtoFactory
    static <T extends SessionEntity> SessionEntityWrapper<T> create(UUID version, WrappedMessage entityPS, Map<String, String> localMetadata) {
        assert (entityPS != null);
        SessionEntity entity = (SessionEntity)entityPS.getValue();
        if (version == null) {
            return new SessionEntityWrapper<SessionEntity>(entity);
        }
        return new SessionEntityWrapper<SessionEntity>(version, localMetadata, entity);
    }

    public ClientModel getClientIfNeeded(RealmModel realm) {
        String clientId;
        if (this.entity instanceof AuthenticatedClientSessionEntity && (clientId = ((AuthenticatedClientSessionEntity)this.entity).getClientId()) != null) {
            return realm.getClientById(clientId);
        }
        return null;
    }

    public String getLocalMetadataNote(String key) {
        if (this.isForTransport()) {
            throw new IllegalStateException("This entity is only intended for transport");
        }
        return this.localMetadata.get(key);
    }

    public Integer getLocalMetadataNoteInt(String key) {
        String note = this.getLocalMetadataNote(key);
        return note == null ? null : Integer.valueOf(note);
    }

    public void putLocalMetadataNoteInt(String key, int value) {
        if (this.isForTransport()) {
            throw new IllegalStateException("This entity is only intended for transport");
        }
        this.localMetadata.put(key, String.valueOf(value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SessionEntityWrapper)) {
            return false;
        }
        SessionEntityWrapper that = (SessionEntityWrapper)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.entity, that.entity);
    }

    public int hashCode() {
        return Objects.hashCode(this.version) * 17 + Objects.hashCode(this.entity);
    }

    public String toString() {
        return "SessionEntityWrapper{version=" + this.version + ", entity=" + this.entity + ", localMetadata=" + this.localMetadata + "}";
    }
}

