/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import org.keycloak.crypto.SignatureVerifierContext;

public class IssuerSignedJwtVerificationOpts {
    private final SignatureVerifierContext verifier;
    private final boolean validateIssuedAtClaim;
    private final boolean validateExpirationClaim;
    private final boolean validateNotBeforeClaim;

    public IssuerSignedJwtVerificationOpts(SignatureVerifierContext verifier, boolean validateIssuedAtClaim, boolean validateExpirationClaim, boolean validateNotBeforeClaim) {
        this.verifier = verifier;
        this.validateIssuedAtClaim = validateIssuedAtClaim;
        this.validateExpirationClaim = validateExpirationClaim;
        this.validateNotBeforeClaim = validateNotBeforeClaim;
    }

    public SignatureVerifierContext getVerifier() {
        return this.verifier;
    }

    public boolean mustValidateIssuedAtClaim() {
        return this.validateIssuedAtClaim;
    }

    public boolean mustValidateExpirationClaim() {
        return this.validateExpirationClaim;
    }

    public boolean mustValidateNotBeforeClaim() {
        return this.validateNotBeforeClaim;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SignatureVerifierContext verifier;
        private boolean validateIssuedAtClaim;
        private boolean validateExpirationClaim = true;
        private boolean validateNotBeforeClaim = true;

        public Builder withVerifier(SignatureVerifierContext verifier) {
            this.verifier = verifier;
            return this;
        }

        public Builder withValidateIssuedAtClaim(boolean validateIssuedAtClaim) {
            this.validateIssuedAtClaim = validateIssuedAtClaim;
            return this;
        }

        public Builder withValidateExpirationClaim(boolean validateExpirationClaim) {
            this.validateExpirationClaim = validateExpirationClaim;
            return this;
        }

        public Builder withValidateNotBeforeClaim(boolean validateNotBeforeClaim) {
            this.validateNotBeforeClaim = validateNotBeforeClaim;
            return this;
        }

        public IssuerSignedJwtVerificationOpts build() {
            return new IssuerSignedJwtVerificationOpts(this.verifier, this.validateIssuedAtClaim, this.validateExpirationClaim, this.validateNotBeforeClaim);
        }
    }
}

