/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.signing;

import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import org.keycloak.common.util.Base64;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.TimeProvider;
import org.keycloak.protocol.oid4vc.issuance.VCIssuanceContext;
import org.keycloak.protocol.oid4vc.issuance.signing.SigningService;
import org.keycloak.protocol.oid4vc.issuance.signing.SigningServiceException;
import org.keycloak.protocol.oid4vc.issuance.signing.vcdm.Ed255192018Suite;
import org.keycloak.protocol.oid4vc.issuance.signing.vcdm.LinkedDataCryptographicSuite;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.protocol.oid4vc.model.vcdm.LdProof;

public class LDSigningService
extends SigningService<VerifiableCredential> {
    private final LinkedDataCryptographicSuite linkedDataCryptographicSuite;
    private final TimeProvider timeProvider;
    private final String keyId;

    /*
     * Unable to fully structure code
     */
    public LDSigningService(KeycloakSession keycloakSession, String keyId, String algorithmType, String ldpType, TimeProvider timeProvider, Optional<String> kid) {
        super(keycloakSession, keyId, "ldp_vc", algorithmType);
        this.timeProvider = timeProvider;
        this.keyId = kid.orElse(keyId);
        signingKey = this.getKey(keyId, algorithmType);
        if (signingKey == null) {
            throw new SigningServiceException(String.format("No key for id %s and algorithm %s available.", new Object[]{keyId, algorithmType}));
        }
        if (kid.isPresent()) {
            signingKey = signingKey.cloneKey();
            signingKey.setKid(keyId);
        }
        signatureProvider = (SignatureProvider)keycloakSession.getProvider(SignatureProvider.class, algorithmType);
        var9_9 = ldpType;
        var10_10 = -1;
        switch (var9_9.hashCode()) {
            case -1632410942: {
                if (!var9_9.equals("Ed25519Signature2018")) break;
                var10_10 = 0;
            }
        }
        switch (var10_10) {
            case 0: {
                ** break;
            }
            default: {
                throw new SigningServiceException(String.format("Proof Type %s is not supported.", new Object[]{ldpType}));
            }
lbl-1000:
            // 1 sources

            {
                this.linkedDataCryptographicSuite = new Ed255192018Suite(signatureProvider.signer(signingKey));
            }
        }
    }

    @Override
    public VerifiableCredential signCredential(VCIssuanceContext vcIssuanceContext) {
        return this.addProof(vcIssuanceContext.getVerifiableCredential());
    }

    private VerifiableCredential addProof(VerifiableCredential verifiableCredential) {
        byte[] signature = this.linkedDataCryptographicSuite.getSignature(verifiableCredential);
        LdProof ldProof = new LdProof();
        ldProof.setProofPurpose("assertionMethod");
        ldProof.setType(this.linkedDataCryptographicSuite.getProofType());
        ldProof.setCreated(Date.from(Instant.ofEpochSecond(this.timeProvider.currentTimeSeconds())));
        ldProof.setVerificationMethod(this.keyId);
        try {
            String proofValue = Base64.encodeBytes((byte[])signature, (int)16);
            ldProof.setProofValue(proofValue);
            verifiableCredential.setAdditionalProperties("proof", ldProof);
            return verifiableCredential;
        }
        catch (IOException e) {
            throw new SigningServiceException("Was not able to encode the signature.", e);
        }
    }
}

