/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.List;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.collection.LoadingCollectionEntry;
import org.hibernate.sql.results.graph.collection.internal.AbstractCollectionInitializer;
import org.hibernate.sql.results.internal.LoadingCollectionEntryImpl;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractImmediateCollectionInitializer<Data extends ImmediateCollectionInitializerData>
extends AbstractCollectionInitializer<Data>
implements BiConsumer<Data, List<Object>> {
    protected final @Nullable DomainResultAssembler<?> collectionValueKeyResultAssembler;

    public AbstractImmediateCollectionInitializer(NavigablePath collectionPath, PluralAttributeMapping collectionAttributeMapping, InitializerParent<?> parent, LockMode lockMode, DomainResult<?> collectionKeyResult, DomainResult<?> collectionValueKeyResult, boolean isResultInitializer, AssemblerCreationState creationState) {
        super(collectionPath, collectionAttributeMapping, parent, collectionKeyResult, isResultInitializer, creationState);
        this.collectionValueKeyResultAssembler = collectionKeyResult == collectionValueKeyResult ? null : collectionValueKeyResult.createResultAssembler(this, creationState);
    }

    @Override
    protected ImmediateCollectionInitializerData createInitializerData(RowProcessingState rowProcessingState) {
        return new ImmediateCollectionInitializerData(this, rowProcessingState);
    }

    @Override
    protected void forEachSubInitializer(BiConsumer<Initializer<?>, RowProcessingState> consumer, InitializerData data) {
        Initializer<?> initializer;
        super.forEachSubInitializer(consumer, data);
        if (this.collectionValueKeyResultAssembler != null && (initializer = this.collectionValueKeyResultAssembler.getInitializer()) != null) {
            consumer.accept(initializer, data.getRowProcessingState());
        }
    }

    @Override
    public void resolveKey(Data data) {
        if (((InitializerData)data).getState() != Initializer.State.UNINITIALIZED) {
            return;
        }
        super.resolveKey(data);
        ((ImmediateCollectionInitializerData)data).collectionValueKey = null;
        if (((InitializerData)data).getState() != Initializer.State.MISSING && !((ImmediateCollectionInitializerData)data).shallowCached) {
            if (this.collectionValueKeyResultAssembler == null) {
                this.resolveKeySubInitializers(data);
            } else {
                this.resolveCollectionContentKey(data);
            }
        }
    }

    @Override
    public void resolveState(Data data) {
        DomainResultAssembler<?> elementAssembler;
        DomainResultAssembler<?> indexAssembler;
        super.resolveState(data);
        if (this.collectionValueKeyResultAssembler != null) {
            this.collectionValueKeyResultAssembler.resolveState(((InitializerData)data).getRowProcessingState());
        }
        if ((indexAssembler = this.getIndexAssembler()) != null) {
            indexAssembler.resolveState(((InitializerData)data).getRowProcessingState());
        }
        if ((elementAssembler = this.getElementAssembler()) != null) {
            elementAssembler.resolveState(((InitializerData)data).getRowProcessingState());
        }
    }

    @Override
    public void resolveFromPreviousRow(Data data) {
        super.resolveFromPreviousRow(data);
        if (((InitializerData)data).getState() == Initializer.State.RESOLVED) {
            this.resolveKeySubInitializers(data);
        }
    }

    private boolean resolveCollectionContentKey(Data data) {
        assert (this.collectionValueKeyResultAssembler != null);
        RowProcessingState rowProcessingState = ((InitializerData)data).getRowProcessingState();
        Initializer<?> initializer = this.collectionValueKeyResultAssembler.getInitializer();
        if (initializer != null) {
            Object subData = initializer.getData(rowProcessingState);
            initializer.resolveKey(subData);
            if (((InitializerData)subData).getState() == Initializer.State.MISSING) {
                return true;
            }
        } else {
            ((ImmediateCollectionInitializerData)data).collectionValueKey = this.collectionValueKeyResultAssembler.assemble(rowProcessingState);
            if (((ImmediateCollectionInitializerData)data).collectionValueKey == null) {
                return true;
            }
        }
        this.resolveKeySubInitializers(data);
        return false;
    }

    private void resolveKeySubInitializers(Data data) {
        Initializer<?> elementInitializer;
        Initializer<?> indexInitializer;
        RowProcessingState rowProcessingState = ((InitializerData)data).getRowProcessingState();
        DomainResultAssembler<?> indexAssembler = this.getIndexAssembler();
        if (indexAssembler != null && (indexInitializer = indexAssembler.getInitializer()) != null) {
            indexInitializer.resolveKey(rowProcessingState);
        }
        if ((elementInitializer = this.getElementAssembler().getInitializer()) != null) {
            elementInitializer.resolveKey(rowProcessingState);
        }
    }

    @Override
    public void resolveInstance(Data data) {
        if (((InitializerData)data).getState() != Initializer.State.KEY_RESOLVED) {
            return;
        }
        this.resolveCollectionKey(data, this.isResultInitializer);
        if (((InitializerData)data).getState() != Initializer.State.KEY_RESOLVED) {
            return;
        }
        ((InitializerData)data).setState(Initializer.State.RESOLVED);
        ((ImmediateCollectionInitializerData)data).responsibility = null;
        RowProcessingState rowProcessingState = ((InitializerData)data).getRowProcessingState();
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        CollectionKey collectionKey = ((ImmediateCollectionInitializerData)data).collectionKey;
        assert (collectionKey != null);
        LoadingCollectionEntry existingLoadingEntry = persistenceContext.getLoadContexts().findLoadingCollectionEntry(collectionKey);
        if (existingLoadingEntry != null) {
            ((AbstractCollectionInitializer.CollectionInitializerData)data).setCollectionInstance(existingLoadingEntry.getCollectionInstance());
            if (existingLoadingEntry.getInitializer() == this) {
                assert (!((ImmediateCollectionInitializerData)data).shallowCached);
                ((ImmediateCollectionInitializerData)data).responsibility = (LoadingCollectionEntryImpl)existingLoadingEntry;
            } else {
                ((InitializerData)data).setState(Initializer.State.INITIALIZED);
            }
        } else {
            PersistentCollection<?> existing = persistenceContext.getCollection(collectionKey);
            if (existing != null) {
                ((AbstractCollectionInitializer.CollectionInitializerData)data).setCollectionInstance(existing);
                if (existing.wasInitialized()) {
                    ((InitializerData)data).setState(Initializer.State.INITIALIZED);
                } else if (!((ImmediateCollectionInitializerData)data).shallowCached) {
                    this.takeResponsibility(data);
                }
            } else {
                PersistentCollection<?> existingUnowned = persistenceContext.useUnownedCollection(collectionKey);
                if (existingUnowned != null) {
                    ((AbstractCollectionInitializer.CollectionInitializerData)data).setCollectionInstance(existingUnowned);
                    if (existingUnowned.wasInitialized()) {
                        ((InitializerData)data).setState(Initializer.State.INITIALIZED);
                    } else if (!((ImmediateCollectionInitializerData)data).shallowCached) {
                        this.takeResponsibility(data);
                    }
                } else {
                    CollectionPersister collectionDescriptor = this.getCollectionAttributeMapping().getCollectionDescriptor();
                    CollectionSemantics<?, ?> collectionSemantics = collectionDescriptor.getCollectionSemantics();
                    PersistentCollection<?> persistentCollection = collectionSemantics.instantiateWrapper(collectionKey.getKey(), this.getInitializingCollectionDescriptor(), session);
                    ((AbstractCollectionInitializer.CollectionInitializerData)data).setCollectionInstance(persistentCollection);
                    if (this.owningEntityInitializer != null) {
                        assert (this.owningEntityInitializer.getTargetInstance(rowProcessingState) != null);
                        ((AbstractCollectionInitializer.CollectionInitializerData)data).getCollectionInstance().setOwner(this.owningEntityInitializer.getTargetInstance(rowProcessingState));
                    }
                    persistenceContext.addUninitializedCollection(collectionDescriptor, persistentCollection, collectionKey.getKey());
                    if (!((ImmediateCollectionInitializerData)data).shallowCached) {
                        this.takeResponsibility(data);
                    }
                }
            }
        }
        if (((ImmediateCollectionInitializerData)data).shallowCached) {
            assert (((ImmediateCollectionInitializerData)data).responsibility == null);
            this.initializeShallowCached(data);
        }
    }

    protected void initializeShallowCached(Data data) {
        assert (((ImmediateCollectionInitializerData)data).shallowCached);
        PersistenceContext persistenceContext = ((InitializerData)data).getRowProcessingState().getSession().getPersistenceContextInternal();
        PersistentCollection<?> collectionInstance = ((AbstractCollectionInitializer.CollectionInitializerData)data).getCollectionInstance();
        assert (collectionInstance != null);
        collectionInstance.forceInitialization();
        if (this.collectionAttributeMapping.getCollectionDescriptor().getCollectionSemantics().getCollectionClassification() == CollectionClassification.ARRAY) {
            persistenceContext.addCollectionHolder(collectionInstance);
        }
        ((InitializerData)data).setState(Initializer.State.INITIALIZED);
        this.initializeSubInstancesFromParent(data);
    }

    @Override
    protected void setMissing(Data data) {
        super.setMissing(data);
        ((ImmediateCollectionInitializerData)data).collectionValueKey = null;
        ((ImmediateCollectionInitializerData)data).responsibility = null;
    }

    @Override
    public void resolveInstance(Object instance, Data data) {
        PersistentCollection<Object> persistentCollection;
        assert (((InitializerData)data).getState() == Initializer.State.UNINITIALIZED || instance == ((AbstractCollectionInitializer.CollectionInitializerData)data).getCollectionInstance());
        if (instance == null) {
            this.setMissing(data);
            return;
        }
        RowProcessingState rowProcessingState = ((InitializerData)data).getRowProcessingState();
        if (((AbstractCollectionInitializer.CollectionInitializerData)data).getCollectionInstance() != instance) {
            PersistenceContext persistenceContext = rowProcessingState.getSession().getPersistenceContextInternal();
            persistentCollection = this.collectionAttributeMapping.getCollectionDescriptor().getCollectionSemantics().getCollectionClassification() == CollectionClassification.ARRAY ? persistenceContext.getCollectionHolder(instance) : (PersistentCollection)instance;
            ((ImmediateCollectionInitializerData)data).collectionKeyValue = persistentCollection.getKey();
            this.resolveCollectionKey(data, false);
            ((AbstractCollectionInitializer.CollectionInitializerData)data).setCollectionInstance(persistentCollection);
            ((ImmediateCollectionInitializerData)data).responsibility = null;
        } else {
            persistentCollection = (PersistentCollection<?>)instance;
        }
        ((ImmediateCollectionInitializerData)data).collectionValueKey = null;
        if (persistentCollection.wasInitialized()) {
            ((InitializerData)data).setState(Initializer.State.INITIALIZED);
            if (((ImmediateCollectionInitializerData)data).shallowCached) {
                this.initializeShallowCached(data);
            } else {
                this.resolveInstanceSubInitializers(data);
            }
            if (rowProcessingState.needsResolveState()) {
                if (this.collectionKeyResultAssembler != null) {
                    this.collectionKeyResultAssembler.resolveState(rowProcessingState);
                }
                if (!this.getInitializingCollectionDescriptor().useShallowQueryCacheLayout()) {
                    if (this.collectionValueKeyResultAssembler != null) {
                        this.collectionValueKeyResultAssembler.resolveState(rowProcessingState);
                    }
                    this.resolveCollectionContentState(rowProcessingState);
                }
            }
        } else if (((ImmediateCollectionInitializerData)data).shallowCached) {
            ((InitializerData)data).setState(Initializer.State.INITIALIZED);
            this.initializeShallowCached(data);
        } else {
            ((InitializerData)data).setState(Initializer.State.RESOLVED);
            boolean rowContainsCollectionContent = this.collectionValueKeyResultAssembler != null ? this.resolveCollectionContentKey(data) : true;
            if (((ImmediateCollectionInitializerData)data).responsibility == null) {
                LoadingCollectionEntry existingLoadingEntry = rowProcessingState.getSession().getPersistenceContextInternal().getLoadContexts().findLoadingCollectionEntry(((ImmediateCollectionInitializerData)data).collectionKey);
                if (existingLoadingEntry != null) {
                    if (existingLoadingEntry.getInitializer() == this) {
                        ((ImmediateCollectionInitializerData)data).responsibility = (LoadingCollectionEntryImpl)existingLoadingEntry;
                    } else {
                        ((InitializerData)data).setState(Initializer.State.INITIALIZED);
                        if (rowContainsCollectionContent && rowProcessingState.needsResolveState() && !this.getInitializingCollectionDescriptor().useShallowQueryCacheLayout()) {
                            this.resolveCollectionContentState(rowProcessingState);
                        }
                    }
                } else {
                    this.takeResponsibility(data);
                }
            }
        }
    }

    protected abstract void resolveInstanceSubInitializers(Data var1);

    private void resolveCollectionContentState(RowProcessingState rowProcessingState) {
        DomainResultAssembler<?> indexAssembler = this.getIndexAssembler();
        if (indexAssembler != null) {
            indexAssembler.resolveState(rowProcessingState);
        }
        this.getElementAssembler().resolveState(rowProcessingState);
    }

    protected void takeResponsibility(Data data) {
        ((ImmediateCollectionInitializerData)data).responsibility = new LoadingCollectionEntryImpl(this.getCollectionAttributeMapping().getCollectionDescriptor(), this, ((ImmediateCollectionInitializerData)data).collectionKey.getKey(), ((AbstractCollectionInitializer.CollectionInitializerData)data).getCollectionInstance());
        ((InitializerData)data).getRowProcessingState().getJdbcValuesSourceProcessingState().registerLoadingCollection(((ImmediateCollectionInitializerData)data).collectionKey, ((ImmediateCollectionInitializerData)data).responsibility);
    }

    @Override
    public void initializeInstance(Data data) {
        Initializer<?> initializer;
        if (((InitializerData)data).getState() != Initializer.State.RESOLVED || ((ImmediateCollectionInitializerData)data).responsibility == null) {
            return;
        }
        ((InitializerData)data).setState(Initializer.State.INITIALIZED);
        if (((ImmediateCollectionInitializerData)data).collectionValueKey == null && this.collectionValueKeyResultAssembler != null && (initializer = this.collectionValueKeyResultAssembler.getInitializer()) != null) {
            ((ImmediateCollectionInitializerData)data).collectionValueKey = this.collectionValueKeyResultAssembler.assemble(((InitializerData)data).getRowProcessingState());
        }
        if (this.collectionValueKeyResultAssembler == null || ((ImmediateCollectionInitializerData)data).collectionValueKey != null) {
            ((ImmediateCollectionInitializerData)data).responsibility.load(data, this);
        }
    }

    @Override
    public void initializeInstanceFromParent(Object parentInstance, Data data) {
        ((AbstractCollectionInitializer.CollectionInitializerData)data).setCollectionInstance((PersistentCollection)this.getInitializedPart().getValue(parentInstance));
        ((InitializerData)data).setState(Initializer.State.INITIALIZED);
        this.initializeSubInstancesFromParent(data);
    }

    @Override
    public void accept(Data data, List<Object> objects) {
        this.readCollectionRow(data, objects);
    }

    protected abstract void readCollectionRow(Data var1, List<Object> var2);

    protected abstract void initializeSubInstancesFromParent(Data var1);

    public abstract @Nullable DomainResultAssembler<?> getIndexAssembler();

    public abstract DomainResultAssembler<?> getElementAssembler();

    public static class ImmediateCollectionInitializerData
    extends AbstractCollectionInitializer.CollectionInitializerData {
        protected final boolean shallowCached;
        protected Object collectionValueKey;
        protected LoadingCollectionEntryImpl responsibility;

        public ImmediateCollectionInitializerData(AbstractImmediateCollectionInitializer<?> initializer, RowProcessingState rowProcessingState) {
            super(rowProcessingState);
            this.shallowCached = rowProcessingState.isQueryCacheHit() && initializer.getInitializingCollectionDescriptor().useShallowQueryCacheLayout();
        }
    }
}

