/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.List;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.PersistentBag;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.collection.spi.PersistentIdentifierBag;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.collection.internal.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class BagInitializer
extends AbstractImmediateCollectionInitializer<AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData> {
    private final DomainResultAssembler<?> elementAssembler;
    private final DomainResultAssembler<?> collectionIdAssembler;

    public BagInitializer(NavigablePath navigablePath, PluralAttributeMapping bagDescriptor, InitializerParent<?> parent, LockMode lockMode, DomainResult<?> collectionKeyResult, DomainResult<?> collectionValueKeyResult, boolean isResultInitializer, AssemblerCreationState creationState, Fetch elementFetch, @Nullable Fetch collectionIdFetch) {
        super(navigablePath, bagDescriptor, parent, lockMode, collectionKeyResult, collectionValueKeyResult, isResultInitializer, creationState);
        this.elementAssembler = elementFetch.createAssembler(this, creationState);
        this.collectionIdAssembler = collectionIdFetch == null ? null : collectionIdFetch.createAssembler(this, creationState);
    }

    @Override
    protected void forEachSubInitializer(BiConsumer<Initializer<?>, RowProcessingState> consumer, InitializerData data) {
        super.forEachSubInitializer(consumer, data);
        Initializer<?> initializer = this.elementAssembler.getInitializer();
        if (initializer != null) {
            consumer.accept(initializer, data.getRowProcessingState());
        }
    }

    @Override
    protected void readCollectionRow(AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData data, List<Object> loadingState) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        if (this.collectionIdAssembler != null) {
            Object collectionId = this.collectionIdAssembler.assemble(rowProcessingState);
            if (collectionId == null) {
                return;
            }
            Object element = this.elementAssembler.assemble(rowProcessingState);
            if (element == null) {
                return;
            }
            loadingState.add(new Object[]{collectionId, element});
        } else {
            Object element = this.elementAssembler.assemble(rowProcessingState);
            if (element != null) {
                loadingState.add(element);
            }
        }
    }

    @Override
    protected void initializeSubInstancesFromParent(AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData data) {
        block5: {
            Initializer<?> initializer = this.elementAssembler.getInitializer();
            if (initializer == null) break block5;
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            PersistentCollection<?> persistentCollection = this.getCollectionInstance(data);
            assert (persistentCollection != null);
            if (persistentCollection instanceof PersistentBag) {
                for (Object element : (PersistentBag)persistentCollection) {
                    initializer.initializeInstanceFromParent(element, rowProcessingState);
                }
            } else {
                for (Object element : (PersistentIdentifierBag)persistentCollection) {
                    initializer.initializeInstanceFromParent(element, rowProcessingState);
                }
            }
        }
    }

    @Override
    protected void resolveInstanceSubInitializers(AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData data) {
        block5: {
            Initializer<?> initializer = this.elementAssembler.getInitializer();
            if (initializer == null) break block5;
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            PersistentCollection<?> persistentCollection = this.getCollectionInstance(data);
            assert (persistentCollection != null);
            if (persistentCollection instanceof PersistentBag) {
                for (Object element : (PersistentBag)persistentCollection) {
                    initializer.resolveInstance(element, rowProcessingState);
                }
            } else {
                for (Object element : (PersistentIdentifierBag)persistentCollection) {
                    initializer.resolveInstance(element, rowProcessingState);
                }
            }
        }
    }

    @Override
    public DomainResultAssembler<?> getIndexAssembler() {
        return null;
    }

    @Override
    public DomainResultAssembler<?> getElementAssembler() {
        return this.elementAssembler;
    }

    public String toString() {
        return "BagInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

