/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.VirtualModelPart;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.metamodel.spi.ValueAccess;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResultAssembler;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchEntityInsideEmbeddableSelectFetchInitializer;
import org.hibernate.sql.results.graph.internal.AbstractInitializer;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class EmbeddableInitializerImpl
extends AbstractInitializer<EmbeddableInitializerData>
implements EmbeddableInitializer<EmbeddableInitializerData> {
    private final NavigablePath navigablePath;
    private final EmbeddableValuedModelPart embedded;
    private final EmbeddableMappingType embeddableMappingType;
    private final @Nullable InitializerParent<InitializerData> parent;
    private final boolean isResultInitializer;
    private final boolean isPartOfKey;
    private final boolean createEmptyCompositesEnabled;
    private final SessionFactoryImplementor sessionFactory;
    protected final DomainResultAssembler<?>[][] assemblers;
    protected final BasicResultAssembler<?> discriminatorAssembler;
    protected final @Nullable Initializer<InitializerData>[][] subInitializers;
    protected final @Nullable Initializer<InitializerData>[][] subInitializersForResolveFromInitialized;
    protected final boolean lazyCapable;
    protected final boolean hasLazySubInitializer;

    public EmbeddableInitializerImpl(EmbeddableResultGraphNode resultDescriptor, BasicFetch<?> discriminatorFetch, InitializerParent<?> parent, AssemblerCreationState creationState, boolean isResultInitializer) {
        super(creationState);
        this.navigablePath = resultDescriptor.getNavigablePath();
        this.embedded = resultDescriptor.getReferencedMappingContainer();
        this.parent = parent;
        this.isResultInitializer = isResultInitializer;
        this.embeddableMappingType = this.embedded.getEmbeddableTypeDescriptor();
        this.isPartOfKey = this.embedded.isEntityIdentifierMapping() || Initializer.isPartOfKey(this.navigablePath, parent);
        this.createEmptyCompositesEnabled = !this.isPartOfKey && this.embeddableMappingType.isCreateEmptyCompositesEnabled();
        this.sessionFactory = creationState.getSqlAstCreationContext().getSessionFactory();
        this.assemblers = this.createAssemblers(resultDescriptor, creationState, this.embeddableMappingType);
        this.discriminatorAssembler = discriminatorFetch != null ? (BasicResultAssembler)discriminatorFetch.createAssembler(this, creationState) : null;
        this.subInitializers = EmbeddableInitializerImpl.createInitializers(this.assemblers);
        @Nullable Initializer[][] eagerSubInitializers = new Initializer[this.subInitializers.length][];
        Arrays.fill((Object[])eagerSubInitializers, Initializer.EMPTY_ARRAY);
        boolean lazyCapable = false;
        boolean hasLazySubInitializers = false;
        for (int subclassId = 0; subclassId < this.subInitializers.length; ++subclassId) {
            Initializer<InitializerData>[] subInitializer = this.subInitializers[subclassId];
            for (int i = 0; i < subInitializer.length; ++i) {
                Initializer<InitializerData> initializer = subInitializer[i];
                if (initializer == null) continue;
                if (initializer.isEager()) {
                    if (eagerSubInitializers[subclassId] == Initializer.EMPTY_ARRAY) {
                        eagerSubInitializers[subclassId] = new Initializer[subInitializer.length];
                    }
                    eagerSubInitializers[subclassId][i] = initializer;
                    hasLazySubInitializers = hasLazySubInitializers || initializer.hasLazySubInitializers();
                } else {
                    hasLazySubInitializers = true;
                }
                lazyCapable = lazyCapable || initializer.isLazyCapable();
            }
        }
        this.subInitializersForResolveFromInitialized = EmbeddableInitializerImpl.isEnhancedForLazyLoading(this.embeddableMappingType) ? this.subInitializers : eagerSubInitializers;
        this.lazyCapable = lazyCapable;
        this.hasLazySubInitializer = hasLazySubInitializers;
    }

    private static boolean isEnhancedForLazyLoading(EmbeddableMappingType embeddableMappingType) {
        return ManagedTypeHelper.isPersistentAttributeInterceptableType(embeddableMappingType.getRepresentationStrategy().getMappedJavaType().getJavaTypeClass());
    }

    protected DomainResultAssembler<?>[][] createAssemblers(EmbeddableResultGraphNode resultDescriptor, AssemblerCreationState creationState, EmbeddableMappingType embeddableTypeDescriptor) {
        int size = embeddableTypeDescriptor.getNumberOfFetchables();
        DomainResultAssembler[] overallAssemblers = new DomainResultAssembler[size];
        for (int i = 0; i < size; ++i) {
            DomainResultAssembler<?> stateAssembler;
            Fetchable stateArrayContributor = embeddableTypeDescriptor.getFetchable(i);
            Fetch fetch = resultDescriptor.findFetch(stateArrayContributor);
            overallAssemblers[i] = stateAssembler = fetch == null ? new NullValueAssembler(stateArrayContributor.getJavaType()) : fetch.createAssembler(this, creationState);
        }
        if (embeddableTypeDescriptor.isPolymorphic()) {
            Collection<EmbeddableMappingType.ConcreteEmbeddableType> concreteEmbeddableTypes = embeddableTypeDescriptor.getConcreteEmbeddableTypes();
            DomainResultAssembler[][] assemblers = new DomainResultAssembler[concreteEmbeddableTypes.size()][];
            for (EmbeddableMappingType.ConcreteEmbeddableType concreteEmbeddableType : concreteEmbeddableTypes) {
                DomainResultAssembler[] subAssemblers = new DomainResultAssembler[overallAssemblers.length];
                for (int i = 0; i < overallAssemblers.length; ++i) {
                    if (!concreteEmbeddableType.declaresAttribute(i)) continue;
                    subAssemblers[i] = overallAssemblers[i];
                }
                assemblers[concreteEmbeddableType.getSubclassId()] = subAssemblers;
            }
            return assemblers;
        }
        return new DomainResultAssembler[][]{overallAssemblers};
    }

    protected static @Nullable Initializer<InitializerData>[][] createInitializers(DomainResultAssembler<?>[][] assemblers) {
        @Nullable Initializer[][] subInitializers = new Initializer[assemblers.length][];
        for (int i = 0; i < assemblers.length; ++i) {
            DomainResultAssembler<?>[] subAssemblers = assemblers[i];
            @Nullable Initializer[] initializers = new Initializer[subAssemblers.length];
            boolean empty = true;
            for (int j = 0; j < subAssemblers.length; ++j) {
                Initializer<?> initializer;
                DomainResultAssembler<?> assembler = subAssemblers[j];
                if (assembler == null || (initializer = assembler.getInitializer()) == null) continue;
                initializers[j] = initializer;
                empty = false;
            }
            subInitializers[i] = empty ? Initializer.EMPTY_ARRAY : initializers;
        }
        return subInitializers;
    }

    @Override
    public EmbeddableValuedModelPart getInitializedPart() {
        return this.embedded;
    }

    @Override
    public @Nullable InitializerParent<?> getParent() {
        return this.parent;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public boolean isResultInitializer() {
        return this.isResultInitializer;
    }

    @Override
    public boolean isPartOfKey() {
        return this.isPartOfKey;
    }

    @Override
    public boolean isEager() {
        return true;
    }

    @Override
    public boolean isLazyCapable() {
        return this.lazyCapable;
    }

    @Override
    public boolean hasLazySubInitializers() {
        return this.hasLazySubInitializer;
    }

    @Override
    protected InitializerData createInitializerData(RowProcessingState rowProcessingState) {
        return new EmbeddableInitializerData(this, rowProcessingState);
    }

    @Override
    public void resolveKey(EmbeddableInitializerData data) {
        if (data.getState() != Initializer.State.UNINITIALIZED) {
            return;
        }
        data.setInstance(null);
        if (this.discriminatorAssembler != null) {
            assert (this.embeddableMappingType.getDiscriminatorMapping() != null);
            Object discriminatorValue = this.discriminatorAssembler.extractRawValue(data.getRowProcessingState());
            EmbeddableMappingType.ConcreteEmbeddableType concreteEmbeddableType = data.concreteEmbeddableType = discriminatorValue == null ? null : this.embeddableMappingType.findSubtypeByDiscriminator(discriminatorValue);
        }
        if (this.isPartOfKey) {
            data.setState(Initializer.State.KEY_RESOLVED);
            if (this.subInitializers[data.getSubclassId()].length == 0) {
                this.resolveInstance(data);
            } else {
                this.resolveKeySubInitializers(data);
            }
        } else {
            super.resolveKey(data);
        }
    }

    private void resolveKeySubInitializers(EmbeddableInitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        for (Initializer<InitializerData> initializer : this.subInitializers[data.getSubclassId()]) {
            if (initializer == null) continue;
            InitializerData subData = initializer.getData(rowProcessingState);
            initializer.resolveKey(subData);
            if (subData.getState() != Initializer.State.MISSING) continue;
            data.setState(Initializer.State.MISSING);
            return;
        }
    }

    @Override
    public void resolveFromPreviousRow(EmbeddableInitializerData data) {
        if (data.getState() == Initializer.State.UNINITIALIZED) {
            if (data.getInstance() == null) {
                data.setState(Initializer.State.MISSING);
            } else {
                RowProcessingState rowProcessingState = data.getRowProcessingState();
                for (Initializer<InitializerData> initializer : this.subInitializers[data.getSubclassId()]) {
                    if (initializer == null) continue;
                    initializer.resolveFromPreviousRow(rowProcessingState);
                }
                data.setState(Initializer.State.INITIALIZED);
            }
        }
    }

    @Override
    public void resolveInstance(EmbeddableInitializerData data) {
        if (data.getState() != Initializer.State.KEY_RESOLVED) {
            return;
        }
        data.setState(Initializer.State.RESOLVED);
        this.extractRowState(data);
        this.prepareCompositeInstance(data);
    }

    @Override
    public void resolveInstance(@Nullable Object instance, EmbeddableInitializerData data) {
        if (instance == null) {
            data.setState(Initializer.State.MISSING);
            data.setInstance(null);
        } else {
            data.setState(Initializer.State.INITIALIZED);
            data.setInstance(instance);
            int subclassId = data.getSubclassId();
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            this.resolveInstanceSubInitializers(subclassId, instance, rowProcessingState);
            if (rowProcessingState.needsResolveState()) {
                for (DomainResultAssembler<?> assembler : this.assemblers[subclassId]) {
                    assembler.resolveState(rowProcessingState);
                }
            }
        }
    }

    private void resolveInstanceSubInitializers(int subclassId, Object instance, RowProcessingState rowProcessingState) {
        Initializer<InitializerData>[] initializers = this.subInitializersForResolveFromInitialized[subclassId];
        for (int i = 0; i < initializers.length; ++i) {
            Initializer<InitializerData> initializer = initializers[i];
            if (initializer == null) continue;
            Object subInstance = this.embeddableMappingType.getValue(instance, i);
            if (subInstance == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                initializer.resolveKey(rowProcessingState);
                continue;
            }
            initializer.resolveInstance(subInstance, rowProcessingState);
        }
    }

    @Override
    public void initializeInstance(EmbeddableInitializerData data) {
        if (data.getState() != Initializer.State.RESOLVED) {
            return;
        }
        data.setState(Initializer.State.INITIALIZED);
        if (this.embedded.getParentInjectionAttributePropertyAccess() != null || this.embedded instanceof VirtualModelPart) {
            this.handleParentInjection(data);
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(data.getInstance());
            if (lazyInitializer != null) {
                if (this.parent != null) {
                    this.embeddableMappingType.setValues(lazyInitializer.getImplementation(), data.rowState);
                } else {
                    Object target = this.embeddableMappingType.getRepresentationStrategy().getInstantiator().instantiate(data, this.sessionFactory);
                    lazyInitializer.setImplementation(target);
                }
            } else {
                this.embeddableMappingType.setValues(data.getInstance(), data.rowState);
            }
        }
    }

    @Override
    protected void forEachSubInitializer(BiConsumer<Initializer<?>, RowProcessingState> consumer, InitializerData data) {
        EmbeddableInitializerData embeddableInitializerData = (EmbeddableInitializerData)data;
        RowProcessingState rowProcessingState = embeddableInitializerData.getRowProcessingState();
        if (embeddableInitializerData.concreteEmbeddableType == null) {
            Initializer<InitializerData>[][] initializerArray = this.subInitializers;
            int n = initializerArray.length;
            for (int i = 0; i < n; ++i) {
                Initializer<InitializerData>[] initializers;
                for (Initializer<InitializerData> initializer : initializers = initializerArray[i]) {
                    if (initializer == null) continue;
                    consumer.accept(initializer, rowProcessingState);
                }
            }
        } else {
            for (Initializer<InitializerData> initializer : this.subInitializers[embeddableInitializerData.getSubclassId()]) {
                if (initializer == null) continue;
                consumer.accept(initializer, rowProcessingState);
            }
        }
    }

    @Override
    public void initializeInstanceFromParent(Object parentInstance, EmbeddableInitializerData data) {
        AttributeMapping attributeMapping = this.getInitializedPart().asAttributeMapping();
        Object instance = attributeMapping != null ? attributeMapping.getValue(parentInstance) : parentInstance;
        data.setInstance(instance);
        if (instance == null) {
            data.setState(Initializer.State.MISSING);
        } else {
            data.setState(Initializer.State.INITIALIZED);
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            for (Initializer<InitializerData> initializer : this.subInitializers[data.getSubclassId()]) {
                if (initializer == null) continue;
                initializer.initializeInstanceFromParent(instance, rowProcessingState);
            }
        }
    }

    private void prepareCompositeInstance(EmbeddableInitializerData data) {
        if (this.parent != null && this.embedded instanceof VirtualModelPart && !this.isPartOfKey && data.getState() != Initializer.State.MISSING) {
            Object subData = this.parent.getData(data.getRowProcessingState());
            this.parent.resolveInstance((InitializerData)subData);
            data.setInstance(this.parent.getResolvedInstance((InitializerData)subData));
            if (data.getState() == Initializer.State.INITIALIZED) {
                return;
            }
        }
        if (data.getInstance() == null) {
            data.setInstance(this.createCompositeInstance(data));
        }
    }

    private void extractRowState(EmbeddableInitializerData data) {
        boolean stateAllNull = true;
        DomainResultAssembler<?>[] subAssemblers = this.assemblers[data.getSubclassId()];
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        Object[] rowState = data.rowState;
        for (int i = 0; i < subAssemblers.length; ++i) {
            DomainResultAssembler<?> assembler = subAssemblers[i];
            Object contributorValue = assembler == null ? null : assembler.assemble(rowProcessingState);
            rowState[i] = contributorValue == BatchEntityInsideEmbeddableSelectFetchInitializer.BATCH_PROPERTY ? null : contributorValue;
            if (contributorValue != null) {
                stateAllNull = false;
                continue;
            }
            if (!this.isPartOfKey) continue;
            stateAllNull = true;
            break;
        }
        if (stateAllNull) {
            data.setState(Initializer.State.MISSING);
        }
    }

    @Override
    public void resolveState(EmbeddableInitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        for (DomainResultAssembler<?> assembler : this.assemblers[data.getSubclassId()]) {
            assembler.resolveState(rowProcessingState);
        }
    }

    private Object createCompositeInstance(EmbeddableInitializerData data) {
        if (data.getState() == Initializer.State.MISSING && !this.createEmptyCompositesEnabled) {
            return null;
        }
        EmbeddableInstantiator instantiator = data.concreteEmbeddableType == null ? this.embeddableMappingType.getRepresentationStrategy().getInstantiator() : data.concreteEmbeddableType.getInstantiator();
        Object instance = instantiator.instantiate(data, this.sessionFactory);
        data.setState(Initializer.State.RESOLVED);
        return instance;
    }

    private void handleParentInjection(EmbeddableInitializerData data) {
        PropertyAccess parentInjectionAccess = this.embedded.getParentInjectionAttributePropertyAccess();
        if (parentInjectionAccess == null) {
            return;
        }
        Initializer<?> owningInitializer = this.determineOwningInitializer();
        Object parent = this.determineParentInstance(owningInitializer, data.getRowProcessingState());
        if (parent == null) {
            return;
        }
        Setter setter = parentInjectionAccess.getSetter();
        assert (setter != null);
        setter.set(data.getInstance(), parent);
    }

    private Initializer<?> determineOwningInitializer() {
        for (InitializerParent<InitializerData> parent = this.parent; parent != null; parent = parent.getParent()) {
            if (parent.isEmbeddableInitializer()) continue;
            return parent;
        }
        throw new UnsupportedOperationException("Injection of parent instance into embeddable result is not possible");
    }

    private Object determineParentInstance(Initializer<?> parentInitializer, RowProcessingState rowProcessingState) {
        if (parentInitializer == null) {
            throw new UnsupportedOperationException("Cannot determine Embeddable: " + this.navigablePath + " parent instance, parent initializer is null");
        }
        CollectionInitializer<?> collectionInitializer = parentInitializer.asCollectionInitializer();
        if (collectionInitializer != null) {
            return collectionInitializer.getCollectionInstance(rowProcessingState).getOwner();
        }
        EntityInitializer<?> parentEntityInitializer = parentInitializer.asEntityInitializer();
        if (parentEntityInitializer != null) {
            return parentEntityInitializer.getTargetInstance(rowProcessingState);
        }
        throw new UnsupportedOperationException("The Embeddable: " + this.navigablePath + " parent initializer is neither an instance of an EntityInitializer nor of a CollectionInitializer");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.navigablePath + ") : `" + this.getInitializedPart().getJavaType().getJavaTypeClass() + "`";
    }

    public static class EmbeddableInitializerData
    extends InitializerData
    implements ValueAccess {
        protected final InitializerData parentData;
        protected final Object[] rowState;
        protected EmbeddableMappingType.ConcreteEmbeddableType concreteEmbeddableType;

        public EmbeddableInitializerData(EmbeddableInitializerImpl initializer, RowProcessingState rowProcessingState) {
            super(rowProcessingState);
            this.parentData = initializer.parent == null ? null : initializer.parent.getData(rowProcessingState);
            int size = initializer.embeddableMappingType.getNumberOfFetchables();
            this.rowState = new Object[size];
        }

        @Override
        public Object[] getValues() {
            return this.getState() == Initializer.State.MISSING ? null : this.rowState;
        }

        @Override
        public <T> T getValue(int i, Class<T> clazz) {
            return this.getState() == Initializer.State.MISSING ? null : (T)clazz.cast(this.rowState[i]);
        }

        @Override
        public Object getOwner() {
            return this.parentData == null ? null : this.parentData.getInstance();
        }

        public int getSubclassId() {
            return this.concreteEmbeddableType == null ? 0 : this.concreteEmbeddableType.getSubclassId();
        }
    }
}

