/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import org.hibernate.EntityFilterException;
import org.hibernate.FetchNotFoundException;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchInitializer;

public class EntitySelectFetchByUniqueKeyInitializer
extends EntitySelectFetchInitializer<EntitySelectFetchInitializer.EntitySelectFetchInitializerData> {
    private final ToOneAttributeMapping fetchedAttribute;

    public EntitySelectFetchByUniqueKeyInitializer(InitializerParent<?> parent, ToOneAttributeMapping fetchedAttribute, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResult<?> keyResult, boolean affectedByFilter, AssemblerCreationState creationState) {
        super(parent, fetchedAttribute, fetchedNavigable, concreteDescriptor, keyResult, affectedByFilter, creationState);
        this.fetchedAttribute = fetchedAttribute;
    }

    @Override
    protected void initialize(EntitySelectFetchInitializer.EntitySelectFetchInitializerData data) {
        String entityName = this.concreteDescriptor.getEntityName();
        String uniqueKeyPropertyName = this.fetchedAttribute.getReferencedPropertyName();
        SharedSessionContractImplementor session = data.getRowProcessingState().getSession();
        EntityUniqueKey euk = new EntityUniqueKey(entityName, uniqueKeyPropertyName, data.entityIdentifier, this.concreteDescriptor.getPropertyType(uniqueKeyPropertyName), session.getFactory());
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        data.setInstance(persistenceContext.getEntity(euk));
        if (data.getInstance() == null) {
            Object instance = this.concreteDescriptor.loadByUniqueKey(uniqueKeyPropertyName, data.entityIdentifier, session);
            data.setInstance(instance);
            if (instance == null && this.toOneMapping.getNotFoundAction() != NotFoundAction.IGNORE) {
                if (this.affectedByFilter) {
                    throw new EntityFilterException(entityName, data.entityIdentifier, this.toOneMapping.getNavigableRole().getFullPath());
                }
                if (this.toOneMapping.getNotFoundAction() == NotFoundAction.EXCEPTION) {
                    throw new FetchNotFoundException(entityName, data.entityIdentifier);
                }
            }
            persistenceContext.addEntity(euk, instance);
        }
        if (data.getInstance() != null) {
            data.setInstance(persistenceContext.proxyFor(data.getInstance()));
        }
    }

    @Override
    public String toString() {
        return "EntitySelectFetchByUniqueKeyInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

