/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.component.ComponentModel;
import org.keycloak.storage.CacheableStorageProviderModel;
import org.keycloak.storage.UserStorageProvider;

@ProtoTypeId(value=65539)
public class UserStorageProviderModel
extends CacheableStorageProviderModel {
    public static final String IMPORT_ENABLED = "importEnabled";
    public static final String FULL_SYNC_PERIOD = "fullSyncPeriod";
    public static final String CHANGED_SYNC_PERIOD = "changedSyncPeriod";
    public static final String LAST_SYNC = "lastSync";
    private transient Integer fullSyncPeriod;
    private transient Integer changedSyncPeriod;
    private transient Integer lastSync;
    private transient Boolean importEnabled;

    public UserStorageProviderModel() {
        this.setProviderType(UserStorageProvider.class.getName());
    }

    public UserStorageProviderModel(ComponentModel copy) {
        super(copy);
    }

    public boolean isImportEnabled() {
        if (this.importEnabled == null) {
            String val = (String)this.getConfig().getFirst((Object)IMPORT_ENABLED);
            this.importEnabled = val == null ? Boolean.valueOf(true) : Boolean.valueOf(val);
        }
        return this.importEnabled;
    }

    public void setImportEnabled(boolean flag) {
        this.importEnabled = flag;
        this.getConfig().putSingle((Object)IMPORT_ENABLED, (Object)Boolean.toString(flag));
    }

    public int getFullSyncPeriod() {
        if (this.fullSyncPeriod == null) {
            String val = (String)this.getConfig().getFirst((Object)FULL_SYNC_PERIOD);
            this.fullSyncPeriod = val == null ? Integer.valueOf(-1) : Integer.valueOf(val);
        }
        return this.fullSyncPeriod;
    }

    public void setFullSyncPeriod(int fullSyncPeriod) {
        this.fullSyncPeriod = fullSyncPeriod;
        this.getConfig().putSingle((Object)FULL_SYNC_PERIOD, (Object)Integer.toString(fullSyncPeriod));
    }

    public int getChangedSyncPeriod() {
        if (this.changedSyncPeriod == null) {
            String val = (String)this.getConfig().getFirst((Object)CHANGED_SYNC_PERIOD);
            this.changedSyncPeriod = val == null ? Integer.valueOf(-1) : Integer.valueOf(val);
        }
        return this.changedSyncPeriod;
    }

    public void setChangedSyncPeriod(int changedSyncPeriod) {
        this.changedSyncPeriod = changedSyncPeriod;
        this.getConfig().putSingle((Object)CHANGED_SYNC_PERIOD, (Object)Integer.toString(changedSyncPeriod));
    }

    public int getLastSync() {
        if (this.lastSync == null) {
            String val = (String)this.getConfig().getFirst((Object)LAST_SYNC);
            this.lastSync = val == null ? Integer.valueOf(0) : Integer.valueOf(val);
        }
        return this.lastSync;
    }

    public void setLastSync(int lastSync) {
        this.lastSync = lastSync;
        this.getConfig().putSingle((Object)LAST_SYNC, (Object)Integer.toString(lastSync));
    }
}

