/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.config.build;

import io.quarkus.opentelemetry.runtime.config.build.InstrumentBuildTimeConfig;
import io.quarkus.opentelemetry.runtime.config.build.MetricsBuildConfig;
import io.quarkus.opentelemetry.runtime.config.build.TracesBuildConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.security.spi.runtime.AuthenticationFailureEvent;
import io.quarkus.security.spi.runtime.AuthenticationSuccessEvent;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.util.List;

@ConfigMapping(prefix="quarkus.otel")
@ConfigRoot(phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public interface OTelBuildConfig {
    public static final String INSTRUMENTATION_NAME = "io.quarkus.opentelemetry";

    @WithDefault(value="true")
    public boolean enabled();

    public TracesBuildConfig traces();

    public MetricsBuildConfig metrics();

    @WithName(value="logs.exporter")
    @WithDefault(value="none")
    public List<String> logsExporter();

    @WithDefault(value="tracecontext,baggage")
    public List<String> propagators();

    public InstrumentBuildTimeConfig instrument();

    public SecurityEvents securityEvents();

    @ConfigGroup
    public static interface SecurityEvents {
        @WithDefault(value="false")
        public boolean enabled();

        @WithDefault(value="ALL")
        public List<SecurityEventType> eventTypes();

        public static enum SecurityEventType {
            ALL(SecurityEvent.class),
            AUTHENTICATION_SUCCESS(AuthenticationSuccessEvent.class),
            AUTHENTICATION_FAILURE(AuthenticationFailureEvent.class),
            AUTHORIZATION_SUCCESS(AuthorizationSuccessEvent.class),
            AUTHORIZATION_FAILURE(AuthorizationFailureEvent.class),
            OTHER(SecurityEvent.class);

            private final Class<? extends SecurityEvent> observedType;

            private SecurityEventType(Class<? extends SecurityEvent> observedType) {
                this.observedType = observedType;
            }

            public Class<? extends SecurityEvent> getObservedType() {
                return this.observedType;
            }
        }
    }
}

