/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import jakarta.ws.rs.BadRequestException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class ReservedCharValidator {
    protected static final Logger logger = Logger.getLogger(ReservedCharValidator.class);
    private static final Pattern RESERVED_CHARS_PATTERN = Pattern.compile("[:/?#@!$&()*+,;=\\[\\]\\\\]");
    private static final Pattern RESERVED_CHARS_LOCALES_PATTERN = Pattern.compile("[:/?#@!$&()*+,;=\\[\\]\\\\{}%]");

    private ReservedCharValidator() {
    }

    public static void validate(String str, Pattern pattern) throws ReservedCharException {
        if (str == null) {
            return;
        }
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            String message = "Character '" + matcher.group() + "' not allowed.";
            logger.warn((Object)message);
            throw new ReservedCharException(message);
        }
    }

    public static void validateNoSpace(String str) {
        if (str == null) {
            return;
        }
        Pattern pattern = Pattern.compile("\\s");
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            String message = "Empty Space not allowed.";
            logger.warn((Object)message);
            throw new ReservedCharException(message);
        }
        ReservedCharValidator.validate(str, RESERVED_CHARS_PATTERN);
    }

    public static void validate(String str) {
        ReservedCharValidator.validate(str, RESERVED_CHARS_PATTERN);
    }

    public static void validateLocales(Iterable<String> strIterable) {
        if (strIterable == null) {
            return;
        }
        for (String str : strIterable) {
            ReservedCharValidator.validate(str, RESERVED_CHARS_LOCALES_PATTERN);
        }
    }

    public static class ReservedCharException
    extends BadRequestException {
        ReservedCharException(String msg) {
            super(msg);
        }
    }
}

