/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate.validators;

import java.util.LinkedHashSet;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.utils.EmailValidationUtil;
import org.keycloak.validate.AbstractStringValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidationResult;
import org.keycloak.validate.ValidatorConfig;

public class EmailValidator
extends AbstractStringValidator
implements ConfiguredProvider {
    public static final String ID = "email";
    public static final EmailValidator INSTANCE = new EmailValidator();
    public static final String MESSAGE_INVALID_EMAIL = "error-invalid-email";
    public static final String MAX_LOCAL_PART_LENGTH_PROPERTY = "max-local-length";

    public String getId() {
        return ID;
    }

    protected void doValidate(String value, String inputHint, ValidationContext context, ValidatorConfig config) {
        Integer maxEmailLocalPartLength = null;
        if (config != null) {
            maxEmailLocalPartLength = config.getInt(MAX_LOCAL_PART_LENGTH_PROPERTY);
        }
        if (!(maxEmailLocalPartLength == null ? EmailValidationUtil.isValidEmail(value) : EmailValidationUtil.isValidEmail(value, maxEmailLocalPartLength))) {
            context.addError(new ValidationError(ID, inputHint, MESSAGE_INVALID_EMAIL, new Object[]{value}));
        }
    }

    public String getHelpText() {
        return "Email format validator";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return ProviderConfigurationBuilder.create().property().name(MAX_LOCAL_PART_LENGTH_PROPERTY).type("String").label("Maximum length for the local part").helpText("Maximum length for the local part of the email").defaultValue((Object)64).required(false).add().build();
    }

    public ValidationResult validateConfig(KeycloakSession session, ValidatorConfig config) {
        Integer maxLocalPartLength;
        LinkedHashSet<ValidationError> errors = new LinkedHashSet<ValidationError>();
        if (config != null && config.containsKey(MAX_LOCAL_PART_LENGTH_PROPERTY) && ((maxLocalPartLength = config.getInt(MAX_LOCAL_PART_LENGTH_PROPERTY)) == null || maxLocalPartLength <= 0)) {
            errors.add(new ValidationError(ID, MAX_LOCAL_PART_LENGTH_PROPERTY, "error-validator-config-invalid-number-value", new Object[]{config.get(MAX_LOCAL_PART_LENGTH_PROPERTY)}));
        }
        return new ValidationResult(errors);
    }
}

