/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.logging.Logger;

public class WebAuthnPolicy
implements Serializable {
    protected static final Logger logger = Logger.getLogger(WebAuthnPolicy.class);
    protected String rpEntityName;
    protected List<String> signatureAlgorithms;
    protected String rpId;
    protected String attestationConveyancePreference;
    protected String authenticatorAttachment;
    protected String requireResidentKey;
    protected String userVerificationRequirement;
    protected int createTimeout = 0;
    protected boolean avoidSameAuthenticatorRegister = false;
    protected List<String> acceptableAaguids;
    protected List<String> extraOrigins;
    public static WebAuthnPolicy DEFAULT_POLICY = new WebAuthnPolicy(new ArrayList<String>(Arrays.asList("ES256", "RS256")));

    public WebAuthnPolicy() {
    }

    public WebAuthnPolicy(List<String> signatureAlgorithms) {
        this.signatureAlgorithms = signatureAlgorithms;
    }

    public String getRpEntityName() {
        return this.rpEntityName;
    }

    public void setRpEntityName(String rpEntityName) {
        this.rpEntityName = rpEntityName;
    }

    public List<String> getSignatureAlgorithm() {
        return this.signatureAlgorithms;
    }

    public void setSignatureAlgorithm(List<String> signatureAlgorithms) {
        this.signatureAlgorithms = signatureAlgorithms;
    }

    public String getRpId() {
        return this.rpId;
    }

    public void setRpId(String rpId) {
        this.rpId = rpId;
    }

    public String getAttestationConveyancePreference() {
        return this.attestationConveyancePreference;
    }

    public void setAttestationConveyancePreference(String attestationConveyancePreference) {
        this.attestationConveyancePreference = attestationConveyancePreference;
    }

    public String getAuthenticatorAttachment() {
        return this.authenticatorAttachment;
    }

    public void setAuthenticatorAttachment(String authenticatorAttachment) {
        this.authenticatorAttachment = authenticatorAttachment;
    }

    public String getRequireResidentKey() {
        return this.requireResidentKey;
    }

    public void setRequireResidentKey(String requireResidentKey) {
        this.requireResidentKey = requireResidentKey;
    }

    public String getUserVerificationRequirement() {
        return this.userVerificationRequirement;
    }

    public void setUserVerificationRequirement(String userVerificationRequirement) {
        this.userVerificationRequirement = userVerificationRequirement;
    }

    public int getCreateTimeout() {
        return this.createTimeout;
    }

    public void setCreateTimeout(int createTimeout) {
        this.createTimeout = createTimeout;
    }

    public boolean isAvoidSameAuthenticatorRegister() {
        return this.avoidSameAuthenticatorRegister;
    }

    public void setAvoidSameAuthenticatorRegister(boolean avoidSameAuthenticatorRegister) {
        this.avoidSameAuthenticatorRegister = avoidSameAuthenticatorRegister;
    }

    public List<String> getAcceptableAaguids() {
        return this.acceptableAaguids;
    }

    public void setAcceptableAaguids(List<String> acceptableAaguids) {
        this.acceptableAaguids = acceptableAaguids;
    }

    public List<String> getExtraOrigins() {
        return this.extraOrigins;
    }

    public void setExtraOrigins(List<String> extraOrigins) {
        this.extraOrigins = extraOrigins;
    }
}

