/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniAndGroupIterable;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.tuples.Functions;
import io.smallrye.mutiny.tuples.Tuple6;
import io.smallrye.mutiny.tuples.Tuples;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class UniAndGroup6<T1, T2, T3, T4, T5, T6>
extends UniAndGroupIterable<T1> {
    public UniAndGroup6(Uni<? extends T1> source, Uni<? extends T2> o1, Uni<? extends T3> o2, Uni<? extends T4> o3, Uni<? extends T5> o4, Uni<? extends T6> o5) {
        super(source, Arrays.asList(o1, o2, o3, o4, o5));
    }

    @CheckReturnValue
    public UniAndGroup6<T1, T2, T3, T4, T5, T6> collectFailures() {
        super.collectFailures();
        return this;
    }

    @CheckReturnValue
    public Uni<Tuple6<T1, T2, T3, T4, T5, T6>> asTuple() {
        return this.combine(Tuple6::of);
    }

    @Deprecated(forRemoval=true)
    @CheckReturnValue
    public <O> Uni<O> combinedWith(Functions.Function6<T1, T2, T3, T4, T5, T6, O> combinator) {
        return this.with(combinator);
    }

    @CheckReturnValue
    public <O> Uni<O> with(Functions.Function6<T1, T2, T3, T4, T5, T6, O> combinator) {
        Functions.Function6<T1, T2, T3, T4, T5, T6, O> actual = Infrastructure.decorate(ParameterValidation.nonNull(combinator, "combinator"));
        return this.combine(actual);
    }

    private <O> Uni<O> combine(Functions.Function6<T1, T2, T3, T4, T5, T6, O> combinator) {
        Function<List, Object> function = list -> {
            Tuples.ensureArity(list, 6);
            Object item1 = list.get(0);
            Object item2 = list.get(1);
            Object item3 = list.get(2);
            Object item4 = list.get(3);
            Object item5 = list.get(4);
            Object item6 = list.get(5);
            return combinator.apply(item1, item2, item3, item4, item5, item6);
        };
        return super.with(function);
    }

    @CheckReturnValue
    public <O> Uni<O> withUni(Functions.Function6<T1, T2, T3, T4, T5, T6, Uni<O>> combinator) {
        Functions.Function6<T1, T2, T3, T4, T5, T6, Uni<O>> actual = Infrastructure.decorate(ParameterValidation.nonNull(combinator, "combinator"));
        return this.combineUni(actual);
    }

    private <O> Uni<O> combineUni(Functions.Function6<T1, T2, T3, T4, T5, T6, Uni<O>> combinator) {
        Function<List, Uni> function = list -> {
            Tuples.ensureArity(list, 6);
            Object item1 = list.get(0);
            Object item2 = list.get(1);
            Object item3 = list.get(2);
            Object item4 = list.get(3);
            Object item5 = list.get(4);
            Object item6 = list.get(5);
            return (Uni)combinator.apply(item1, item2, item3, item4, item5, item6);
        };
        return super.with(function).flatMap(Function.identity());
    }
}

