/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.dom.xmlsec.w3.xmldsig;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.keycloak.common.util.Base64;
import org.keycloak.dom.xmlsec.w3.xmldsig.KeyValueType;
import org.keycloak.saml.common.exceptions.ProcessingException;

public class RSAKeyValueType
implements KeyValueType {
    protected byte[] modulus;
    protected byte[] exponent;

    public byte[] getModulus() {
        return this.modulus;
    }

    public void setModulus(byte[] value) {
        this.modulus = value;
    }

    public byte[] getExponent() {
        return this.exponent;
    }

    public void setExponent(byte[] value) {
        this.exponent = value;
    }

    public RSAPublicKey convertToPublicKey() throws ProcessingException {
        try {
            BigInteger bigModulus = new BigInteger(1, this.massage(Base64.decode((String)new String(this.modulus))));
            BigInteger bigEx = new BigInteger(1, this.massage(Base64.decode((String)new String(this.exponent))));
            KeyFactory rsaKeyFactory = KeyFactory.getInstance("rsa");
            RSAPublicKeySpec kspec = new RSAPublicKeySpec(bigModulus, bigEx);
            return (RSAPublicKey)rsaKeyFactory.generatePublic(kspec);
        }
        catch (Exception e) {
            throw new ProcessingException(e);
        }
    }

    public RSAPrivateKey convertToPrivateKey() throws ProcessingException {
        try {
            BigInteger bigModulus = new BigInteger(1, this.massage(Base64.decode((String)new String(this.modulus))));
            BigInteger bigEx = new BigInteger(1, this.massage(Base64.decode((String)new String(this.exponent))));
            KeyFactory rsaKeyFactory = KeyFactory.getInstance("rsa");
            RSAPrivateKeySpec kspec = new RSAPrivateKeySpec(bigModulus, bigEx);
            return (RSAPrivateKey)rsaKeyFactory.generatePrivate(kspec);
        }
        catch (Exception e) {
            throw new ProcessingException(e);
        }
    }

    public String toString() {
        String prefix = "ds";
        String colon = ":";
        String left = "<";
        String right = ">";
        String slash = "/";
        StringBuilder sb = new StringBuilder();
        sb.append(left).append(prefix).append(colon).append("RSAKeyValue").append(right);
        sb.append(left).append(prefix).append(colon).append("Modulus").append(right);
        sb.append(new String(this.getModulus()));
        sb.append(left).append(slash).append(prefix).append(colon).append("Modulus").append(right);
        sb.append(left).append(prefix).append(colon).append("Exponent").append(right);
        sb.append(new String(this.getExponent()));
        sb.append(left).append(slash).append(prefix).append(colon).append("Exponent").append(right);
        sb.append(left).append(slash).append(prefix).append(colon).append("RSAKeyValue").append(right);
        return sb.toString();
    }

    private byte[] massage(byte[] byteArray) {
        if (byteArray[0] == 0) {
            byte[] substring = new byte[byteArray.length - 1];
            System.arraycopy(byteArray, 1, substring, 0, byteArray.length - 1);
            return substring;
        }
        return byteArray;
    }
}

