/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.credentialbuilder;

import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilder;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilderException;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilderFactory;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilderUtils;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.LDCredentialBuilder;
import org.keycloak.provider.ProviderConfigProperty;

public class LDCredentialBuilderFactory
implements CredentialBuilderFactory {
    public String getId() {
        return "ldp_vc";
    }

    public String getHelpText() {
        return "Builds verifiable credentials on the LDP-VC format (https://www.w3.org/TR/vc-data-model).";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public CredentialBuilder create(KeycloakSession session, ComponentModel model) {
        String credentialIssuer = CredentialBuilderUtils.getIssuerDid(session).orElseThrow(() -> new CredentialBuilderException("No issuerDid configured."));
        return new LDCredentialBuilder(credentialIssuer);
    }
}

