/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.client.challenge;

import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.Base64UrlUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DefaultChallenge
implements Challenge {
    private final byte[] value;

    public DefaultChallenge(@NonNull byte[] value) {
        AssertUtil.notNull((Object)value, (String)"value cannot be null");
        this.value = value;
    }

    public DefaultChallenge(@NonNull String base64urlString) {
        AssertUtil.notNull((Object)base64urlString, (String)"base64urlString cannot be null");
        this.value = Base64UrlUtil.decode((String)base64urlString);
    }

    public DefaultChallenge() {
        UUID uuid = UUID.randomUUID();
        long hi = uuid.getMostSignificantBits();
        long lo = uuid.getLeastSignificantBits();
        this.value = ByteBuffer.allocate(16).putLong(hi).putLong(lo).array();
    }

    @Override
    public @NonNull byte[] getValue() {
        return ArrayUtil.clone((byte[])this.value);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultChallenge that = (DefaultChallenge)o;
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public String toString() {
        return ArrayUtil.toHexString((byte[])this.value);
    }
}

