/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;

@MBean(description="Prevents blocking sends during the processing of an incoming message")
public class NON_BLOCKING_SENDS
extends Protocol {
    @Property(description="Lists messages sent during a receive that are not marked as DONT_BLOCK")
    protected boolean verbose;
    @Property(description="When a message send during reception is detected, set DONT_BLOCK if fix==true")
    protected boolean fix = true;
    @ManagedAttribute(description="The threads currently processing received messages")
    protected final Set<Long> threads = new ConcurrentSkipListSet<Long>();

    @Override
    public Object down(Message msg) {
        long tid = NON_BLOCKING_SENDS.threadId();
        if (this.threads.contains(tid) && !msg.isFlagSet(Message.TransientFlag.DONT_BLOCK)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("%s: setting DONT_BLOCK in message %s: hdrs: %s", this.local_addr, msg, msg.printHeaders());
            }
            if (this.fix) {
                msg.setFlag(Message.TransientFlag.DONT_BLOCK);
            }
        }
        return this.down_prot.down(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Message msg) {
        long tid = NON_BLOCKING_SENDS.threadId();
        this.threads.add(tid);
        try {
            Object object = this.up_prot.up(msg);
            return object;
        }
        finally {
            this.threads.remove(tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void up(MessageBatch batch) {
        long tid = NON_BLOCKING_SENDS.threadId();
        this.threads.add(tid);
        try {
            this.up_prot.up(batch);
        }
        finally {
            this.threads.remove(tid);
        }
    }

    protected static long threadId() {
        return Thread.currentThread().getId();
    }
}

