/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.generator;

import java.io.Serializable;
import java.util.EnumSet;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.EventType;

public interface Generator
extends Serializable {
    public boolean generatedOnExecution();

    default public boolean generatedOnExecution(Object entity, SharedSessionContractImplementor session) {
        return this.generatedOnExecution();
    }

    public EnumSet<EventType> getEventTypes();

    default public boolean allowAssignedIdentifiers() {
        return false;
    }

    default public boolean generatesSometimes() {
        return !this.getEventTypes().isEmpty();
    }

    default public boolean generatesOnInsert() {
        return this.getEventTypes().contains((Object)EventType.INSERT);
    }

    default public boolean generatesOnUpdate() {
        return this.getEventTypes().contains((Object)EventType.UPDATE);
    }
}

