/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.ScriptEngineContainer;
import org.openhab.core.automation.module.script.ScriptEngineManager;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.config.core.ConfigDescription;
import org.openhab.core.config.core.ConfigDescriptionBuilder;
import org.openhab.core.config.core.ConfigDescriptionProvider;
import org.openhab.core.config.core.ConfigDescriptionRegistry;
import org.openhab.core.config.core.ConfigOptionProvider;
import org.openhab.core.config.core.ConfigParser;
import org.openhab.core.config.core.ParameterOption;
import org.openhab.core.transform.Transformation;
import org.openhab.core.transform.TransformationException;
import org.openhab.core.transform.TransformationRegistry;
import org.openhab.core.transform.TransformationService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(factory="org.openhab.core.automation.module.script.transformation.factory", service={TransformationService.class, ScriptTransformationService.class, ConfigOptionProvider.class, ConfigDescriptionProvider.class})
public class ScriptTransformationService
implements TransformationService,
ConfigOptionProvider,
ConfigDescriptionProvider,
RegistryChangeListener<Transformation> {
    public static final String SCRIPT_TYPE_PROPERTY_NAME = "openhab.transform.script.scriptType";
    public static final String OPENHAB_TRANSFORMATION_SCRIPT = "openhab-transformation-script-";
    private static final URI CONFIG_DESCRIPTION_TEMPLATE_URI = URI.create("profile:transform:SCRIPT");
    private static final Pattern INLINE_SCRIPT_CONFIG_PATTERN = Pattern.compile("\\|(?<inlineScript>.+)");
    private static final Pattern SCRIPT_CONFIG_PATTERN = Pattern.compile("(?<scriptUid>.+?)(\\?(?<params>.*?))?");
    private final Logger logger = LoggerFactory.getLogger(ScriptTransformationService.class);
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"common");
    private final String scriptType;
    private final URI profileConfigUri;
    private final Map<String, ScriptRecord> scriptCache = new ConcurrentHashMap<String, ScriptRecord>();
    private final TransformationRegistry transformationRegistry;
    private final ScriptEngineManager scriptEngineManager;
    private final ConfigDescriptionRegistry configDescRegistry;

    @Activate
    public ScriptTransformationService(@Reference TransformationRegistry transformationRegistry, @Reference ConfigDescriptionRegistry configDescRegistry, @Reference ScriptEngineManager scriptEngineManager, Map<String, Object> config) {
        String scriptType = (String)ConfigParser.valueAs((Object)config.get(SCRIPT_TYPE_PROPERTY_NAME), String.class);
        if (scriptType == null) {
            throw new IllegalStateException("'openhab.transform.script.scriptType' must not be null in service configuration");
        }
        this.transformationRegistry = transformationRegistry;
        this.configDescRegistry = configDescRegistry;
        this.scriptEngineManager = scriptEngineManager;
        this.scriptType = scriptType;
        this.profileConfigUri = URI.create("profile:transform:" + scriptType.toUpperCase());
        transformationRegistry.addRegistryChangeListener((RegistryChangeListener)this);
    }

    @Deactivate
    public void deactivate() {
        this.transformationRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        this.scriptCache.values().forEach(this::disposeScriptRecord);
    }

    /*
     * Exception decompiling
     */
    public @Nullable String transform(String function, String source) throws TransformationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void added(Transformation element) {
        this.clearCache(element.getUID());
    }

    public void removed(Transformation element) {
        this.clearCache(element.getUID());
    }

    public void updated(Transformation oldElement, Transformation element) {
        this.clearCache(element.getUID());
    }

    public @Nullable Collection<ParameterOption> getParameterOptions(URI uri, String param, @Nullable String context, @Nullable Locale locale) {
        if (!uri.equals(this.profileConfigUri)) {
            return null;
        }
        if ("toHandlerScript".equals(param) || "toItemScript".equals(param) || "commandFromItemScript".equals(param) || "stateFromItemScript".equals(param)) {
            return this.transformationRegistry.getTransformations(List.of(this.scriptType.toLowerCase())).stream().map(c -> new ParameterOption(c.getUID(), c.getLabel())).toList();
        }
        return null;
    }

    public Collection<ConfigDescription> getConfigDescriptions(@Nullable Locale locale) {
        ConfigDescription configDescription = this.getConfigDescription(this.profileConfigUri, locale);
        if (configDescription != null) {
            return List.of(configDescription);
        }
        return List.of();
    }

    public @Nullable ConfigDescription getConfigDescription(URI uri, @Nullable Locale locale) {
        if (!uri.equals(this.profileConfigUri)) {
            return null;
        }
        ConfigDescription template = this.configDescRegistry.getConfigDescription(CONFIG_DESCRIPTION_TEMPLATE_URI, locale);
        if (template == null) {
            return null;
        }
        return ConfigDescriptionBuilder.create((URI)uri).withParameters(template.getParameters()).withParameterGroups(template.getParameterGroups()).build();
    }

    private void clearCache(String uid) {
        ScriptRecord scriptRecord = this.scriptCache.remove(uid);
        if (scriptRecord != null) {
            this.disposeScriptRecord(scriptRecord);
        }
    }

    private void disposeScriptRecord(ScriptRecord scriptRecord) {
        CompiledScript compiledScript;
        ScriptEngineContainer scriptEngineContainer = scriptRecord.scriptEngineContainer;
        if (scriptEngineContainer != null) {
            this.disposeScriptEngine(scriptEngineContainer.getScriptEngine());
        }
        if ((compiledScript = scriptRecord.compiledScript) != null) {
            this.disposeScriptEngine(compiledScript.getEngine());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void disposeScriptEngine(ScriptEngine scriptEngine) {
        ScriptEngine scriptEngine2 = scriptEngine;
        if (scriptEngine2 instanceof AutoCloseable) {
            void closableScriptEngine;
            AutoCloseable autoCloseable = (AutoCloseable)((Object)scriptEngine2);
            AutoCloseable cfr_ignored_0 = (AutoCloseable)((Object)scriptEngine2);
            this.scheduler.schedule(() -> this.lambda$3((AutoCloseable)closableScriptEngine), 0L, TimeUnit.SECONDS);
        } else {
            this.logger.trace("ScriptEngine does not support AutoCloseable interface");
        }
    }

    private static /* synthetic */ ScriptRecord lambda$1(String k) {
        return new ScriptRecord();
    }

    private /* synthetic */ void lambda$3(AutoCloseable autoCloseable) {
        try {
            autoCloseable.close();
        }
        catch (Exception e) {
            this.logger.error("Error while closing script engine", (Throwable)e);
        }
    }

    private static class ScriptRecord {
        public String script = "";
        public @Nullable ScriptEngineContainer scriptEngineContainer;
        public @Nullable CompiledScript compiledScript;
        public final Lock lock = new ReentrantLock();

        private ScriptRecord() {
        }
    }
}

