/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import antlr.RecognitionException;
import antlr.TokenStreamRecognitionException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import processing.app.Base;
import processing.app.Library;
import processing.app.Mode;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.SketchException;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.mode.java.Compiler;
import processing.mode.java.preproc.PdePreprocessor;
import processing.mode.java.preproc.PreprocessorResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBuild {
    public static final String SIZE_REGEX = "(?:^|\\s|;)size\\s*\\(\\s*([^\\s,]+)\\s*,\\s*([^\\s,\\)]+),?\\s*([^\\)]*)\\s*\\)\\s*\\;";
    public static final String PACKAGE_REGEX = "(?:^|\\s|;)package\\s+(\\S+)\\;";
    protected Sketch sketch;
    protected Mode mode;
    protected File srcFolder;
    protected File binFolder;
    private boolean foundMain = false;
    private String classPath;
    protected String sketchClassName;
    private String javaLibraryPath;
    private ArrayList<Library> importedLibraries;

    public JavaBuild(Sketch sketch) {
        this.sketch = sketch;
        this.mode = sketch.getMode();
    }

    public String build() throws SketchException {
        return this.build(this.sketch.makeTempFolder(), this.sketch.makeTempFolder());
    }

    public String build(File srcFolder, File binFolder) throws SketchException {
        this.srcFolder = srcFolder;
        this.binFolder = binFolder;
        String classNameFound = this.preprocess(srcFolder);
        if (Compiler.compile(this)) {
            this.sketchClassName = classNameFound;
            return classNameFound;
        }
        return null;
    }

    public String getSketchClassName() {
        return this.sketchClassName;
    }

    public String preprocess(File srcFolder) throws SketchException {
        return this.preprocess(srcFolder, null, new PdePreprocessor(this.sketch.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String preprocess(File srcFolder, String packageName, PdePreprocessor preprocessor) throws SketchException {
        PreprocessorResult result;
        this.sketch.ensureExistence();
        this.classPath = this.binFolder.getAbsolutePath();
        String[] codeFolderPackages = null;
        if (this.sketch.hasCodeFolder()) {
            File codeFolder = this.sketch.getCodeFolder();
            this.javaLibraryPath = codeFolder.getAbsolutePath();
            String codeFolderClassPath = Base.contentsToClassPath(codeFolder);
            this.classPath = this.classPath + File.pathSeparator + codeFolderClassPath;
            codeFolderPackages = Base.packageListFromClassPath(codeFolderClassPath);
        } else {
            this.javaLibraryPath = "";
        }
        StringBuffer bigCode = new StringBuffer();
        int bigCount = 0;
        for (SketchCode sc : this.sketch.getCode()) {
            if (!sc.isExtension("pde")) continue;
            sc.setPreprocOffset(bigCount);
            bigCode.append(sc.getProgram());
            bigCode.append('\n');
            bigCount += sc.getLineCount();
        }
        try {
            File outputFolder = packageName == null ? srcFolder : new File(srcFolder, packageName.replace('.', '/'));
            outputFolder.mkdirs();
            File java = new File(outputFolder, this.sketch.getName() + ".java");
            PrintWriter stream = new PrintWriter(new FileWriter(java));
            try {
                result = preprocessor.write(stream, bigCode.toString(), codeFolderPackages);
            }
            finally {
                stream.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            String msg = "Build folder disappeared or could not be written";
            throw new SketchException(msg);
        }
        catch (RecognitionException re) {
            int errorLine = re.getLine() - 1;
            int errorFile = this.findErrorFile(errorLine);
            errorLine -= this.sketch.getCode(errorFile).getPreprocOffset();
            String msg = re.getMessage();
            if (msg.equals("expecting RCURLY, found 'null'")) {
                throw new SketchException("Found one too many { characters without a } to match it.", errorFile, errorLine, re.getColumn());
            }
            if (msg.indexOf("expecting RBRACK") != -1) {
                System.err.println(msg);
                throw new SketchException("Syntax error, maybe a missing ] character?", errorFile, errorLine, re.getColumn());
            }
            if (msg.indexOf("expecting SEMI") != -1) {
                System.err.println(msg);
                throw new SketchException("Syntax error, maybe a missing semicolon?", errorFile, errorLine, re.getColumn());
            }
            if (msg.indexOf("expecting RPAREN") != -1) {
                System.err.println(msg);
                throw new SketchException("Syntax error, maybe a missing right parenthesis?", errorFile, errorLine, re.getColumn());
            }
            if (msg.indexOf("preproc.web_colors") != -1) {
                throw new SketchException("A web color (such as #ffcc00) must be six digits.", errorFile, errorLine, re.getColumn(), false);
            }
            throw new SketchException(msg, errorFile, errorLine, re.getColumn());
        }
        catch (TokenStreamRecognitionException tsre) {
            String mess = "^line (\\d+):(\\d+):\\s";
            String[] matches = PApplet.match((String)tsre.toString(), (String)mess);
            if (matches != null) {
                int errorLine = Integer.parseInt(matches[1]) - 1;
                int errorColumn = Integer.parseInt(matches[2]);
                int errorFile = 0;
                for (int i = 1; i < this.sketch.getCodeCount(); ++i) {
                    SketchCode sc = this.sketch.getCode(i);
                    if (!sc.isExtension("pde") || sc.getPreprocOffset() >= errorLine) continue;
                    errorFile = i;
                }
                throw new SketchException(tsre.getMessage(), errorFile, errorLine -= this.sketch.getCode(errorFile).getPreprocOffset(), errorColumn);
            }
            String msg = tsre.toString();
            throw new SketchException(msg, 0, -1, -1);
        }
        catch (SketchException pe) {
            throw pe;
        }
        catch (Exception ex) {
            System.err.println("Uncaught exception type:" + ex.getClass());
            ex.printStackTrace();
            throw new SketchException(ex.toString());
        }
        this.importedLibraries = new ArrayList();
        for (String item : result.extraImports) {
            int dot = item.lastIndexOf(46);
            String entry = dot == -1 ? item : item.substring(0, dot);
            Library library = this.mode.getLibrary(entry);
            if (library != null) {
                if (this.importedLibraries.contains(library)) continue;
                this.importedLibraries.add(library);
                this.classPath = this.classPath + library.getClassPath();
                this.javaLibraryPath = this.javaLibraryPath + File.pathSeparator + library.getNativePath();
                continue;
            }
            boolean found = false;
            if (codeFolderPackages != null) {
                String itemPkg = item.substring(0, item.lastIndexOf(46));
                for (String pkg : codeFolderPackages) {
                    if (!pkg.equals(itemPkg)) continue;
                    found = true;
                    break;
                }
            }
            if (this.ignorableImport(item)) {
                found = true;
            }
            if (found) continue;
            System.err.println("No library found for " + entry);
        }
        String javaClassPath = System.getProperty("java.class.path");
        if (javaClassPath.startsWith("\"") && javaClassPath.endsWith("\"")) {
            javaClassPath = javaClassPath.substring(1, javaClassPath.length() - 1);
        }
        this.classPath = this.classPath + File.pathSeparator + javaClassPath;
        for (SketchCode sc : this.sketch.getCode()) {
            if (sc.isExtension("java")) {
                String filename = sc.getFileName();
                try {
                    String javaCode = sc.getProgram();
                    String[] packageMatch = PApplet.match((String)javaCode, (String)PACKAGE_REGEX);
                    if (packageMatch == null && packageName == null) {
                        sc.copyTo(new File(srcFolder, filename));
                        continue;
                    }
                    if (packageMatch == null) {
                        packageMatch = new String[]{packageName};
                        javaCode = "package " + packageName + ";" + javaCode;
                    }
                    File packageFolder = new File(srcFolder, packageMatch[0].replace('.', '/'));
                    packageFolder.mkdirs();
                    Base.saveFile(javaCode, new File(packageFolder, filename));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    String msg = "Problem moving " + filename + " to the build folder";
                    throw new SketchException(msg);
                }
            }
            if (!sc.isExtension("pde")) continue;
            sc.addPreprocOffset(result.headerOffset);
        }
        this.foundMain = preprocessor.getFoundMain();
        return result.className;
    }

    protected boolean ignorableImport(String pkg) {
        if (pkg.startsWith("java.")) {
            return true;
        }
        return pkg.startsWith("javax.");
    }

    protected int findErrorFile(int errorLine) {
        for (int i = 1; i < this.sketch.getCodeCount(); ++i) {
            SketchCode sc = this.sketch.getCode(i);
            if (!sc.isExtension("pde") || sc.getPreprocOffset() >= errorLine) continue;
            return i;
        }
        return 0;
    }

    public File getSrcFolder() {
        return this.srcFolder;
    }

    public File getBinFolder() {
        return this.binFolder;
    }

    public String getSketchPath() {
        return this.sketch.getFolder().getAbsolutePath();
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getJavaLibraryPath() {
        return this.javaLibraryPath;
    }

    public boolean getFoundMain() {
        return this.foundMain;
    }

    public ArrayList<Library> getImportedLibraries() {
        return this.importedLibraries;
    }

    public SketchException placeException(String message, String dotJavaFilename, int dotJavaLine) {
        SketchCode code;
        int i;
        int codeIndex = 0;
        int codeLine = -1;
        for (i = 0; i < this.sketch.getCodeCount(); ++i) {
            code = this.sketch.getCode(i);
            if (!code.isExtension("java") || !dotJavaFilename.equals(code.getFileName())) continue;
            codeIndex = i;
            codeLine = dotJavaLine;
            return new SketchException(message, codeIndex, codeLine);
        }
        if (!dotJavaFilename.equals(this.sketch.getName() + ".java")) {
            return null;
        }
        codeIndex = 0;
        for (i = 0; i < this.sketch.getCodeCount(); ++i) {
            code = this.sketch.getCode(i);
            if (!code.isExtension("pde") || code.getPreprocOffset() > dotJavaLine) continue;
            codeIndex = i;
            codeLine = dotJavaLine - code.getPreprocOffset();
        }
        return new SketchException(message, codeIndex, codeLine, -1, false);
    }

    protected boolean exportApplet() throws SketchException, IOException {
        return this.exportApplet(new File(this.sketch.getFolder(), "applet"));
    }

    public boolean exportApplet(File appletFolder) throws SketchException, IOException {
        File bagelJar;
        this.mode.prepareExportFolder(appletFolder);
        this.srcFolder = this.sketch.makeTempFolder();
        this.binFolder = this.sketch.makeTempFolder();
        String foundName = this.build(this.srcFolder, this.binFolder);
        if (foundName == null) {
            return false;
        }
        if (!this.sketch.getName().equals(foundName)) {
            Base.showWarning("Error during export", "Sketch name is " + this.sketch.getName() + " but the\n" + "name found in the code was " + foundName + ".", null);
            return false;
        }
        int wide = 100;
        int high = 100;
        String renderer = "";
        String scrubbed = JavaBuild.scrubComments(this.sketch.getCode(0).getProgram());
        String[] matches = PApplet.match((String)scrubbed, (String)SIZE_REGEX);
        if (matches != null) {
            try {
                wide = Integer.parseInt(matches[1]);
                high = Integer.parseInt(matches[2]);
                if (matches.length == 4) {
                    renderer = matches[3].trim();
                }
            }
            catch (NumberFormatException e) {
                String message = "The size of this applet could not automatically be\ndetermined from your code. You'll have to edit the\nHTML file to set the size of the applet.\nUse only numeric values (not variables) for the size()\ncommand. See the size() reference for an explanation.";
                Base.showWarning("Could not find applet size", "The size of this applet could not automatically be\ndetermined from your code. You'll have to edit the\nHTML file to set the size of the applet.\nUse only numeric values (not variables) for the size()\ncommand. See the size() reference for an explanation.", null);
            }
        }
        String description = "";
        String[] javadoc = PApplet.match((String)this.sketch.getCode(0).getProgram(), (String)"/\\*{2,}(.*)\\*+/");
        if (javadoc != null) {
            String[] pieces;
            StringBuffer dbuffer = new StringBuffer();
            for (String line : pieces = PApplet.split((String)javadoc[1], (char)'\n')) {
                String[] m = PApplet.match((String)line, (String)"^\\s*\\*+(.*)");
                dbuffer.append(m != null ? m[1] : line);
                dbuffer.append('\n');
            }
            description = dbuffer.toString();
        }
        StringBuffer sources = new StringBuffer();
        for (SketchCode code : this.sketch.getCode()) {
            sources.append("<a href=\"" + code.getFileName() + "\">" + code.getPrettyName() + "</a> ");
        }
        for (SketchCode code : this.sketch.getCode()) {
            try {
                File exportedSource = new File(appletFolder, code.getFileName());
                code.copyTo(exportedSource);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String preprocFilename = this.sketch.getName() + ".java";
        File preprocFile = new File(this.srcFolder, preprocFilename);
        if (preprocFile.exists()) {
            preprocFile.renameTo(new File(appletFolder, preprocFilename));
        } else {
            System.err.println("Could not copy source file: " + preprocFile.getAbsolutePath());
        }
        boolean separateJar = Preferences.getBoolean("export.applet.separate_jar_files") || this.sketch.hasCodeFolder() || this.javaLibraryPath.length() != 0;
        String LOADING_IMAGE = "loading.gif";
        File loadingImage = new File(this.sketch.getFolder(), LOADING_IMAGE);
        if (!loadingImage.exists()) {
            File skeletonFolder = this.mode.getContentFile("applet");
            loadingImage = new File(skeletonFolder, LOADING_IMAGE);
        }
        Base.copyFile(loadingImage, new File(appletFolder, LOADING_IMAGE));
        FileOutputStream zipOutputFile = new FileOutputStream(new File(appletFolder, this.sketch.getName() + ".jar"));
        ZipOutputStream zos = new ZipOutputStream(zipOutputFile);
        StringBuffer archives = new StringBuffer();
        archives.append(this.sketch.getName() + ".jar");
        this.addManifest(zos);
        boolean openglApplet = false;
        HashMap<String, Object> zipFileContents = new HashMap<String, Object>();
        for (Library library : this.importedLibraries) {
            if (library.getName().equals("OpenGL")) {
                openglApplet = true;
            }
            for (File exportFile : library.getAppletExports()) {
                String exportName = exportFile.getName();
                if (!exportFile.exists()) {
                    System.err.println("File " + exportFile.getAbsolutePath() + " does not exist");
                    continue;
                }
                if (exportFile.isDirectory()) {
                    System.out.println("Ignoring sub-folder \"" + exportFile.getAbsolutePath() + "\"");
                    continue;
                }
                if (exportName.toLowerCase().endsWith(".zip") || exportName.toLowerCase().endsWith(".jar")) {
                    if (separateJar) {
                        Base.copyFile(exportFile, new File(appletFolder, exportName));
                        archives.append("," + exportName);
                        continue;
                    }
                    String path = exportFile.getAbsolutePath();
                    this.packClassPathIntoZipFile(path, zos, zipFileContents);
                    continue;
                }
                Base.copyFile(exportFile, new File(appletFolder, exportName));
            }
        }
        File file = bagelJar = Base.isMacOS() ? Base.getContentFile("core.jar") : Base.getContentFile("lib/core.jar");
        if (separateJar) {
            Base.copyFile(bagelJar, new File(appletFolder, "core.jar"));
            archives.append(",core.jar");
        } else {
            String bagelJarPath = bagelJar.getAbsolutePath();
            this.packClassPathIntoZipFile(bagelJarPath, zos, zipFileContents);
        }
        if (this.sketch.hasCodeFolder()) {
            File[] codeJarFiles = this.sketch.getCodeFolder().listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    if (name.charAt(0) == '.') {
                        return false;
                    }
                    if (name.toLowerCase().endsWith(".jar")) {
                        return true;
                    }
                    return name.toLowerCase().endsWith(".zip");
                }
            });
            for (File exportFile : codeJarFiles) {
                String name = exportFile.getName();
                Base.copyFile(exportFile, new File(appletFolder, name));
                archives.append("," + name);
            }
        }
        this.addDataFolder(zos);
        this.addClasses(zos, this.binFolder);
        zos.flush();
        zos.close();
        File htmlOutputFile = new File(appletFolder, "index.html");
        PrintWriter htmlWriter = PApplet.createWriter((File)htmlOutputFile);
        InputStream is = null;
        File customHtml = new File(this.sketch.getFolder(), "applet.html");
        if (customHtml.exists()) {
            is = new FileInputStream(customHtml);
        }
        if (renderer.equals("OPENGL")) {
            openglApplet = true;
        }
        if (is == null) {
            is = openglApplet ? this.mode.getContentStream("applet/template-opengl.html") : this.mode.getContentStream("applet/template.html");
        }
        BufferedReader reader = PApplet.createReader((InputStream)is);
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("@@") != -1) {
                StringBuffer sb = new StringBuffer(line);
                int index = 0;
                while ((index = sb.indexOf("@@sketch@@")) != -1) {
                    sb.replace(index, index + "@@sketch@@".length(), this.sketch.getName());
                }
                while ((index = sb.indexOf("@@source@@")) != -1) {
                    sb.replace(index, index + "@@source@@".length(), sources.toString());
                }
                while ((index = sb.indexOf("@@archive@@")) != -1) {
                    sb.replace(index, index + "@@archive@@".length(), archives.toString());
                }
                while ((index = sb.indexOf("@@width@@")) != -1) {
                    sb.replace(index, index + "@@width@@".length(), String.valueOf(wide));
                }
                while ((index = sb.indexOf("@@height@@")) != -1) {
                    sb.replace(index, index + "@@height@@".length(), String.valueOf(high));
                }
                while ((index = sb.indexOf("@@description@@")) != -1) {
                    sb.replace(index, index + "@@description@@".length(), description);
                }
                line = sb.toString();
            }
            htmlWriter.println(line);
        }
        reader.close();
        htmlWriter.flush();
        htmlWriter.close();
        return true;
    }

    public static String scrubComments(String what) {
        char[] p = what.toCharArray();
        int index = 0;
        while (index < p.length) {
            if (p[index] == '/' && index < p.length - 1 && p[index + 1] == '/') {
                p[index++] = 32;
                p[index++] = 32;
                while (index < p.length && p[index] != '\n') {
                    p[index++] = 32;
                }
                continue;
            }
            if (p[index] == '/' && index < p.length - 1 && p[index + 1] == '*') {
                p[index++] = 32;
                p[index++] = 32;
                boolean endOfRainbow = false;
                while (index < p.length - 1) {
                    if (p[index] == '*' && p[index + 1] == '/') {
                        p[index++] = 32;
                        p[index++] = 32;
                        endOfRainbow = true;
                        break;
                    }
                    p[index++] = 32;
                }
                if (endOfRainbow) continue;
                throw new RuntimeException("Missing the */ from the end of a /* comment */");
            }
            ++index;
        }
        return new String(p);
    }

    protected boolean exportApplication() throws IOException, SketchException {
        String foundName = this.build();
        if (foundName == null) {
            return false;
        }
        if (!this.sketch.getName().equals(foundName)) {
            Base.showWarning("Error during export", "Sketch name is " + this.sketch.getName() + " but the sketch\n" + "name in the code was " + foundName, null);
            return false;
        }
        File folder = null;
        for (String platformName : PConstants.platformNames) {
            int platform = Base.getPlatformIndex(platformName);
            if (!Preferences.getBoolean("export.application.platform." + platformName)) continue;
            if (Library.hasMultipleArch(platform, this.importedLibraries)) {
                folder = new File(this.sketch.getFolder(), "application." + platformName + "32");
                if (!this.exportApplication(folder, platform, 32)) {
                    return false;
                }
                folder = new File(this.sketch.getFolder(), "application." + platformName + "64");
                if (this.exportApplication(folder, platform, 64)) continue;
                return false;
            }
            folder = new File(this.sketch.getFolder(), "application." + platformName);
            if (this.exportApplication(folder, platform, 0)) continue;
            return false;
        }
        return true;
    }

    private boolean exportApplication(File destFolder, int exportPlatform, int exportBits) throws IOException, SketchException {
        PrintWriter pw;
        int i;
        this.mode.prepareExportFolder(destFolder);
        File jarFolder = new File(destFolder, "lib");
        File dotAppFolder = null;
        if (exportPlatform == 2) {
            dotAppFolder = new File(destFolder, this.sketch.getName() + ".app");
            File dotAppSkeleton = this.mode.getContentFile("application/template.app");
            Base.copyDir(dotAppSkeleton, dotAppFolder);
            String stubName = "Contents/MacOS/JavaApplicationStub";
            if (Base.isWindows()) {
                File warningFile = new File(destFolder, "readme.txt");
                PrintWriter pw2 = PApplet.createWriter((File)warningFile);
                pw2.println("This application was created on Windows, which does not");
                pw2.println("properly support setting files as \"executable\",");
                pw2.println("a necessity for applications on Mac OS X.");
                pw2.println();
                pw2.println("To fix this, use the Terminal on Mac OS X, and from this");
                pw2.println("directory, type the following:");
                pw2.println();
                pw2.println("chmod +x " + dotAppFolder.getName() + "/" + stubName);
                pw2.flush();
                pw2.close();
            } else {
                File stubFile = new File(dotAppFolder, stubName);
                String stubPath = stubFile.getAbsolutePath();
                Runtime.getRuntime().exec(new String[]{"chmod", "+x", stubPath});
            }
            jarFolder = new File(dotAppFolder, "Contents/Resources/Java");
        }
        if (!jarFolder.exists()) {
            jarFolder.mkdirs();
        }
        if (exportPlatform == 1) {
            Base.copyFile(this.mode.getContentFile("application/template.exe"), new File(destFolder, this.sketch.getName() + ".exe"));
        }
        Vector<String> jarListVector = new Vector<String>();
        HashMap<String, Object> zipFileContents = new HashMap<String, Object>();
        FileOutputStream zipOutputFile = new FileOutputStream(new File(jarFolder, this.sketch.getName() + ".jar"));
        ZipOutputStream zos = new ZipOutputStream(zipOutputFile);
        this.addManifest(zos);
        this.addClasses(zos, this.binFolder);
        this.addDataFolder(zos);
        if (this.sketch.hasCodeFolder()) {
            String includes = Base.contentsToClassPath(this.sketch.getCodeFolder());
            String[] codeList = PApplet.splitTokens((String)includes, (String)File.pathSeparator);
            String cp = "";
            for (i = 0; i < codeList.length; ++i) {
                if (codeList[i].toLowerCase().endsWith(".jar") || codeList[i].toLowerCase().endsWith(".zip")) {
                    File exportFile = new File(codeList[i]);
                    String exportFilename = exportFile.getName();
                    Base.copyFile(exportFile, new File(jarFolder, exportFilename));
                    jarListVector.add(exportFilename);
                    continue;
                }
                cp = cp + codeList[i] + File.pathSeparator;
            }
            this.packClassPathIntoZipFile(cp, zos, zipFileContents);
        }
        zos.flush();
        zos.close();
        jarListVector.add(this.sketch.getName() + ".jar");
        File bagelJar = Base.isMacOS() ? Base.getContentFile("core.jar") : Base.getContentFile("lib/core.jar");
        Base.copyFile(bagelJar, new File(jarFolder, "core.jar"));
        jarListVector.add("core.jar");
        for (Library library : this.importedLibraries) {
            for (File exportFile : library.getApplicationExports(exportPlatform, exportBits)) {
                String exportName = exportFile.getName();
                if (!exportFile.exists()) {
                    System.err.println("File " + exportFile.getName() + " does not exist");
                    continue;
                }
                if (exportFile.isDirectory()) {
                    if (exportPlatform == 2) {
                        Base.copyDir(exportFile, new File(jarFolder, exportName));
                        continue;
                    }
                    Base.copyDir(exportFile, new File(destFolder, exportName));
                    continue;
                }
                if (exportFile.getName().toLowerCase().endsWith(".zip") || exportFile.getName().toLowerCase().endsWith(".jar")) {
                    Base.copyFile(exportFile, new File(jarFolder, exportName));
                    jarListVector.add(exportName);
                    continue;
                }
                if (exportPlatform == 2 && exportFile.getName().toLowerCase().endsWith(".jnilib")) {
                    Base.copyFile(exportFile, new File(jarFolder, exportName));
                    continue;
                }
                Base.copyFile(exportFile, new File(destFolder, exportName));
            }
        }
        Object[] jarList = new String[jarListVector.size()];
        jarListVector.copyInto(jarList);
        StringBuffer exportClassPath = new StringBuffer();
        if (exportPlatform == 2) {
            for (i = 0; i < jarList.length; ++i) {
                if (i != 0) {
                    exportClassPath.append(":");
                }
                exportClassPath.append("$JAVAROOT/" + (String)jarList[i]);
            }
        } else if (exportPlatform == 1) {
            for (i = 0; i < jarList.length; ++i) {
                if (i != 0) {
                    exportClassPath.append(",");
                }
                exportClassPath.append((String)jarList[i]);
            }
        } else {
            for (i = 0; i < jarList.length; ++i) {
                if (i != 0) {
                    exportClassPath.append(":");
                }
                exportClassPath.append("$APPDIR/lib/" + (String)jarList[i]);
            }
        }
        String runOptions = Preferences.get("run.options");
        if (Preferences.getBoolean("run.options.memory")) {
            runOptions = runOptions + " -Xms" + Preferences.get("run.options.memory.initial") + "m";
            runOptions = runOptions + " -Xmx" + Preferences.get("run.options.memory.maximum") + "m";
        }
        if (exportPlatform == 2) {
            String PLIST_TEMPLATE = "template.plist";
            File plistTemplate = new File(this.sketch.getFolder(), PLIST_TEMPLATE);
            if (!plistTemplate.exists()) {
                plistTemplate = this.mode.getContentFile("application/template.plist");
            }
            File plistFile = new File(dotAppFolder, "Contents/Info.plist");
            PrintWriter pw3 = PApplet.createWriter((File)plistFile);
            String[] lines = PApplet.loadStrings((File)plistTemplate);
            for (int i2 = 0; i2 < lines.length; ++i2) {
                if (lines[i2].indexOf("@@") != -1) {
                    StringBuffer sb = new StringBuffer(lines[i2]);
                    int index = 0;
                    while ((index = sb.indexOf("@@vmoptions@@")) != -1) {
                        sb.replace(index, index + "@@vmoptions@@".length(), runOptions);
                    }
                    while ((index = sb.indexOf("@@sketch@@")) != -1) {
                        sb.replace(index, index + "@@sketch@@".length(), this.sketch.getName());
                    }
                    while ((index = sb.indexOf("@@classpath@@")) != -1) {
                        sb.replace(index, index + "@@classpath@@".length(), exportClassPath.toString());
                    }
                    while ((index = sb.indexOf("@@lsuipresentationmode@@")) != -1) {
                        sb.replace(index, index + "@@lsuipresentationmode@@".length(), Preferences.getBoolean("export.application.fullscreen") ? "4" : "0");
                    }
                    lines[i2] = sb.toString();
                }
                pw3.print(lines[i2] + "\n");
            }
            pw3.flush();
            pw3.close();
        } else if (exportPlatform == 1) {
            File argsFile = new File(destFolder + "/lib/args.txt");
            pw = PApplet.createWriter((File)argsFile);
            pw.println(runOptions);
            pw.println(this.sketch.getName());
            pw.println(exportClassPath);
            pw.flush();
            pw.close();
        } else {
            File shellScript = new File(destFolder, this.sketch.getName());
            pw = PApplet.createWriter((File)shellScript);
            pw.print("#!/bin/sh\n\n");
            pw.print("APPDIR=$(dirname \"$0\")\n");
            pw.print("java " + Preferences.get("run.options") + " -Djava.library.path=\"$APPDIR\"" + " -cp \"" + exportClassPath + "\"" + " " + this.sketch.getName() + "\n");
            pw.flush();
            pw.close();
            String shellPath = shellScript.getAbsolutePath();
            if (!Base.isWindows()) {
                Runtime.getRuntime().exec(new String[]{"chmod", "+x", shellPath});
            }
        }
        File sourceFolder = new File(destFolder, "source");
        sourceFolder.mkdirs();
        for (SketchCode code : this.sketch.getCode()) {
            try {
                code.copyTo(new File(sourceFolder, code.getFileName()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String preprocFilename = this.sketch.getName() + ".java";
        File preprocFile = new File(this.srcFolder, preprocFilename);
        if (preprocFile.exists()) {
            preprocFile.renameTo(new File(sourceFolder, preprocFilename));
        } else {
            System.err.println("Could not copy source file: " + preprocFile.getAbsolutePath());
        }
        return true;
    }

    protected void addManifest(ZipOutputStream zos) throws IOException {
        ZipEntry entry = new ZipEntry("META-INF/MANIFEST.MF");
        zos.putNextEntry(entry);
        String contents = "Manifest-Version: 1.0\nCreated-By: Processing " + Base.VERSION_NAME + "\n" + "Main-Class: " + this.sketch.getName() + "\n";
        zos.write(contents.getBytes());
        zos.closeEntry();
    }

    protected void addClasses(ZipOutputStream zos, File dir) throws IOException {
        String path = dir.getAbsolutePath();
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + '/';
        }
        this.addClasses(zos, dir, path);
    }

    protected void addClasses(ZipOutputStream zos, File dir, String rootPath) throws IOException {
        File[] files;
        for (File sub : files = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.charAt(0) != '.';
            }
        })) {
            String relativePath = sub.getAbsolutePath().substring(rootPath.length());
            if (sub.isDirectory()) {
                this.addClasses(zos, sub, rootPath);
                continue;
            }
            if (!sub.getName().endsWith(".class")) continue;
            ZipEntry entry = new ZipEntry(relativePath);
            zos.putNextEntry(entry);
            zos.write(Base.loadBytesRaw(sub));
            zos.closeEntry();
        }
    }

    protected void addDataFolder(ZipOutputStream zos) throws IOException {
        if (this.sketch.hasDataFolder()) {
            String[] dataFiles = Base.listFiles(this.sketch.getDataFolder(), false);
            int offset = this.sketch.getFolder().getAbsolutePath().length() + 1;
            for (String path : dataFiles) {
                File dataFile;
                if (Base.isWindows()) {
                    path = path.replace('\\', '/');
                }
                if ((dataFile = new File(path)).isDirectory() || dataFile.getName().charAt(0) == '.') continue;
                ZipEntry entry = new ZipEntry(path.substring(offset));
                zos.putNextEntry(entry);
                zos.write(Base.loadBytesRaw(dataFile));
                zos.closeEntry();
            }
        }
    }

    protected void packClassPathIntoZipFile(String path, ZipOutputStream zos, HashMap<String, Object> zipFileContents) throws IOException {
        String[] pieces = PApplet.split((String)path, (char)File.pathSeparatorChar);
        for (int i = 0; i < pieces.length; ++i) {
            if (pieces[i].length() == 0) continue;
            if (pieces[i].toLowerCase().endsWith(".jar") || pieces[i].toLowerCase().endsWith(".zip")) {
                try {
                    ZipFile file = new ZipFile(pieces[i]);
                    Enumeration<? extends ZipEntry> entries = file.entries();
                    while (entries.hasMoreElements()) {
                        int count;
                        String entryName;
                        ZipEntry entry = entries.nextElement();
                        if (entry.isDirectory() || (entryName = entry.getName()).indexOf("META-INF") == 0 || zipFileContents.get(entryName) != null) continue;
                        zipFileContents.put(entryName, new Object());
                        ZipEntry entree = new ZipEntry(entryName);
                        zos.putNextEntry(entree);
                        byte[] buffer = new byte[(int)entry.getSize()];
                        InputStream is = file.getInputStream(entry);
                        int offset = 0;
                        for (int remaining = buffer.length; remaining > 0; remaining -= count) {
                            count = is.read(buffer, offset, remaining);
                            offset += count;
                        }
                        zos.write(buffer);
                        zos.flush();
                        zos.closeEntry();
                    }
                    continue;
                }
                catch (IOException e) {
                    System.err.println("Error in file " + pieces[i]);
                    e.printStackTrace();
                    continue;
                }
            }
            File dir = new File(pieces[i]);
            if (!dir.exists()) continue;
            JavaBuild.packClassPathIntoZipFileRecursive(dir, null, zos);
        }
    }

    protected static void packClassPathIntoZipFileRecursive(File dir, String sofar, ZipOutputStream zos) throws IOException {
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            String nowfar;
            if (files[i].charAt(0) == '.') continue;
            File sub = new File(dir, files[i]);
            String string = nowfar = sofar == null ? files[i] : sofar + "/" + files[i];
            if (sub.isDirectory()) {
                JavaBuild.packClassPathIntoZipFileRecursive(sub, nowfar, zos);
                continue;
            }
            if (files[i].toLowerCase().endsWith(".jar") || files[i].toLowerCase().endsWith(".zip") || files[i].charAt(0) == '.') continue;
            ZipEntry entry = new ZipEntry(nowfar);
            zos.putNextEntry(entry);
            zos.write(Base.loadBytesRaw(sub));
            zos.closeEntry();
        }
    }
}

