/*
 * Decompiled with CFR 0.152.
 */
package groovy.sql;

import groovy.lang.Closure;
import groovy.lang.GroovyRuntimeException;
import groovy.sql.Sql;
import groovy.sql.SqlWhereVisitor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.stmt.Statement;

public class DataSet
extends Sql {
    private Closure where;
    private DataSet parent;
    private String table;
    private SqlWhereVisitor visitor;
    private String sql;
    private List params;

    public DataSet(Sql sql, Class type) {
        super(sql);
        String table = type.getName();
        int idx = table.lastIndexOf(46);
        if (idx > 0) {
            table = table.substring(idx + 1);
        }
        this.table = table.toLowerCase();
    }

    public DataSet(Sql sql, String table) {
        super(sql);
        this.table = table;
    }

    public DataSet(DataSet parent, Closure where) {
        super(parent);
        this.table = parent.table;
        this.parent = parent;
        this.where = where;
    }

    public void add(Map values) throws SQLException {
        StringBuffer buffer = new StringBuffer("insert into ");
        buffer.append(this.table);
        buffer.append(" (");
        StringBuffer paramBuffer = new StringBuffer();
        boolean first = true;
        Iterator iter = values.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String column = entry.getKey().toString();
            if (first) {
                first = false;
                paramBuffer.append("?");
            } else {
                buffer.append(", ");
                paramBuffer.append(", ?");
            }
            buffer.append(column);
        }
        buffer.append(") values (");
        buffer.append(paramBuffer.toString());
        buffer.append(")");
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(buffer.toString());
            int i = 1;
            Iterator iter2 = values.entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry entry = iter2.next();
                this.setObject(statement, i++, entry.getValue());
            }
            int answer = statement.executeUpdate();
            if (answer != 1) {
                this.log.log(Level.WARNING, "Should have updated 1 row not " + answer + " when trying to add: " + values);
            }
        }
        catch (SQLException e) {
            this.log.log(Level.WARNING, "Failed to add row for: " + values, e);
            throw e;
        }
        finally {
            this.closeResources(connection, statement);
        }
    }

    public DataSet findAll(Closure where) {
        return new DataSet(this, where);
    }

    public void each(Closure closure) throws SQLException {
        this.eachRow(this.getSql(), this.getParameters(), closure);
    }

    public String getSql() {
        if (this.sql == null) {
            this.sql = "select * from " + this.table;
            if (this.where != null) {
                String clause = "";
                if (this.parent != null && this.parent.where != null) {
                    clause = clause + this.parent.getSqlVisitor().getWhere() + " and ";
                }
                if ((clause = clause + this.getSqlVisitor().getWhere()).length() > 0) {
                    this.sql = this.sql + " where " + clause;
                }
            }
        }
        return this.sql;
    }

    public List getParameters() {
        if (this.params == null) {
            this.params = new ArrayList();
            if (this.parent != null && this.parent.where != null) {
                this.params.addAll(this.parent.getParameters());
            }
            this.params.addAll(this.getSqlVisitor().getParameters());
        }
        return this.params;
    }

    protected SqlWhereVisitor getSqlVisitor() {
        if (this.visitor == null) {
            this.visitor = new SqlWhereVisitor();
            if (this.where != null) {
                Statement statement;
                MethodNode method;
                ClassNode classNode = this.where.getMetaClass().getClassNode();
                if (classNode == null) {
                    throw new GroovyRuntimeException("Could not find the ClassNode for MetaClass: " + this.where.getMetaClass());
                }
                List methods = classNode.getDeclaredMethods("doCall");
                if (!methods.isEmpty() && (method = (MethodNode)methods.get(0)) != null && (statement = method.getCode()) != null) {
                    statement.visit(this.visitor);
                }
            }
        }
        return this.visitor;
    }

    public DataSet createView(Closure criteria) {
        return new DataSet(this, criteria);
    }
}

