/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.algorithm.buffer;

import com.projectlibre1.algorithm.buffer.CalculatedValues;
import com.projectlibre1.algorithm.buffer.IntervalCallback;
import com.projectlibre1.algorithm.buffer.SeriesCallback;
import com.projectlibre1.options.CalendarOption;
import com.projectlibre1.pm.calendar.WorkCalendar;
import java.util.Date;
import java.util.TreeMap;

public class NonGroupedCalculatedValues
implements CalculatedValues {
    TreeMap values = new TreeMap();
    double yScale;
    Long[] dates;
    Double[] vals;
    boolean cumulative;
    long origin;
    private static long MILLIS_PER_DAY = CalendarOption.getInstance().getMillisPerDay();

    public NonGroupedCalculatedValues(double d, boolean bl, long l) {
        this.yScale = d;
        this.cumulative = bl;
        this.origin = l;
    }

    public NonGroupedCalculatedValues(boolean bl, long l) {
        this(1.0, bl, l);
    }

    @Override
    public int size() {
        return this.vals.length;
    }

    private void setValue(long l, double d) {
        Long l2 = new Long(l);
        Double d2 = (Double)this.values.get(l2);
        d2 = d2 != null ? new Double(d2 + d) : new Double(d);
        this.values.put(l2, d2);
    }

    @Override
    public void set(int n, long l, long l2, double d, WorkCalendar workCalendar) {
        if (l == 0L) {
            return;
        }
        if (!this.cumulative) {
            long l3 = 0L;
            double d2 = d;
            if (workCalendar != null && (l3 = workCalendar.compare(l2, l, false)) != 0L) {
                d2 /= (double)l3 / (double)CalendarOption.getInstance().getMillisPerDay();
            }
            this.setValue(l, d2);
            this.setValue(l2, -d2);
        } else {
            this.setValue(l, 0.0);
            this.setValue(l2, d);
        }
    }

    @Override
    public void makeSeries(boolean bl, SeriesCallback seriesCallback) {
        Long[] longArray = new Long[this.values.size()];
        Double[] doubleArray = new Double[this.values.size()];
        this.values.keySet().toArray(longArray);
        this.values.values().toArray(doubleArray);
        double d = 0.0;
        double d2 = 0.0;
        if (bl) {
            for (int i = 0; i < longArray.length; ++i) {
                seriesCallback.add(i, longArray[i].doubleValue(), d += doubleArray[i].doubleValue());
            }
        } else {
            for (int i = 0; i < longArray.length; ++i) {
                seriesCallback.add(2 * i, longArray[i].doubleValue(), d);
                seriesCallback.add(2 * i + 1, longArray[i].doubleValue(), d += doubleArray[i].doubleValue());
            }
        }
    }

    @Override
    public void makeRectilinearSeries(SeriesCallback seriesCallback) {
        this.makeSeries(false, seriesCallback);
    }

    public void makeContiguousNonZero(IntervalCallback intervalCallback, WorkCalendar workCalendar) {
        Long[] longArray = new Long[this.values.size()];
        Double[] doubleArray = new Double[this.values.size()];
        this.values.keySet().toArray(longArray);
        this.values.values().toArray(doubleArray);
        double d = 0.0;
        for (int i = 0; i < longArray.length - 1; ++i) {
            intervalCallback.add(longArray.length - 2 - i, longArray[i], longArray[i + 1], d += doubleArray[i].doubleValue());
        }
    }

    @Override
    public void makeCumulative(boolean bl) {
        double d = 0.0;
        for (int i = 0; i < this.vals.length; ++i) {
            if (bl) {
                this.vals[i] = new Double(d += this.vals[i].doubleValue());
                continue;
            }
            this.vals[i] = new Double(this.vals[i] - d);
            d += this.vals[i].doubleValue();
        }
    }

    @Override
    public Long getDate(int n) {
        return this.dates[n];
    }

    @Override
    public Double getValue(int n) {
        return this.vals[n];
    }

    @Override
    public void dump() {
        for (int i = 0; i < this.vals.length; ++i) {
            System.out.println(i + " " + new Date(this.dates[i]) + " " + this.vals[i]);
        }
    }
}

