/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projectlibre1.dialog.AbstractDialog;
import com.projectlibre1.dialog.LicenseDialog;
import com.projectlibre1.dialog.TipOfTheDay;
import com.projectlibre1.pm.graphic.IconManager;
import com.projectlibre1.pm.graphic.frames.GraphicManager;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.util.BrowserControl;
import com.projectlibre1.util.Environment;
import com.projectlibre1.util.VersionUtils;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class HelpDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private static final String helpUrl = "https://www.projectlibre.com/projectlibre-documentation";
    private static final String helpLoginUrl = "https://www.projectlibre.com/user/login";
    private static final String videosUrl = "http://www.projectlibre.com";
    public static final String donateUrl = "https://www.projectlibre.com";
    JButton link;
    JButton registerToHelp;
    JButton videos;
    JButton tipOfTheDay;
    JButton license;
    private JPanel donatePanel;

    public static HelpDialog getInstance(Frame frame) {
        return new HelpDialog(frame);
    }

    private HelpDialog(Frame frame) {
        super(frame, Messages.getString("HelpDialog.About") + " " + Messages.getContextString("Text.ApplicationTitle"), true);
    }

    @Override
    protected void initComponents() {
        this.link = new JButton(Messages.getString("HelpDialog.GoToOnlineHelp"));
        this.link.setEnabled(true);
        this.link.setToolTipText(helpUrl);
        this.link.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserControl.displayURL(HelpDialog.helpUrl);
            }
        });
        this.registerToHelp = new JButton(Messages.getString("HelpDialog.RegisterToOnlineHelp"));
        this.registerToHelp.setEnabled(true);
        this.registerToHelp.setToolTipText(helpUrl);
        this.registerToHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserControl.displayURL(HelpDialog.helpLoginUrl);
            }
        });
        if (Environment.isProjectLibre()) {
            this.tipOfTheDay = new JButton(Messages.getString("HelpDialog.ShowTipsOfTheDay"));
            this.tipOfTheDay.setEnabled(true);
            this.tipOfTheDay.setToolTipText(Messages.getString("HelpDialog.ShowTipsOfTheDay"));
            this.tipOfTheDay.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TipOfTheDay.showDialog(HelpDialog.this.getOwner(), true);
                }
            });
        }
        this.license = new JButton(Messages.getString("HelpDialog.ShowLicense"));
        this.license.setEnabled(true);
        this.license.setToolTipText(Messages.getString("HelpDialog.ShowLicense"));
        this.license.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LicenseDialog.showDialog(GraphicManager.getFrameInstance(), true);
            }
        });
        super.initComponents();
    }

    @Override
    public JComponent createContentPanel() {
        FormLayout formLayout = new FormLayout("120px,180px,120px", "p, 6dlu, p, 6dlu, p, 1dlu, p, 6dlu, p, 6dlu, p, 6dlu, p, 10dlu, p, 6dlu, p, 6dlu, p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        JLabel jLabel = new JLabel(IconManager.getIcon("logo.ProjectLibre"));
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BrowserControl.displayURL(HelpDialog.videosUrl);
            }
        });
        defaultFormBuilder.nextColumn();
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.nextColumn();
        defaultFormBuilder.append(this.link);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.nextColumn();
        defaultFormBuilder.addLabel(Messages.getString("HelpDialog.RegisterToOnlineHelp1"), cellConstraints.xyw(1, 5, 3));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.nextColumn();
        defaultFormBuilder.addLabel(Messages.getString("HelpDialog.RegisterToOnlineHelp2"), cellConstraints.xyw(1, 7, 3));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.nextColumn();
        defaultFormBuilder.append(this.registerToHelp);
        if (Environment.isProjectLibre()) {
            defaultFormBuilder.nextLine(2);
            defaultFormBuilder.nextColumn();
            defaultFormBuilder.append(this.tipOfTheDay);
        }
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.nextColumn();
        defaultFormBuilder.append(this.license);
        defaultFormBuilder.nextLine(2);
        String string = VersionUtils.getVersion();
        defaultFormBuilder.addLabel(Messages.getContextString("Text.ShortTitle") + " Version " + (string == null ? "Unknown" : string), cellConstraints.xyw(1, 15, 3));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.addLabel(Messages.getString("AboutDialog.copyright"), cellConstraints.xyw(1, 17, 3));
        if (Environment.isProjectLibre()) {
            JPanel jPanel = new JPanel();
            jPanel.add(defaultFormBuilder.getPanel());
            return jPanel;
        }
        return defaultFormBuilder.getPanel();
    }

    @Override
    protected boolean hasCloseButton() {
        return true;
    }

    @Override
    protected boolean hasOkAndCancelButtons() {
        return false;
    }

    public static JPanel makeDonatePanel(boolean bl) {
        FormLayout formLayout = new FormLayout("250px", "p, 6dlu,  p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        if (bl) {
            defaultFormBuilder.setDefaultDialogBorder();
        }
        JLabel jLabel = new JLabel(Messages.getString("Text.donateMessage"));
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.nextLine(2);
        ImageIcon imageIcon = IconManager.getIcon("paypal.donate");
        JButton jButton = new JButton(imageIcon);
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        defaultFormBuilder.append(jButton);
        jButton.setEnabled(true);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserControl.displayURL(HelpDialog.donateUrl);
            }
        });
        return defaultFormBuilder.getPanel();
    }
}

