/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.projectlibre1.configuration.Dictionary;
import com.projectlibre1.configuration.NamedItem;
import com.projectlibre1.dialog.AbstractDialog;
import com.projectlibre1.pm.graphic.frames.GraphicManager;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.util.Alert;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public final class RenameDialog
extends AbstractDialog {
    private static final long serialVersionUID = -2400103374793798171L;
    JLabel oldName;
    JTextField newName;
    NamedItem namedItem;
    String result = null;

    public static boolean doRename(Component component, NamedItem namedItem) {
        String string = RenameDialog.getValue(component, namedItem);
        if (string == null || string.equals(namedItem.getName())) {
            return false;
        }
        Dictionary.rename(namedItem, string);
        return true;
    }

    public static String getValue(Component component, NamedItem namedItem) {
        RenameDialog renameDialog = RenameDialog.getInstance(component, namedItem);
        if (renameDialog.doModal()) {
            return renameDialog.getResult();
        }
        return null;
    }

    public static RenameDialog getInstance(Component component, NamedItem namedItem) {
        return new RenameDialog(component, namedItem);
    }

    public final String getResult() {
        return this.result;
    }

    private RenameDialog(Component component, NamedItem namedItem) {
        super(GraphicManager.getInstance(component).getFrame(), Messages.getString("RenameDialog.Rename"), true);
        this.namedItem = namedItem;
        this.oldName = new JLabel();
        this.newName = new JTextField();
    }

    protected void initControls() {
        this.bind(true);
    }

    @Override
    protected boolean bind(boolean bl) {
        if (bl) {
            this.oldName.setText(this.namedItem.getName());
            this.newName.setText(this.namedItem.getName());
            this.setTitle(Messages.getStringWithParam("Text.rename.mf", Dictionary.getCategoryText(this.namedItem.getCategory())));
        } else {
            this.result = this.newName.getText().trim();
            if (this.result.equals(this.namedItem.getName())) {
                return true;
            }
            if (this.result.length() == 0) {
                Alert.warn(Messages.getString("RenameDialog.TheNameCannotBeEmpty"), this);
                return false;
            }
            if (Dictionary.get(this.namedItem.getCategory(), this.result) != null) {
                Alert.warn(Messages.getString("RenameDialog.AnotherItemWithThatNameAlreadyExists"), this);
                return false;
            }
        }
        return true;
    }

    @Override
    public JComponent createContentPanel() {
        this.initControls();
        FormLayout formLayout = new FormLayout("default, 3dlu, 120dlu:grow", "p, 3dlu,p,3dlu,p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        defaultFormBuilder.append(Messages.getString("RenameDialog.CurrentName"), (Component)this.oldName);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("RenameDialog.NewName"), (Component)this.newName);
        return defaultFormBuilder.getPanel();
    }
}

