/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.offline_graphics;

import com.projectlibre1.configuration.Dictionary;
import com.projectlibre1.graphic.configuration.BarStyles;
import com.projectlibre1.offline_graphics.SVGRenderer;
import com.projectlibre1.pm.graphic.graph.GraphParams;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCache;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCacheFactory;
import com.projectlibre1.pm.graphic.model.cache.ReferenceNodeModelCache;
import com.projectlibre1.pm.graphic.model.event.CacheListener;
import com.projectlibre1.pm.graphic.model.event.CompositeCacheEvent;
import com.projectlibre1.pm.graphic.network.NetworkParamsImpl;
import com.projectlibre1.pm.graphic.network.NetworkRenderer;
import com.projectlibre1.pm.graphic.pert.PertLayout;
import com.projectlibre1.pm.graphic.pert.PertRenderer;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheet;
import com.projectlibre1.pm.graphic.timescale.CoordinatesConverter;
import com.projectlibre1.pm.graphic.xbs.XbsLayout;
import com.projectlibre1.pm.graphic.xbs.XbsRenderer;
import com.projectlibre1.pm.task.Project;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class NetworkSVGRenderer
implements SVGRenderer,
CacheListener,
Cloneable {
    public static final int PERT = 1;
    public static final int WBS = 2;
    public static final int RBS = 3;
    protected NetworkParamsImpl params;
    protected CoordinatesConverter coord;
    protected SpreadSheet spreadSheet;
    protected NetworkRenderer renderer;
    protected Project project;

    @Override
    public void init(Project project, ReferenceNodeModelCache referenceNodeModelCache) {
        this.init(project, NodeModelCacheFactory.getInstance().createFilteredCache(referenceNodeModelCache, "Network", null), 1, -1);
    }

    public void init(Project project, NodeModelCache nodeModelCache, int n, int n2) {
        this.project = project;
        this.params = new NetworkParamsImpl();
        this.params.setNetworkLayout(n == 1 ? new PertLayout(this.params) : new XbsLayout(this.params));
        String string = null;
        switch (n) {
            case 1: {
                string = "pert";
                this.renderer = new PertRenderer(this.params);
                this.renderer.setVertical(false);
                break;
            }
            case 2: {
                string = "WBS";
                this.renderer = new XbsRenderer(this.params);
                this.renderer.setVertical(true);
                break;
            }
            case 3: {
                string = "RBS";
                this.renderer = new XbsRenderer(this.params);
                this.renderer.setVertical(true);
            }
        }
        this.params.setBarStyles((BarStyles)Dictionary.get("BarStylesCategory", string));
        this.params.setZoom(n2);
        this.params.setCache(nodeModelCache);
        nodeModelCache.addNodeModelListener(this);
        nodeModelCache.update();
        this.params.updateLayout();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public SVGRenderer createSafePrintCopy() {
        NetworkSVGRenderer networkSVGRenderer = (NetworkSVGRenderer)this.clone();
        networkSVGRenderer.params = (NetworkParamsImpl)networkSVGRenderer.params.createSafePrintCopy();
        networkSVGRenderer.renderer.setGraphInfo(networkSVGRenderer.params);
        return networkSVGRenderer;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        this.paint(graphics2D, -1, -1);
    }

    @Override
    public void paint(Graphics2D graphics2D, int n, int n2) {
        Rectangle rectangle = this.params.getDrawingBounds();
        if (n == -1) {
            graphics2D.drawRect(0, 0, rectangle.width, rectangle.height);
            this.renderer.paint(graphics2D);
        } else {
            Rectangle rectangle2 = this.params.getPrintBounds();
            Rectangle rectangle3 = this.params.getNetworkPrintBounds(n, n2);
            graphics2D.translate(-n2 * rectangle2.width, -n * rectangle2.height);
            this.renderer.paint(graphics2D, rectangle3);
        }
    }

    @Override
    public Dimension getCanvasSize() {
        return this.params.getDrawingBounds().getSize();
    }

    @Override
    public void graphicNodesCompositeEvent(CompositeCacheEvent compositeCacheEvent) {
        this.params.getNetworkLayout().graphicNodesCompositeEvent(compositeCacheEvent);
    }

    @Override
    public GraphParams getParams() {
        return this.params;
    }

    @Override
    public Project getProject() {
        return this.project;
    }
}

