/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.assignment.functor;

import com.projectlibre1.algorithm.CalculationVisitor;
import com.projectlibre1.algorithm.DoubleValue;
import com.projectlibre1.pm.assignment.Assignment;
import com.projectlibre1.pm.assignment.contour.ContourBucketIntervalGenerator;
import com.projectlibre1.pm.calendar.WorkCalendar;

public abstract class AssignmentFieldFunctor
implements CalculationVisitor,
DoubleValue {
    protected Assignment assignment;
    protected WorkCalendar workCalendar = null;
    protected ContourBucketIntervalGenerator contourBucketIntervalGenerator;
    protected boolean cumulative = false;
    private double multiplier = 1.0;
    protected double value = 0.0;

    public final void setMultiplier(double d) {
        this.multiplier = d;
    }

    AssignmentFieldFunctor() {
    }

    AssignmentFieldFunctor(Assignment assignment, WorkCalendar workCalendar, ContourBucketIntervalGenerator contourBucketIntervalGenerator) {
        this.assignment = assignment;
        this.workCalendar = workCalendar;
        this.contourBucketIntervalGenerator = contourBucketIntervalGenerator;
    }

    @Override
    public double getValue() {
        return this.value * this.multiplier;
    }

    @Override
    public void initialize() {
        if (!this.cumulative) {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.value = 0.0;
    }

    @Override
    public boolean isCumulative() {
        return this.cumulative;
    }

    public void setCumulative(boolean bl) {
        this.cumulative = bl;
    }

    public AssignmentFieldFunctor cum() {
        this.setCumulative(true);
        return this;
    }

    public String toString() {
        return "" + this.value;
    }

    public WorkCalendar getWorkCalendar() {
        return this.workCalendar;
    }

    public Assignment getAssignment() {
        return this.assignment;
    }

    public final ContourBucketIntervalGenerator getContourBucketIntervalGenerator() {
        return this.contourBucketIntervalGenerator;
    }
}

