/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.availability;

import com.projectlibre1.field.FieldContext;
import com.projectlibre1.interval.InvalidValueObjectForIntervalException;
import com.projectlibre1.interval.ValueObjectForInterval;
import com.projectlibre1.interval.ValueObjectForIntervalTable;
import com.projectlibre1.pm.availability.HasAvailability;
import com.projectlibre1.util.DateTime;

public class Availability
extends ValueObjectForInterval
implements HasAvailability {
    static final long serialVersionUID = 3647989273828L;
    double maximumUnits = 1.0;

    public Availability(ValueObjectForIntervalTable valueObjectForIntervalTable, long l) {
        super(valueObjectForIntervalTable, l);
    }

    @Override
    public double getMaximumUnits() {
        return this.maximumUnits;
    }

    @Override
    public void setMaximumUnits(double d) {
        this.maximumUnits = d;
    }

    @Override
    public long getAvailableFrom() {
        return this.getStart();
    }

    @Override
    public long getAvailableTo() {
        return this.getEnd();
    }

    @Override
    public void setAvailableFrom(long l) throws InvalidValueObjectForIntervalException {
        this.table.adjustStart(l, this);
    }

    @Override
    public void setAvailableTo(long l) {
        l = Math.min(l, DateTime.getMaxDate().getTime());
        this.setEnd(l);
    }

    @Override
    public boolean isReadOnlyAvailableFrom(FieldContext fieldContext) {
        return this.isDefault();
    }

    @Override
    public boolean isReadOnlyAvailableTo(FieldContext fieldContext) {
        return this.isDefault();
    }

    @Override
    public boolean fieldHideMaximumUnits(FieldContext fieldContext) {
        return false;
    }
}

