/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.chart;

import com.projectlibre1.datatype.Money;
import com.projectlibre1.field.Field;
import com.projectlibre1.graphic.configuration.shape.PredefinedStroke;
import com.projectlibre1.pm.assignment.HasTimeDistributedData;
import com.projectlibre1.pm.graphic.chart.ChartCorner;
import com.projectlibre1.pm.graphic.chart.ChartHelper;
import com.projectlibre1.pm.graphic.chart.ChartInfo;
import com.projectlibre1.pm.graphic.chart.ChartModel;
import com.projectlibre1.pm.graphic.timescale.CoordinatesConverter;
import com.projectlibre1.pm.graphic.timescale.ScaledComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CustomXYToolTipGenerator;
import org.jfree.data.xy.XYDataset;

public class TimeChartPanel
extends ChartPanel
implements Scrollable,
ScaledComponent {
    private static final long serialVersionUID = 2034704461047717965L;
    ChartInfo chartInfo;
    JViewport viewport;
    private Dimension olddmain = null;
    protected boolean verticalScrolling = false;
    JMenuItem verticalScrollingItem;

    public TimeChartPanel(ChartInfo chartInfo) {
        super(chartInfo.setChart(TimeChartPanel.buildChart(chartInfo.getModel())), true);
        this.chartInfo = chartInfo;
        this.setMaximumDrawWidth(4000);
        this.setMaximumDrawHeight(1000);
    }

    public void configureScrollPaneHeaders(JScrollPane jScrollPane, JComponent jComponent) {
        this.viewport = jScrollPane.getViewport();
        if (this.viewport == null || this.viewport.getView() != this) {
            return;
        }
        JViewport jViewport = new JViewport();
        jViewport.setView(jComponent);
        jViewport.setPreferredSize(jComponent.getPreferredSize());
        jScrollPane.setRowHeader(jViewport);
        jScrollPane.setCorner("UPPER_LEFT_CORNER", new ChartCorner(this));
        Border border = jScrollPane.getBorder();
        if (border == null || border instanceof UIResource) {
            jScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        }
        this.viewport.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TimeChartPanel.this.updateTimeScaleComponentSize();
            }
        });
    }

    public void updateTimeScaleComponentSize() {
        Dimension dimension = this.viewport.getViewSize();
        if (dimension.equals(this.olddmain)) {
            return;
        }
        this.olddmain = dimension;
        Dimension dimension2 = this.chartInfo.getAxisPanel().getPreferredSize();
        dimension2.setSize(dimension2.getWidth(), dimension.getHeight());
        this.chartInfo.getAxisPanel().revalidate();
    }

    protected JFreeChart buildChart() {
        JFreeChart jFreeChart = ChartHelper.createChart(this.chartInfo.getModel().getDataset(), this.chartInfo.isHistogram(), this.chartInfo.getModel().getSecondDataset());
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        Object[] objectArray = this.chartInfo.getTraces();
        if (!this.chartInfo.isSimple() && objectArray.length > 0 && objectArray[0] instanceof Field) {
            Format format;
            Field field = (Field)objectArray[0];
            numberFormat = field.isMoney() ? new NumberFormat(){

                @Override
                public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                    return stringBuffer.append(Money.formatCurrency(d, true));
                }

                @Override
                public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                    return null;
                }

                @Override
                public Number parse(String string, ParsePosition parsePosition) {
                    return null;
                }
            } : ((format = field.getFormat()) instanceof NumberFormat ? (NumberFormat)format : NumberFormat.getNumberInstance());
        }
        ((NumberAxis)jFreeChart.getXYPlot().getRangeAxis()).setNumberFormatOverride(numberFormat);
        return jFreeChart;
    }

    public static JFreeChart buildChart(ChartModel chartModel) {
        return ChartHelper.createChart(chartModel.getDataset(), true, chartModel.getSecondDataset());
    }

    public void updateChart() {
        JFreeChart jFreeChart = this.chartInfo.getChart();
        final Object[] objectArray = this.chartInfo.getTraces();
        this.setChart(jFreeChart);
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            Color color = ChartHelper.getColorForField(objectArray[i]);
            if (objectArray[i] == HasTimeDistributedData.AVAILABILITY) {
                jFreeChart.getXYPlot().getRenderer(1).setSeriesPaint(0, color);
                jFreeChart.getXYPlot().getRenderer(1).setSeriesStroke(0, PredefinedStroke.LARGE_FRAMED);
                continue;
            }
            jFreeChart.getXYPlot().getRenderer().setSeriesPaint(n, color);
            jFreeChart.getXYPlot().getRenderer().setToolTipGenerator(new CustomXYToolTipGenerator(){

                @Override
                public String generateToolTip(XYDataset xYDataset, int n, int n2) {
                    return objectArray[0] + " ";
                }
            });
            ++n;
        }
        jFreeChart.getXYPlot().getDomainAxis().setLowerBound(this.chartInfo.getCoord().getOrigin());
        jFreeChart.getXYPlot().getDomainAxis().setUpperBound(Math.max((double)this.chartInfo.getCoord().getEnd(), this.chartInfo.getCoord().toTime(this.viewport.getWidth())));
    }

    public double getNonPlotHeight() {
        ChartRenderingInfo chartRenderingInfo = this.getChartRenderingInfo();
        return chartRenderingInfo.getChartArea().getHeight() - chartRenderingInfo.getPlotInfo().getDataArea().getHeight();
    }

    @Override
    public void setCoord(CoordinatesConverter coordinatesConverter) {
        this.chartInfo.setCoord(coordinatesConverter);
    }

    @Override
    public CoordinatesConverter getCoord() {
        return this.chartInfo.getCoord();
    }

    public boolean isVerticalScrolling() {
        return this.verticalScrolling;
    }

    public void setVerticalScrolling(boolean bl) {
        this.verticalScrolling = bl;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return n == 1 ? rectangle.height : rectangle.width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            if (((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height) {
                return true;
            }
            return !this.verticalScrolling;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return 2;
        }
        return 4;
    }

    @Override
    protected JPopupMenu createPopupMenu(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        JPopupMenu jPopupMenu = super.createPopupMenu(false, bl2, bl3, false);
        return jPopupMenu;
    }
}

