/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.GenericCriteriaPrompt;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.TestOperator;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.DateHelper;

public class GenericCriteria {
    private ProjectProperties m_properties;
    private FieldType m_leftValue;
    private TestOperator m_operator;
    private Object[] m_definedRightValues = new Object[2];
    private Object[] m_workingRightValues = new Object[2];
    private boolean m_symbolicValues;
    private List<GenericCriteria> m_criteriaList = new LinkedList<GenericCriteria>();

    public GenericCriteria(ProjectProperties projectProperties) {
        this.m_properties = projectProperties;
    }

    public void setLeftValue(FieldType fieldType) {
        this.m_leftValue = fieldType;
    }

    public FieldType getLeftValue() {
        return this.m_leftValue;
    }

    public TestOperator getOperator() {
        return this.m_operator;
    }

    public void setOperator(TestOperator testOperator) {
        this.m_operator = testOperator;
    }

    public void setRightValue(int n, Object object) {
        this.m_definedRightValues[n] = object;
        if (object instanceof FieldType) {
            this.m_symbolicValues = true;
        } else if (object instanceof Duration && ((Duration)object).getUnits() != TimeUnit.HOURS) {
            object = ((Duration)object).convertUnits(TimeUnit.HOURS, this.m_properties);
        }
        this.m_workingRightValues[n] = object;
    }

    public Object getValue(int n) {
        return this.m_definedRightValues[n];
    }

    public boolean evaluate(FieldContainer fieldContainer, Map<GenericCriteriaPrompt, Object> map) {
        boolean bl;
        Object object;
        Object object2;
        FieldType fieldType = this.m_leftValue;
        if (fieldType == null) {
            object2 = null;
        } else {
            object2 = fieldContainer.getCurrentValue(fieldType);
            switch (fieldType.getDataType()) {
                case DATE: {
                    if (object2 == null) break;
                    object2 = DateHelper.getDayStartDate((Date)object2);
                    break;
                }
                case DURATION: {
                    if (object2 != null) {
                        object = (Duration)object2;
                        object2 = ((Duration)object).convertUnits(TimeUnit.HOURS, this.m_properties);
                        break;
                    }
                    object2 = Duration.getInstance(0, TimeUnit.HOURS);
                    break;
                }
                case STRING: {
                    object2 = object2 == null ? "" : object2;
                    break;
                }
            }
        }
        object = this.m_symbolicValues ? this.processSymbolicValues(this.m_workingRightValues, fieldContainer, map) : this.m_workingRightValues;
        switch (this.m_operator) {
            case AND: 
            case OR: {
                bl = this.evaluateLogicalOperator(fieldContainer, map);
                break;
            }
            default: {
                bl = this.m_operator.evaluate(object2, object);
            }
        }
        return bl;
    }

    private boolean evaluateLogicalOperator(FieldContainer fieldContainer, Map<GenericCriteriaPrompt, Object> map) {
        boolean bl = false;
        if (this.m_criteriaList.size() == 0) {
            bl = true;
        } else {
            for (GenericCriteria genericCriteria : this.m_criteriaList) {
                bl = genericCriteria.evaluate(fieldContainer, map);
                if ((this.m_operator != TestOperator.AND || bl) && (this.m_operator != TestOperator.OR || !bl)) continue;
                break;
            }
        }
        return bl;
    }

    private Object[] processSymbolicValues(Object[] objectArray, FieldContainer fieldContainer, Map<GenericCriteriaPrompt, Object> map) {
        Object[] objectArray2 = new Object[2];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            Object object2 = objectArray[i];
            if (object2 == null) continue;
            if (object2 instanceof FieldType) {
                object = (FieldType)object2;
                object2 = fieldContainer.getCachedValue((FieldType)object);
                switch (object.getDataType()) {
                    case DATE: {
                        if (object2 == null) break;
                        object2 = DateHelper.getDayStartDate((Date)object2);
                        break;
                    }
                    case DURATION: {
                        if (object2 != null && ((Duration)object2).getUnits() != TimeUnit.HOURS) {
                            object2 = ((Duration)object2).convertUnits(TimeUnit.HOURS, this.m_properties);
                            break;
                        }
                        object2 = Duration.getInstance(0, TimeUnit.HOURS);
                        break;
                    }
                    case STRING: {
                        object2 = object2 == null ? "" : object2;
                        break;
                    }
                }
            } else if (object2 instanceof GenericCriteriaPrompt && map != null) {
                object = (GenericCriteriaPrompt)object2;
                object2 = map.get(object);
            }
            objectArray2[i] = object2;
        }
        return objectArray2;
    }

    public List<GenericCriteria> getCriteriaList() {
        return this.m_criteriaList;
    }

    public void addCriteria(GenericCriteria genericCriteria) {
        this.m_criteriaList.add(genericCriteria);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        switch (this.m_operator) {
            case AND: 
            case OR: {
                int n = 0;
                for (GenericCriteria genericCriteria : this.m_criteriaList) {
                    stringBuilder.append(genericCriteria);
                    if (++n >= this.m_criteriaList.size()) continue;
                    stringBuilder.append(" ");
                    stringBuilder.append(this.m_operator);
                    stringBuilder.append(" ");
                }
                break;
            }
            default: {
                stringBuilder.append(this.m_leftValue);
                stringBuilder.append(" ");
                stringBuilder.append(this.m_operator);
                stringBuilder.append(" ");
                stringBuilder.append(this.m_definedRightValues[0]);
                if (this.m_definedRightValues[1] == null) break;
                stringBuilder.append(",");
                stringBuilder.append(this.m_definedRightValues[1]);
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

