/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mspdi;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.Availability;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.RecurringData;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskMode;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedItem;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.common.AssignmentFieldLists;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.common.MPPAssignmentField;
import net.sf.mpxj.common.MPPResourceField;
import net.sf.mpxj.common.MPPTaskField;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.ResourceFieldLists;
import net.sf.mpxj.common.TaskFieldLists;
import net.sf.mpxj.mspdi.DatatypeConverter;
import net.sf.mpxj.mspdi.SaveVersion;
import net.sf.mpxj.mspdi.schema.ObjectFactory;
import net.sf.mpxj.mspdi.schema.Project;
import net.sf.mpxj.mspdi.schema.TimephasedDataType;
import net.sf.mpxj.writer.AbstractProjectWriter;

public class MSPDIWriter
extends AbstractProjectWriter {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private static final int[] DAY_MASKS;
    protected ObjectFactory m_factory;
    protected ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private Set<FieldType> m_extendedAttributesInUse;
    private boolean m_splitTimephasedAsDays = true;
    private boolean m_writeTimphasedData;
    private SaveVersion m_saveVersion = SaveVersion.Project2016;
    private static final BigInteger BIGINTEGER_ZERO;
    private static final Integer NULL_RESOURCE_ID;

    public void setSplitTimephasedAsDays(boolean bl) {
        this.m_splitTimephasedAsDays = bl;
    }

    public boolean getSplitTimephasedAsDays() {
        return this.m_splitTimephasedAsDays;
    }

    public void setWriteTimephasedData(boolean bl) {
        this.m_writeTimphasedData = bl;
    }

    public boolean getWriteTimephasedData() {
        return this.m_writeTimphasedData;
    }

    public void setSaveVersion(SaveVersion saveVersion) {
        this.m_saveVersion = saveVersion;
    }

    public SaveVersion getSaveVersion() {
        return this.m_saveVersion;
    }

    @Override
    public void write(ProjectFile projectFile, OutputStream outputStream) throws IOException {
        try {
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            this.m_projectFile = projectFile;
            this.m_projectFile.validateUniqueIDsForMicrosoftProject();
            this.m_eventManager = this.m_projectFile.getEventManager();
            Marshaller marshaller = CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            this.m_extendedAttributesInUse = new HashSet<FieldType>();
            this.m_factory = new ObjectFactory();
            Project project = this.m_factory.createProject();
            this.writeProjectProperties(project);
            this.writeCalendars(project);
            this.writeResources(project);
            this.writeTasks(project);
            this.writeAssignments(project);
            this.writeProjectExtendedAttributes(project);
            DatatypeConverter.setParentFile(this.m_projectFile);
            marshaller.marshal((Object)project, outputStream);
        }
        catch (JAXBException jAXBException) {
            throw new IOException(jAXBException.toString());
        }
        finally {
            this.m_projectFile = null;
            this.m_factory = null;
            this.m_extendedAttributesInUse = null;
        }
    }

    private void writeProjectProperties(Project project) {
        ProjectProperties projectProperties = this.m_projectFile.getProjectProperties();
        project.setActualsInSync(projectProperties.getActualsInSync());
        project.setAdminProject(projectProperties.getAdminProject());
        project.setAuthor(projectProperties.getAuthor());
        project.setAutoAddNewResourcesAndTasks(projectProperties.getAutoAddNewResourcesAndTasks());
        project.setAutolink(projectProperties.getAutolink());
        project.setBaselineForEarnedValue(NumberHelper.getBigInteger(projectProperties.getBaselineForEarnedValue()));
        project.setCalendarUID(this.m_projectFile.getDefaultCalendar() == null ? BigInteger.ONE : NumberHelper.getBigInteger(this.m_projectFile.getDefaultCalendar().getUniqueID()));
        project.setCategory(projectProperties.getCategory());
        project.setCompany(projectProperties.getCompany());
        project.setCreationDate(DatatypeConverter.printDate(projectProperties.getCreationDate()));
        project.setCriticalSlackLimit(NumberHelper.getBigInteger(projectProperties.getCriticalSlackLimit()));
        project.setCurrencyCode(projectProperties.getCurrencyCode());
        project.setCurrencyDigits(BigInteger.valueOf(projectProperties.getCurrencyDigits().intValue()));
        project.setCurrencySymbol(projectProperties.getCurrencySymbol());
        project.setCurrencySymbolPosition(projectProperties.getSymbolPosition());
        project.setCurrentDate(DatatypeConverter.printDate(projectProperties.getCurrentDate()));
        project.setDaysPerMonth(NumberHelper.getBigInteger(projectProperties.getDaysPerMonth()));
        project.setDefaultFinishTime(DatatypeConverter.printTime(projectProperties.getDefaultEndTime()));
        project.setDefaultFixedCostAccrual(projectProperties.getDefaultFixedCostAccrual());
        project.setDefaultOvertimeRate(DatatypeConverter.printRate(projectProperties.getDefaultOvertimeRate()));
        project.setDefaultStandardRate(DatatypeConverter.printRate(projectProperties.getDefaultStandardRate()));
        project.setDefaultStartTime(DatatypeConverter.printTime(projectProperties.getDefaultStartTime()));
        project.setDefaultTaskEVMethod(DatatypeConverter.printEarnedValueMethod(projectProperties.getDefaultTaskEarnedValueMethod()));
        project.setDefaultTaskType(projectProperties.getDefaultTaskType());
        project.setDurationFormat(DatatypeConverter.printDurationTimeUnits(projectProperties.getDefaultDurationUnits(), false));
        project.setEarnedValueMethod(DatatypeConverter.printEarnedValueMethod(projectProperties.getEarnedValueMethod()));
        project.setEditableActualCosts(projectProperties.getEditableActualCosts());
        project.setExtendedCreationDate(DatatypeConverter.printDate(projectProperties.getExtendedCreationDate()));
        project.setFinishDate(DatatypeConverter.printDate(projectProperties.getFinishDate()));
        project.setFiscalYearStart(projectProperties.getFiscalYearStart());
        project.setFYStartDate(NumberHelper.getBigInteger(projectProperties.getFiscalYearStartMonth()));
        project.setHonorConstraints(projectProperties.getHonorConstraints());
        project.setInsertedProjectsLikeSummary(projectProperties.getInsertedProjectsLikeSummary());
        project.setLastSaved(DatatypeConverter.printDate(projectProperties.getLastSaved()));
        project.setManager(projectProperties.getManager());
        project.setMicrosoftProjectServerURL(projectProperties.getMicrosoftProjectServerURL());
        project.setMinutesPerDay(NumberHelper.getBigInteger(projectProperties.getMinutesPerDay()));
        project.setMinutesPerWeek(NumberHelper.getBigInteger(projectProperties.getMinutesPerWeek()));
        project.setMoveCompletedEndsBack(projectProperties.getMoveCompletedEndsBack());
        project.setMoveCompletedEndsForward(projectProperties.getMoveCompletedEndsForward());
        project.setMoveRemainingStartsBack(projectProperties.getMoveRemainingStartsBack());
        project.setMoveRemainingStartsForward(projectProperties.getMoveRemainingStartsForward());
        project.setMultipleCriticalPaths(projectProperties.getMultipleCriticalPaths());
        project.setName(projectProperties.getName());
        project.setNewTasksEffortDriven(projectProperties.getNewTasksEffortDriven());
        project.setNewTasksEstimated(projectProperties.getNewTasksEstimated());
        project.setNewTaskStartDate(projectProperties.getNewTaskStartIsProjectStart() ? BigInteger.ZERO : BigInteger.ONE);
        project.setProjectExternallyEdited(projectProperties.getProjectExternallyEdited());
        project.setRemoveFileProperties(projectProperties.getRemoveFileProperties());
        project.setRevision(NumberHelper.getBigInteger(projectProperties.getRevision()));
        project.setSaveVersion(BigInteger.valueOf(this.m_saveVersion.getValue()));
        project.setScheduleFromStart(projectProperties.getScheduleFrom() == ScheduleFrom.START);
        project.setSplitsInProgressTasks(projectProperties.getSplitInProgressTasks());
        project.setSpreadActualCost(projectProperties.getSpreadActualCost());
        project.setSpreadPercentComplete(projectProperties.getSpreadPercentComplete());
        project.setStartDate(DatatypeConverter.printDate(projectProperties.getStartDate()));
        project.setStatusDate(DatatypeConverter.printDate(projectProperties.getStatusDate()));
        project.setSubject(projectProperties.getSubject());
        project.setTaskUpdatesResource(projectProperties.getUpdatingTaskStatusUpdatesResourceStatus());
        project.setTitle(projectProperties.getProjectTitle());
        project.setUID(projectProperties.getUniqueID());
        project.setWeekStartDay(DatatypeConverter.printDay(projectProperties.getWeekStartDay()));
        project.setWorkFormat(DatatypeConverter.printWorkUnits(projectProperties.getDefaultWorkUnits()));
    }

    private void writeProjectExtendedAttributes(Project project) {
        Object object;
        Project.ExtendedAttributes extendedAttributes = this.m_factory.createProjectExtendedAttributes();
        project.setExtendedAttributes(extendedAttributes);
        List<Project.ExtendedAttributes.ExtendedAttribute> list = extendedAttributes.getExtendedAttribute();
        HashSet<FieldType> hashSet = new HashSet<FieldType>();
        for (CustomField object2 : this.m_projectFile.getCustomFields()) {
            object = object2.getFieldType();
            if (object == null) continue;
            hashSet.add((FieldType)object);
        }
        hashSet.addAll(this.m_extendedAttributesInUse);
        for (FieldType fieldType : hashSet) {
            object = this.m_factory.createProjectExtendedAttributesExtendedAttribute();
            list.add((Project.ExtendedAttributes.ExtendedAttribute)object);
            ((Project.ExtendedAttributes.ExtendedAttribute)object).setFieldID(String.valueOf(FieldTypeHelper.getFieldID(fieldType)));
            ((Project.ExtendedAttributes.ExtendedAttribute)object).setFieldName(fieldType.getName());
            CustomField customField = this.m_projectFile.getCustomFields().getCustomField(fieldType);
            String string = customField.getAlias();
            ((Project.ExtendedAttributes.ExtendedAttribute)object).setAlias(string);
        }
    }

    private void writeCalendars(Project project) {
        Project.Calendars calendars = this.m_factory.createProjectCalendars();
        project.setCalendars(calendars);
        List<Project.Calendars.Calendar> list = calendars.getCalendar();
        for (ProjectCalendar projectCalendar : this.m_projectFile.getCalendars()) {
            list.add(this.writeCalendar(projectCalendar));
        }
    }

    private Project.Calendars.Calendar writeCalendar(ProjectCalendar projectCalendar) {
        Project.Calendars.Calendar calendar = this.m_factory.createProjectCalendarsCalendar();
        calendar.setUID(NumberHelper.getBigInteger(projectCalendar.getUniqueID()));
        calendar.setIsBaseCalendar(!projectCalendar.isDerived());
        ProjectCalendar projectCalendar2 = projectCalendar.getParent();
        if (projectCalendar2 != null) {
            calendar.setBaseCalendarUID(NumberHelper.getBigInteger(projectCalendar2.getUniqueID()));
        }
        calendar.setName(projectCalendar.getName());
        Project.Calendars.Calendar.WeekDays weekDays = this.m_factory.createProjectCalendarsCalendarWeekDays();
        List<Project.Calendars.Calendar.WeekDays.WeekDay> list = weekDays.getWeekDay();
        for (int i = 1; i < 8; ++i) {
            DayType dayType = projectCalendar.getWorkingDay(Day.getInstance(i));
            if (dayType == DayType.DEFAULT) continue;
            Project.Calendars.Calendar.WeekDays.WeekDay weekDay = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDay();
            list.add(weekDay);
            weekDay.setDayType(BigInteger.valueOf(i));
            weekDay.setDayWorking(dayType == DayType.WORKING);
            if (dayType != DayType.WORKING) continue;
            Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes workingTimes = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimes();
            weekDay.setWorkingTimes(workingTimes);
            List<Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime> list2 = workingTimes.getWorkingTime();
            ProjectCalendarHours projectCalendarHours = projectCalendar.getCalendarHours(Day.getInstance(i));
            if (projectCalendarHours == null) continue;
            for (DateRange dateRange : projectCalendarHours) {
                if (dateRange == null) continue;
                Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime workingTime = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimesWorkingTime();
                list2.add(workingTime);
                workingTime.setFromTime(DatatypeConverter.printTime(dateRange.getStart()));
                workingTime.setToTime(DatatypeConverter.printTime(dateRange.getEnd()));
            }
        }
        ArrayList<ProjectCalendarException> arrayList = new ArrayList<ProjectCalendarException>(projectCalendar.getCalendarExceptions());
        if (!arrayList.isEmpty()) {
            Collections.sort(arrayList);
            this.writeExceptions(calendar, list, arrayList);
        }
        if (!list.isEmpty()) {
            calendar.setWeekDays(weekDays);
        }
        this.writeWorkWeeks(calendar, projectCalendar);
        this.m_eventManager.fireCalendarWrittenEvent(projectCalendar);
        return calendar;
    }

    private void writeExceptions(Project.Calendars.Calendar calendar, List<Project.Calendars.Calendar.WeekDays.WeekDay> list, List<ProjectCalendarException> list2) {
        if (this.m_saveVersion.getValue() < SaveVersion.Project2007.getValue()) {
            this.writeExcepions9(list, list2);
        } else {
            this.writeExcepions12(calendar, list2);
        }
    }

    private void writeExcepions9(List<Project.Calendars.Calendar.WeekDays.WeekDay> list, List<ProjectCalendarException> list2) {
        for (ProjectCalendarException projectCalendarException : list2) {
            boolean bl = projectCalendarException.getWorking();
            Project.Calendars.Calendar.WeekDays.WeekDay weekDay = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDay();
            list.add(weekDay);
            weekDay.setDayType(BIGINTEGER_ZERO);
            weekDay.setDayWorking(bl);
            Project.Calendars.Calendar.WeekDays.WeekDay.TimePeriod timePeriod = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayTimePeriod();
            weekDay.setTimePeriod(timePeriod);
            timePeriod.setFromDate(DatatypeConverter.printDate(projectCalendarException.getFromDate()));
            timePeriod.setToDate(DatatypeConverter.printDate(projectCalendarException.getToDate()));
            if (!bl) continue;
            Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes workingTimes = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimes();
            weekDay.setWorkingTimes(workingTimes);
            List<Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime> list3 = workingTimes.getWorkingTime();
            for (DateRange dateRange : projectCalendarException) {
                Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime workingTime = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimesWorkingTime();
                list3.add(workingTime);
                workingTime.setFromTime(DatatypeConverter.printTime(dateRange.getStart()));
                workingTime.setToTime(DatatypeConverter.printTime(dateRange.getEnd()));
            }
        }
    }

    private void writeExcepions12(Project.Calendars.Calendar calendar, List<ProjectCalendarException> list) {
        Project.Calendars.Calendar.Exceptions exceptions = this.m_factory.createProjectCalendarsCalendarExceptions();
        calendar.setExceptions(exceptions);
        List<Project.Calendars.Calendar.Exceptions.Exception> list2 = exceptions.getException();
        for (ProjectCalendarException projectCalendarException : list) {
            Project.Calendars.Calendar.Exceptions.Exception exception = this.m_factory.createProjectCalendarsCalendarExceptionsException();
            list2.add(exception);
            exception.setName(projectCalendarException.getName());
            boolean bl = projectCalendarException.getWorking();
            exception.setDayWorking(bl);
            if (projectCalendarException.getRecurring() == null) {
                exception.setEnteredByOccurrences(Boolean.FALSE);
                exception.setOccurrences(BigInteger.ONE);
                exception.setType(BigInteger.ONE);
            } else {
                this.populateRecurringException(projectCalendarException, exception);
            }
            Project.Calendars.Calendar.Exceptions.Exception.TimePeriod timePeriod = this.m_factory.createProjectCalendarsCalendarExceptionsExceptionTimePeriod();
            exception.setTimePeriod(timePeriod);
            timePeriod.setFromDate(DatatypeConverter.printDate(projectCalendarException.getFromDate()));
            timePeriod.setToDate(DatatypeConverter.printDate(projectCalendarException.getToDate()));
            if (!bl) continue;
            Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes workingTimes = this.m_factory.createProjectCalendarsCalendarExceptionsExceptionWorkingTimes();
            exception.setWorkingTimes(workingTimes);
            List<Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes.WorkingTime> list3 = workingTimes.getWorkingTime();
            for (DateRange dateRange : projectCalendarException) {
                Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes.WorkingTime workingTime = this.m_factory.createProjectCalendarsCalendarExceptionsExceptionWorkingTimesWorkingTime();
                list3.add(workingTime);
                workingTime.setFromTime(DatatypeConverter.printTime(dateRange.getStart()));
                workingTime.setToTime(DatatypeConverter.printTime(dateRange.getEnd()));
            }
        }
    }

    private void populateRecurringException(ProjectCalendarException projectCalendarException, Project.Calendars.Calendar.Exceptions.Exception exception) {
        RecurringData recurringData = projectCalendarException.getRecurring();
        exception.setEnteredByOccurrences(Boolean.TRUE);
        exception.setOccurrences(NumberHelper.getBigInteger(recurringData.getOccurrences()));
        switch (recurringData.getRecurrenceType()) {
            case DAILY: {
                exception.setType(BigInteger.valueOf(7L));
                exception.setPeriod(NumberHelper.getBigInteger(recurringData.getFrequency()));
                break;
            }
            case WEEKLY: {
                exception.setType(BigInteger.valueOf(6L));
                exception.setPeriod(NumberHelper.getBigInteger(recurringData.getFrequency()));
                exception.setDaysOfWeek(this.getDaysOfTheWeek(recurringData));
                break;
            }
            case MONTHLY: {
                exception.setPeriod(NumberHelper.getBigInteger(recurringData.getFrequency()));
                if (recurringData.getRelative()) {
                    exception.setType(BigInteger.valueOf(5L));
                    exception.setMonthItem(BigInteger.valueOf(recurringData.getDayOfWeek().getValue() + 2));
                    exception.setMonthPosition(BigInteger.valueOf(NumberHelper.getInt(recurringData.getDayNumber()) - 1));
                    break;
                }
                exception.setType(BigInteger.valueOf(4L));
                exception.setMonthDay(NumberHelper.getBigInteger(recurringData.getDayNumber()));
                break;
            }
            case YEARLY: {
                exception.setMonth(BigInteger.valueOf(NumberHelper.getInt(recurringData.getMonthNumber()) - 1));
                if (recurringData.getRelative()) {
                    exception.setType(BigInteger.valueOf(3L));
                    exception.setMonthItem(BigInteger.valueOf(recurringData.getDayOfWeek().getValue() + 2));
                    exception.setMonthPosition(BigInteger.valueOf(NumberHelper.getInt(recurringData.getDayNumber()) - 1));
                    break;
                }
                exception.setType(BigInteger.valueOf(2L));
                exception.setMonthDay(NumberHelper.getBigInteger(recurringData.getDayNumber()));
            }
        }
    }

    private BigInteger getDaysOfTheWeek(RecurringData recurringData) {
        int n = 0;
        for (Day day : Day.values()) {
            if (!recurringData.getWeeklyDay(day)) continue;
            n |= DAY_MASKS[day.getValue()];
        }
        return BigInteger.valueOf(n);
    }

    private void writeWorkWeeks(Project.Calendars.Calendar calendar, ProjectCalendar projectCalendar) {
        List<ProjectCalendarWeek> list = projectCalendar.getWorkWeeks();
        if (!list.isEmpty()) {
            Project.Calendars.Calendar.WorkWeeks workWeeks = this.m_factory.createProjectCalendarsCalendarWorkWeeks();
            calendar.setWorkWeeks(workWeeks);
            List<Project.Calendars.Calendar.WorkWeeks.WorkWeek> list2 = workWeeks.getWorkWeek();
            for (ProjectCalendarWeek projectCalendarWeek : list) {
                Project.Calendars.Calendar.WorkWeeks.WorkWeek workWeek = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeek();
                list2.add(workWeek);
                workWeek.setName(projectCalendarWeek.getName());
                Project.Calendars.Calendar.WorkWeeks.WorkWeek.TimePeriod timePeriod = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekTimePeriod();
                workWeek.setTimePeriod(timePeriod);
                timePeriod.setFromDate(DatatypeConverter.printDate(projectCalendarWeek.getDateRange().getStart()));
                timePeriod.setToDate(DatatypeConverter.printDate(projectCalendarWeek.getDateRange().getEnd()));
                Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays weekDays = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekWeekDays();
                workWeek.setWeekDays(weekDays);
                List<Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay> list3 = weekDays.getWeekDay();
                for (int i = 1; i < 8; ++i) {
                    DayType dayType = projectCalendarWeek.getWorkingDay(Day.getInstance(i));
                    if (dayType == DayType.DEFAULT) continue;
                    Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay weekDay = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekWeekDaysWeekDay();
                    list3.add(weekDay);
                    weekDay.setDayType(BigInteger.valueOf(i));
                    weekDay.setDayWorking(dayType == DayType.WORKING);
                    if (dayType != DayType.WORKING) continue;
                    Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes workingTimes = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekWeekDaysWeekDayWorkingTimes();
                    weekDay.setWorkingTimes(workingTimes);
                    List<Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes.WorkingTime> list4 = workingTimes.getWorkingTime();
                    ProjectCalendarHours projectCalendarHours = projectCalendarWeek.getCalendarHours(Day.getInstance(i));
                    if (projectCalendarHours == null) continue;
                    for (DateRange dateRange : projectCalendarHours) {
                        if (dateRange == null) continue;
                        Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes.WorkingTime workingTime = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekWeekDaysWeekDayWorkingTimesWorkingTime();
                        list4.add(workingTime);
                        workingTime.setFromTime(DatatypeConverter.printTime(dateRange.getStart()));
                        workingTime.setToTime(DatatypeConverter.printTime(dateRange.getEnd()));
                    }
                }
            }
        }
    }

    protected void writeResources(Project project) {
        Project.Resources resources = this.m_factory.createProjectResources();
        project.setResources(resources);
        List<Project.Resources.Resource> list = resources.getResource();
        for (Resource resource : this.m_projectFile.getResources()) {
            list.add(this.writeResource(resource));
        }
    }

    protected Project.Resources.Resource writeResource(Resource resource) {
        Project.Resources.Resource resource2 = this.m_factory.createProjectResourcesResource();
        ProjectCalendar projectCalendar = resource.getResourceCalendar();
        if (projectCalendar != null) {
            resource2.setCalendarUID(NumberHelper.getBigInteger(projectCalendar.getUniqueID()));
        }
        resource2.setAccrueAt(resource.getAccrueAt());
        resource2.setActiveDirectoryGUID(resource.getActiveDirectoryGUID());
        resource2.setActualCost(DatatypeConverter.printCurrency(resource.getActualCost()));
        resource2.setActualOvertimeCost(DatatypeConverter.printCurrency(resource.getActualOvertimeCost()));
        resource2.setActualOvertimeWork(DatatypeConverter.printDuration(this, resource.getActualOvertimeWork()));
        resource2.setActualOvertimeWorkProtected(DatatypeConverter.printDuration(this, resource.getActualOvertimeWorkProtected()));
        resource2.setActualWork(DatatypeConverter.printDuration(this, resource.getActualWork()));
        resource2.setActualWorkProtected(DatatypeConverter.printDuration(this, resource.getActualWorkProtected()));
        resource2.setACWP(DatatypeConverter.printCurrency(resource.getACWP()));
        resource2.setAvailableFrom(DatatypeConverter.printDate(resource.getAvailableFrom()));
        resource2.setAvailableTo(DatatypeConverter.printDate(resource.getAvailableTo()));
        resource2.setBCWS(DatatypeConverter.printCurrency(resource.getBCWS()));
        resource2.setBCWP(DatatypeConverter.printCurrency(resource.getBCWP()));
        resource2.setBookingType(resource.getBookingType());
        resource2.setIsBudget(resource.getBudget());
        resource2.setCanLevel(resource.getCanLevel());
        resource2.setCode(resource.getCode());
        resource2.setCost(DatatypeConverter.printCurrency(resource.getCost()));
        resource2.setCostPerUse(DatatypeConverter.printCurrency(resource.getCostPerUse()));
        resource2.setCostVariance(DatatypeConverter.printCurrency(resource.getCostVariance()));
        resource2.setCreationDate(DatatypeConverter.printDate(resource.getCreationDate()));
        resource2.setCV(DatatypeConverter.printCurrency(resource.getCV()));
        resource2.setEmailAddress(resource.getEmailAddress());
        resource2.setFinish(DatatypeConverter.printDate(resource.getFinish()));
        resource2.setGroup(resource.getGroup());
        resource2.setHyperlink(resource.getHyperlink());
        resource2.setHyperlinkAddress(resource.getHyperlinkAddress());
        resource2.setHyperlinkSubAddress(resource.getHyperlinkSubAddress());
        resource2.setID(NumberHelper.getBigInteger(resource.getID()));
        resource2.setInitials(resource.getInitials());
        resource2.setIsEnterprise(resource.getEnterprise());
        resource2.setIsGeneric(resource.getGeneric());
        resource2.setIsInactive(resource.getInactive());
        resource2.setIsNull(resource.getNull());
        resource2.setMaterialLabel(resource.getMaterialLabel());
        resource2.setMaxUnits(DatatypeConverter.printUnits(resource.getMaxUnits()));
        resource2.setName(resource.getName());
        if (!resource.getNotes().isEmpty()) {
            resource2.setNotes(resource.getNotes());
        }
        resource2.setNTAccount(resource.getNtAccount());
        resource2.setOverAllocated(resource.getOverAllocated());
        resource2.setOvertimeCost(DatatypeConverter.printCurrency(resource.getOvertimeCost()));
        resource2.setOvertimeRate(DatatypeConverter.printRate(resource.getOvertimeRate()));
        resource2.setOvertimeRateFormat(DatatypeConverter.printTimeUnit(resource.getOvertimeRateUnits()));
        resource2.setOvertimeWork(DatatypeConverter.printDuration(this, resource.getOvertimeWork()));
        resource2.setPeakUnits(DatatypeConverter.printUnits(resource.getPeakUnits()));
        resource2.setPercentWorkComplete(NumberHelper.getBigInteger(resource.getPercentWorkComplete()));
        resource2.setPhonetics(resource.getPhonetics());
        resource2.setRegularWork(DatatypeConverter.printDuration(this, resource.getRegularWork()));
        resource2.setRemainingCost(DatatypeConverter.printCurrency(resource.getRemainingCost()));
        resource2.setRemainingOvertimeCost(DatatypeConverter.printCurrency(resource.getRemainingOvertimeCost()));
        resource2.setRemainingOvertimeWork(DatatypeConverter.printDuration(this, resource.getRemainingOvertimeWork()));
        resource2.setRemainingWork(DatatypeConverter.printDuration(this, resource.getRemainingWork()));
        resource2.setStandardRate(DatatypeConverter.printRate(resource.getStandardRate()));
        resource2.setStandardRateFormat(DatatypeConverter.printTimeUnit(resource.getStandardRateUnits()));
        resource2.setStart(DatatypeConverter.printDate(resource.getStart()));
        resource2.setSV(DatatypeConverter.printCurrency(resource.getSV()));
        resource2.setUID(resource.getUniqueID());
        resource2.setWork(DatatypeConverter.printDuration(this, resource.getWork()));
        resource2.setWorkGroup(resource.getWorkGroup());
        resource2.setWorkVariance(DatatypeConverter.printDurationInDecimalThousandthsOfMinutes(resource.getWorkVariance()));
        if (resource.getType() == ResourceType.COST) {
            resource2.setType(ResourceType.MATERIAL);
            resource2.setIsCostResource(Boolean.TRUE);
        } else {
            resource2.setType(resource.getType());
        }
        this.writeResourceExtendedAttributes(resource2, resource);
        this.writeResourceBaselines(resource2, resource);
        this.writeCostRateTables(resource2, resource);
        this.writeAvailability(resource2, resource);
        return resource2;
    }

    private void writeResourceBaselines(Project.Resources.Resource resource, Resource resource2) {
        Duration duration;
        Project.Resources.Resource.Baseline baseline = this.m_factory.createProjectResourcesResourceBaseline();
        boolean bl = false;
        Number number = resource2.getBaselineCost();
        if (number != null && number.intValue() != 0) {
            bl = true;
            baseline.setCost(DatatypeConverter.printCurrency(number));
        }
        if ((duration = resource2.getBaselineWork()) != null && duration.getDuration() != 0.0) {
            bl = true;
            baseline.setWork(DatatypeConverter.printDuration(this, duration));
        }
        if (bl) {
            resource.getBaseline().add(baseline);
            baseline.setNumber(BigInteger.ZERO);
        }
        for (int i = 1; i <= 10; ++i) {
            baseline = this.m_factory.createProjectResourcesResourceBaseline();
            bl = false;
            number = resource2.getBaselineCost(i);
            if (number != null && number.intValue() != 0) {
                bl = true;
                baseline.setCost(DatatypeConverter.printCurrency(number));
            }
            if ((duration = resource2.getBaselineWork(i)) != null && duration.getDuration() != 0.0) {
                bl = true;
                baseline.setWork(DatatypeConverter.printDuration(this, duration));
            }
            if (!bl) continue;
            resource.getBaseline().add(baseline);
            baseline.setNumber(BigInteger.valueOf(i));
        }
    }

    private void writeResourceExtendedAttributes(Project.Resources.Resource resource, Resource resource2) {
        List<Project.Resources.Resource.ExtendedAttribute> list = resource.getExtendedAttribute();
        for (ResourceField resourceField : this.getAllResourceExtendedAttributes()) {
            Object object;
            if (!FieldTypeHelper.valueIsNotDefault(resourceField, object = resource2.getCachedValue(resourceField))) continue;
            this.m_extendedAttributesInUse.add(resourceField);
            Integer n = MPPResourceField.getID(resourceField) | 0xC400000;
            Project.Resources.Resource.ExtendedAttribute extendedAttribute = this.m_factory.createProjectResourcesResourceExtendedAttribute();
            list.add(extendedAttribute);
            extendedAttribute.setFieldID(n.toString());
            extendedAttribute.setValue(DatatypeConverter.printExtendedAttribute(this, object, resourceField.getDataType()));
            extendedAttribute.setDurationFormat(this.printExtendedAttributeDurationFormat(object));
        }
    }

    private void writeCostRateTables(Project.Resources.Resource resource, Resource resource2) {
        List<Project.Resources.Resource.Rates.Rate> list = null;
        for (int i = 0; i < 5; ++i) {
            CostRateTable costRateTable = resource2.getCostRateTable(i);
            if (costRateTable == null) continue;
            Date date = DateHelper.FIRST_DATE;
            for (CostRateTableEntry costRateTableEntry : costRateTable) {
                Object object;
                if (!this.costRateTableWriteRequired(costRateTableEntry, date)) continue;
                if (list == null) {
                    object = this.m_factory.createProjectResourcesResourceRates();
                    resource.setRates((Project.Resources.Resource.Rates)object);
                    list = ((Project.Resources.Resource.Rates)object).getRate();
                }
                object = this.m_factory.createProjectResourcesResourceRatesRate();
                list.add((Project.Resources.Resource.Rates.Rate)object);
                ((Project.Resources.Resource.Rates.Rate)object).setCostPerUse(DatatypeConverter.printCurrency(costRateTableEntry.getCostPerUse()));
                ((Project.Resources.Resource.Rates.Rate)object).setOvertimeRate(DatatypeConverter.printRate(costRateTableEntry.getOvertimeRate()));
                ((Project.Resources.Resource.Rates.Rate)object).setOvertimeRateFormat(DatatypeConverter.printTimeUnit(costRateTableEntry.getOvertimeRateFormat()));
                ((Project.Resources.Resource.Rates.Rate)object).setRatesFrom(DatatypeConverter.printDate(date));
                date = costRateTableEntry.getEndDate();
                ((Project.Resources.Resource.Rates.Rate)object).setRatesTo(DatatypeConverter.printDate(date));
                ((Project.Resources.Resource.Rates.Rate)object).setRateTable(BigInteger.valueOf(i));
                ((Project.Resources.Resource.Rates.Rate)object).setStandardRate(DatatypeConverter.printRate(costRateTableEntry.getStandardRate()));
                ((Project.Resources.Resource.Rates.Rate)object).setStandardRateFormat(DatatypeConverter.printTimeUnit(costRateTableEntry.getStandardRateFormat()));
            }
        }
    }

    private boolean costRateTableWriteRequired(CostRateTableEntry costRateTableEntry, Date date) {
        boolean bl = DateHelper.compare(date, DateHelper.FIRST_DATE) > 0;
        boolean bl2 = DateHelper.compare(costRateTableEntry.getEndDate(), DateHelper.LAST_DATE) > 0;
        boolean bl3 = NumberHelper.getDouble(costRateTableEntry.getCostPerUse()) != 0.0;
        boolean bl4 = costRateTableEntry.getOvertimeRate() != null && costRateTableEntry.getOvertimeRate().getAmount() != 0.0;
        boolean bl5 = costRateTableEntry.getStandardRate() != null && costRateTableEntry.getStandardRate().getAmount() != 0.0;
        return bl || bl2 || bl3 || bl4 || bl5;
    }

    private void writeAvailability(Project.Resources.Resource resource, Resource resource2) {
        Project.Resources.Resource.AvailabilityPeriods availabilityPeriods = this.m_factory.createProjectResourcesResourceAvailabilityPeriods();
        resource.setAvailabilityPeriods(availabilityPeriods);
        List<Project.Resources.Resource.AvailabilityPeriods.AvailabilityPeriod> list = availabilityPeriods.getAvailabilityPeriod();
        for (Availability availability : resource2.getAvailability()) {
            Project.Resources.Resource.AvailabilityPeriods.AvailabilityPeriod availabilityPeriod = this.m_factory.createProjectResourcesResourceAvailabilityPeriodsAvailabilityPeriod();
            list.add(availabilityPeriod);
            DateRange dateRange = availability.getRange();
            availabilityPeriod.setAvailableFrom(DatatypeConverter.printDate(dateRange.getStart()));
            availabilityPeriod.setAvailableTo(DatatypeConverter.printDate(dateRange.getEnd()));
            availabilityPeriod.setAvailableUnits(DatatypeConverter.printUnits(availability.getUnits()));
        }
    }

    private void writeTasks(Project project) {
        Project.Tasks tasks = this.m_factory.createProjectTasks();
        project.setTasks(tasks);
        List<Project.Tasks.Task> list = tasks.getTask();
        for (Task task : this.m_projectFile.getTasks()) {
            list.add(this.writeTask(task));
        }
    }

    protected Project.Tasks.Task writeTask(Task task) {
        double d;
        Duration duration;
        Project.Tasks.Task task2 = this.m_factory.createProjectTasksTask();
        task2.setActive(task.getActive());
        task2.setActualCost(DatatypeConverter.printCurrency(task.getActualCost()));
        task2.setActualDuration(DatatypeConverter.printDuration(this, task.getActualDuration()));
        task2.setActualFinish(DatatypeConverter.printDate(task.getActualFinish()));
        task2.setActualOvertimeCost(DatatypeConverter.printCurrency(task.getActualOvertimeCost()));
        task2.setActualOvertimeWork(DatatypeConverter.printDuration(this, task.getActualOvertimeWork()));
        task2.setActualOvertimeWorkProtected(DatatypeConverter.printDuration(this, task.getActualOvertimeWorkProtected()));
        task2.setActualStart(DatatypeConverter.printDate(task.getActualStart()));
        task2.setActualWork(DatatypeConverter.printDuration(this, task.getActualWork()));
        task2.setActualWorkProtected(DatatypeConverter.printDuration(this, task.getActualWorkProtected()));
        task2.setACWP(DatatypeConverter.printCurrency(task.getACWP()));
        task2.setBCWP(DatatypeConverter.printCurrency(task.getBCWP()));
        task2.setBCWS(DatatypeConverter.printCurrency(task.getBCWS()));
        task2.setCalendarUID(this.getTaskCalendarID(task));
        task2.setConstraintDate(DatatypeConverter.printDate(task.getConstraintDate()));
        task2.setConstraintType(DatatypeConverter.printConstraintType(task.getConstraintType()));
        task2.setContact(task.getContact());
        task2.setCost(DatatypeConverter.printCurrency(task.getCost()));
        task2.setCreateDate(DatatypeConverter.printDate(task.getCreateDate()));
        task2.setCritical(task.getCritical());
        task2.setCV(DatatypeConverter.printCurrency(task.getCV()));
        task2.setDeadline(DatatypeConverter.printDate(task.getDeadline()));
        task2.setDuration(DatatypeConverter.printDurationMandatory(this, task.getDuration()));
        task2.setDurationText(task.getDurationText());
        task2.setDurationFormat(DatatypeConverter.printDurationTimeUnits(task.getDuration(), task.getEstimated()));
        task2.setEarlyFinish(DatatypeConverter.printDate(task.getEarlyFinish()));
        task2.setEarlyStart(DatatypeConverter.printDate(task.getEarlyStart()));
        task2.setEarnedValueMethod(DatatypeConverter.printEarnedValueMethod(task.getEarnedValueMethod()));
        task2.setEffortDriven(task.getEffortDriven());
        task2.setEstimated(task.getEstimated());
        task2.setExternalTask(task.getExternalTask());
        task2.setExternalTaskProject(task.getProject());
        task2.setFinish(DatatypeConverter.printDate(task.getFinish()));
        task2.setFinishSlack(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(task.getFinishSlack()));
        task2.setFinishText(task.getFinishText());
        task2.setFinishVariance(DatatypeConverter.printDurationInIntegerThousandthsOfMinutes(task.getFinishVariance()));
        task2.setFixedCost(DatatypeConverter.printCurrency(task.getFixedCost()));
        AccrueType accrueType = task.getFixedCostAccrual();
        if (accrueType == null) {
            accrueType = AccrueType.PRORATED;
        }
        task2.setFixedCostAccrual(accrueType);
        task2.setFreeSlack(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(task.getFreeSlack()));
        task2.setHideBar(task.getHideBar());
        task2.setIsNull(task.getNull());
        task2.setIsSubproject(task.getSubProject() != null);
        task2.setIsSubprojectReadOnly(task.getSubprojectReadOnly());
        task2.setHyperlink(task.getHyperlink());
        task2.setHyperlinkAddress(task.getHyperlinkAddress());
        task2.setHyperlinkSubAddress(task.getHyperlinkSubAddress());
        task2.setID(NumberHelper.getBigInteger(task.getID()));
        task2.setIgnoreResourceCalendar(task.getIgnoreResourceCalendar());
        task2.setLateFinish(DatatypeConverter.printDate(task.getLateFinish()));
        task2.setLateStart(DatatypeConverter.printDate(task.getLateStart()));
        task2.setLevelAssignments(task.getLevelAssignments());
        task2.setLevelingCanSplit(task.getLevelingCanSplit());
        if (task.getLevelingDelay() != null) {
            duration = task.getLevelingDelay();
            d = 10.0 * Duration.convertUnits(duration.getDuration(), duration.getUnits(), TimeUnit.MINUTES, this.m_projectFile.getProjectProperties()).getDuration();
            task2.setLevelingDelay(BigInteger.valueOf((long)d));
            task2.setLevelingDelayFormat(DatatypeConverter.printDurationTimeUnits(duration, false));
        }
        task2.setManual(task.getTaskMode() == TaskMode.MANUALLY_SCHEDULED);
        if (task.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) {
            task2.setManualDuration(DatatypeConverter.printDuration(this, task.getDuration()));
            task2.setManualFinish(DatatypeConverter.printDate(task.getFinish()));
            task2.setManualStart(DatatypeConverter.printDate(task.getStart()));
        }
        task2.setMilestone(task.getMilestone());
        task2.setName(task.getName());
        if (!task.getNotes().isEmpty()) {
            task2.setNotes(task.getNotes());
        }
        task2.setOutlineLevel(NumberHelper.getBigInteger(task.getOutlineLevel()));
        task2.setOutlineNumber(task.getOutlineNumber());
        task2.setOverAllocated(task.getOverAllocated());
        task2.setOvertimeCost(DatatypeConverter.printCurrency(task.getOvertimeCost()));
        task2.setOvertimeWork(DatatypeConverter.printDuration(this, task.getOvertimeWork()));
        task2.setPercentComplete(NumberHelper.getBigInteger(task.getPercentageComplete()));
        task2.setPercentWorkComplete(NumberHelper.getBigInteger(task.getPercentageWorkComplete()));
        task2.setPhysicalPercentComplete(NumberHelper.getBigInteger(task.getPhysicalPercentComplete()));
        task2.setPriority(DatatypeConverter.printPriority(task.getPriority()));
        task2.setRecurring(task.getRecurring());
        task2.setRegularWork(DatatypeConverter.printDuration(this, task.getRegularWork()));
        task2.setRemainingCost(DatatypeConverter.printCurrency(task.getRemainingCost()));
        if (task.getRemainingDuration() == null) {
            duration = task.getDuration();
            if (duration != null) {
                d = duration.getDuration();
                d -= d * NumberHelper.getDouble(task.getPercentageComplete()) / 100.0;
                task2.setRemainingDuration(DatatypeConverter.printDuration(this, Duration.getInstance(d, duration.getUnits())));
            }
        } else {
            task2.setRemainingDuration(DatatypeConverter.printDuration(this, task.getRemainingDuration()));
        }
        task2.setRemainingOvertimeCost(DatatypeConverter.printCurrency(task.getRemainingOvertimeCost()));
        task2.setRemainingOvertimeWork(DatatypeConverter.printDuration(this, task.getRemainingOvertimeWork()));
        task2.setRemainingWork(DatatypeConverter.printDuration(this, task.getRemainingWork()));
        task2.setResume(DatatypeConverter.printDate(task.getResume()));
        task2.setResumeValid(task.getResumeValid());
        task2.setRollup(task.getRollup());
        task2.setStart(DatatypeConverter.printDate(task.getStart()));
        task2.setStartSlack(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(task.getStartSlack()));
        task2.setStartText(task.getStartText());
        task2.setStartVariance(DatatypeConverter.printDurationInIntegerThousandthsOfMinutes(task.getStartVariance()));
        task2.setStop(DatatypeConverter.printDate(task.getStop()));
        task2.setSubprojectName(task.getSubprojectName());
        task2.setSummary(task.getSummary());
        task2.setTotalSlack(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(task.getTotalSlack()));
        task2.setType(task.getType());
        task2.setUID(task.getUniqueID());
        task2.setWBS(task.getWBS());
        task2.setWBSLevel(task.getWBSLevel());
        task2.setWork(DatatypeConverter.printDuration(this, task.getWork()));
        task2.setWorkVariance(DatatypeConverter.printDurationInDecimalThousandthsOfMinutes(task.getWorkVariance()));
        if (task.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) {
            task2.setManualDuration(DatatypeConverter.printDuration(this, task.getManualDuration()));
        }
        this.writePredecessors(task2, task);
        this.writeTaskExtendedAttributes(task2, task);
        this.writeTaskBaselines(task2, task);
        return task2;
    }

    private void writeTaskBaselines(Project.Tasks.Task task, Task task2) {
        Date date;
        Duration duration;
        Project.Tasks.Task.Baseline baseline = this.m_factory.createProjectTasksTaskBaseline();
        boolean bl = false;
        Number number = task2.getBaselineCost();
        if (number != null && number.intValue() != 0) {
            bl = true;
            baseline.setCost(DatatypeConverter.printCurrency(number));
        }
        if ((duration = task2.getBaselineDuration()) != null && duration.getDuration() != 0.0) {
            bl = true;
            baseline.setDuration(DatatypeConverter.printDuration(this, duration));
            baseline.setDurationFormat(DatatypeConverter.printDurationTimeUnits(duration, false));
        }
        if ((date = task2.getBaselineFinish()) != null) {
            bl = true;
            baseline.setFinish(DatatypeConverter.printDate(date));
        }
        if ((date = task2.getBaselineStart()) != null) {
            bl = true;
            baseline.setStart(DatatypeConverter.printDate(date));
        }
        if ((duration = task2.getBaselineWork()) != null && duration.getDuration() != 0.0) {
            bl = true;
            baseline.setWork(DatatypeConverter.printDuration(this, duration));
        }
        if (bl) {
            baseline.setNumber(BigInteger.ZERO);
            task.getBaseline().add(baseline);
        }
        for (int i = 1; i <= 10; ++i) {
            baseline = this.m_factory.createProjectTasksTaskBaseline();
            bl = false;
            number = task2.getBaselineCost(i);
            if (number != null && number.intValue() != 0) {
                bl = true;
                baseline.setCost(DatatypeConverter.printCurrency(number));
            }
            if ((duration = task2.getBaselineDuration(i)) != null && duration.getDuration() != 0.0) {
                bl = true;
                baseline.setDuration(DatatypeConverter.printDuration(this, duration));
                baseline.setDurationFormat(DatatypeConverter.printDurationTimeUnits(duration, false));
            }
            if ((date = task2.getBaselineFinish(i)) != null) {
                bl = true;
                baseline.setFinish(DatatypeConverter.printDate(date));
            }
            if ((date = task2.getBaselineStart(i)) != null) {
                bl = true;
                baseline.setStart(DatatypeConverter.printDate(date));
            }
            if ((duration = task2.getBaselineWork(i)) != null && duration.getDuration() != 0.0) {
                bl = true;
                baseline.setWork(DatatypeConverter.printDuration(this, duration));
            }
            if (!bl) continue;
            baseline.setNumber(BigInteger.valueOf(i));
            task.getBaseline().add(baseline);
        }
    }

    private void writeTaskExtendedAttributes(Project.Tasks.Task task, Task task2) {
        List<Project.Tasks.Task.ExtendedAttribute> list = task.getExtendedAttribute();
        for (TaskField taskField : this.getAllTaskExtendedAttributes()) {
            Object object;
            if (!FieldTypeHelper.valueIsNotDefault(taskField, object = task2.getCachedValue(taskField))) continue;
            this.m_extendedAttributesInUse.add(taskField);
            Integer n = MPPTaskField.getID(taskField) | 0xB400000;
            Project.Tasks.Task.ExtendedAttribute extendedAttribute = this.m_factory.createProjectTasksTaskExtendedAttribute();
            list.add(extendedAttribute);
            extendedAttribute.setFieldID(n.toString());
            extendedAttribute.setValue(DatatypeConverter.printExtendedAttribute(this, object, taskField.getDataType()));
            extendedAttribute.setDurationFormat(this.printExtendedAttributeDurationFormat(object));
        }
    }

    private BigInteger printExtendedAttributeDurationFormat(Object object) {
        BigInteger bigInteger = null;
        if (object instanceof Duration) {
            bigInteger = DatatypeConverter.printDurationTimeUnits(((Duration)object).getUnits(), false);
        }
        return bigInteger;
    }

    private BigInteger getTaskCalendarID(Task task) {
        BigInteger bigInteger = null;
        ProjectCalendar projectCalendar = task.getCalendar();
        bigInteger = projectCalendar != null ? NumberHelper.getBigInteger(projectCalendar.getUniqueID()) : BigInteger.valueOf(-1L);
        return bigInteger;
    }

    private void writePredecessors(Project.Tasks.Task task, Task task2) {
        List<Project.Tasks.Task.PredecessorLink> list = task.getPredecessorLink();
        List<Relation> list2 = task2.getPredecessors();
        for (Relation relation : list2) {
            Integer n = relation.getTargetTask().getUniqueID();
            list.add(this.writePredecessor(n, relation.getType(), relation.getLag()));
            this.m_eventManager.fireRelationWrittenEvent(relation);
        }
    }

    private Project.Tasks.Task.PredecessorLink writePredecessor(Integer n, RelationType relationType, Duration duration) {
        Project.Tasks.Task.PredecessorLink predecessorLink = this.m_factory.createProjectTasksTaskPredecessorLink();
        predecessorLink.setPredecessorUID(NumberHelper.getBigInteger(n));
        predecessorLink.setType(BigInteger.valueOf(relationType.getValue()));
        predecessorLink.setCrossProject(Boolean.FALSE);
        if (duration != null && duration.getDuration() != 0.0) {
            double d = duration.getDuration();
            if (duration.getUnits() != TimeUnit.PERCENT && duration.getUnits() != TimeUnit.ELAPSED_PERCENT) {
                d = 10.0 * Duration.convertUnits(d, duration.getUnits(), TimeUnit.MINUTES, this.m_projectFile.getProjectProperties()).getDuration();
            }
            predecessorLink.setLinkLag(BigInteger.valueOf((long)d));
            predecessorLink.setLagFormat(DatatypeConverter.printDurationTimeUnits(duration.getUnits(), false));
        }
        return predecessorLink;
    }

    private void writeAssignments(Project project) {
        Project.Assignments assignments = this.m_factory.createProjectAssignments();
        project.setAssignments(assignments);
        List<Project.Assignments.Assignment> list = assignments.getAssignment();
        for (ResourceAssignment resourceAssignment : this.m_projectFile.getResourceAssignments()) {
            list.add(this.writeAssignment(resourceAssignment));
        }
        ProjectConfig projectConfig = this.m_projectFile.getProjectConfig();
        boolean bl = projectConfig.getAutoAssignmentUniqueID();
        if (!bl) {
            projectConfig.setAutoAssignmentUniqueID(true);
        }
        for (Task task : this.m_projectFile.getTasks()) {
            double d = NumberHelper.getDouble(task.getPercentageComplete());
            if (d == 0.0 || !task.getResourceAssignments().isEmpty()) continue;
            ResourceAssignment resourceAssignment = new ResourceAssignment(this.m_projectFile, task);
            Duration duration = task.getDuration();
            if (duration == null) {
                duration = Duration.getInstance(0, TimeUnit.HOURS);
            }
            double d2 = duration.getDuration();
            TimeUnit timeUnit = duration.getUnits();
            double d3 = d2 * d / 100.0;
            double d4 = d2 - d3;
            resourceAssignment.setResourceUniqueID(NULL_RESOURCE_ID);
            resourceAssignment.setWork(duration);
            resourceAssignment.setActualWork(Duration.getInstance(d3, timeUnit));
            resourceAssignment.setRemainingWork(Duration.getInstance(d4, timeUnit));
            list.add(this.writeAssignment(resourceAssignment));
        }
        projectConfig.setAutoAssignmentUniqueID(bl);
    }

    protected Project.Assignments.Assignment writeAssignment(ResourceAssignment resourceAssignment) {
        Project.Assignments.Assignment assignment = this.m_factory.createProjectAssignmentsAssignment();
        assignment.setActualCost(DatatypeConverter.printCurrency(resourceAssignment.getActualCost()));
        assignment.setActualFinish(DatatypeConverter.printDate(resourceAssignment.getActualFinish()));
        assignment.setActualOvertimeCost(DatatypeConverter.printCurrency(resourceAssignment.getActualOvertimeCost()));
        assignment.setActualOvertimeWork(DatatypeConverter.printDuration(this, resourceAssignment.getActualOvertimeWork()));
        assignment.setActualStart(DatatypeConverter.printDate(resourceAssignment.getActualStart()));
        assignment.setActualWork(DatatypeConverter.printDuration(this, resourceAssignment.getActualWork()));
        assignment.setACWP(DatatypeConverter.printCurrency(resourceAssignment.getACWP()));
        assignment.setBCWP(DatatypeConverter.printCurrency(resourceAssignment.getBCWP()));
        assignment.setBCWS(DatatypeConverter.printCurrency(resourceAssignment.getBCWS()));
        assignment.setBudgetCost(DatatypeConverter.printCurrency(resourceAssignment.getBudgetCost()));
        assignment.setBudgetWork(DatatypeConverter.printDuration(this, resourceAssignment.getBudgetWork()));
        assignment.setCost(DatatypeConverter.printCurrency(resourceAssignment.getCost()));
        if (resourceAssignment.getCostRateTableIndex() != 0) {
            assignment.setCostRateTable(BigInteger.valueOf(resourceAssignment.getCostRateTableIndex()));
        }
        assignment.setCreationDate(DatatypeConverter.printDate(resourceAssignment.getCreateDate()));
        assignment.setCV(DatatypeConverter.printCurrency(resourceAssignment.getCV()));
        assignment.setDelay(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(resourceAssignment.getDelay()));
        assignment.setFinish(DatatypeConverter.printDate(resourceAssignment.getFinish()));
        assignment.setHasFixedRateUnits(resourceAssignment.getVariableRateUnits() == null);
        assignment.setFixedMaterial(resourceAssignment.getResource() != null && resourceAssignment.getResource().getType() == ResourceType.MATERIAL);
        assignment.setHyperlink(resourceAssignment.getHyperlink());
        assignment.setHyperlinkAddress(resourceAssignment.getHyperlinkAddress());
        assignment.setHyperlinkSubAddress(resourceAssignment.getHyperlinkSubAddress());
        assignment.setLevelingDelay(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(resourceAssignment.getLevelingDelay()));
        assignment.setLevelingDelayFormat(DatatypeConverter.printDurationTimeUnits(resourceAssignment.getLevelingDelay(), false));
        if (!resourceAssignment.getNotes().isEmpty()) {
            assignment.setNotes(resourceAssignment.getNotes());
        }
        assignment.setOvertimeCost(DatatypeConverter.printCurrency(resourceAssignment.getOvertimeCost()));
        assignment.setOvertimeWork(DatatypeConverter.printDuration(this, resourceAssignment.getOvertimeWork()));
        assignment.setPercentWorkComplete(NumberHelper.getBigInteger(resourceAssignment.getPercentageWorkComplete()));
        assignment.setRateScale(resourceAssignment.getVariableRateUnits() == null ? null : DatatypeConverter.printTimeUnit(resourceAssignment.getVariableRateUnits()));
        assignment.setRegularWork(DatatypeConverter.printDuration(this, resourceAssignment.getRegularWork()));
        assignment.setRemainingCost(DatatypeConverter.printCurrency(resourceAssignment.getRemainingCost()));
        assignment.setRemainingOvertimeCost(DatatypeConverter.printCurrency(resourceAssignment.getRemainingOvertimeCost()));
        assignment.setRemainingOvertimeWork(DatatypeConverter.printDuration(this, resourceAssignment.getRemainingOvertimeWork()));
        assignment.setRemainingWork(DatatypeConverter.printDuration(this, resourceAssignment.getRemainingWork()));
        assignment.setResourceUID(resourceAssignment.getResource() == null ? BigInteger.valueOf(NULL_RESOURCE_ID.intValue()) : BigInteger.valueOf(NumberHelper.getInt(resourceAssignment.getResourceUniqueID())));
        assignment.setResume(DatatypeConverter.printDate(resourceAssignment.getResume()));
        assignment.setStart(DatatypeConverter.printDate(resourceAssignment.getStart()));
        assignment.setStop(DatatypeConverter.printDate(resourceAssignment.getStop()));
        assignment.setSV(DatatypeConverter.printCurrency(resourceAssignment.getSV()));
        assignment.setTaskUID(NumberHelper.getBigInteger(resourceAssignment.getTask().getUniqueID()));
        assignment.setUID(NumberHelper.getBigInteger(resourceAssignment.getUniqueID()));
        assignment.setUnits(DatatypeConverter.printUnits(resourceAssignment.getUnits()));
        assignment.setVAC(DatatypeConverter.printCurrency(resourceAssignment.getVAC()));
        assignment.setWork(DatatypeConverter.printDuration(this, resourceAssignment.getWork()));
        assignment.setWorkContour(resourceAssignment.getWorkContour());
        assignment.setCostVariance(DatatypeConverter.printCurrency(resourceAssignment.getCostVariance()));
        assignment.setWorkVariance(DatatypeConverter.printDurationInDecimalThousandthsOfMinutes(resourceAssignment.getWorkVariance()));
        assignment.setStartVariance(DatatypeConverter.printDurationInIntegerThousandthsOfMinutes(resourceAssignment.getStartVariance()));
        assignment.setFinishVariance(DatatypeConverter.printDurationInIntegerThousandthsOfMinutes(resourceAssignment.getFinishVariance()));
        this.writeAssignmentBaselines(assignment, resourceAssignment);
        this.writeAssignmentExtendedAttributes(assignment, resourceAssignment);
        this.writeAssignmentTimephasedData(resourceAssignment, assignment);
        this.m_eventManager.fireAssignmentWrittenEvent(resourceAssignment);
        return assignment;
    }

    private void writeAssignmentBaselines(Project.Assignments.Assignment assignment, ResourceAssignment resourceAssignment) {
        Duration duration;
        Date date;
        Project.Assignments.Assignment.Baseline baseline = this.m_factory.createProjectAssignmentsAssignmentBaseline();
        boolean bl = false;
        Number number = resourceAssignment.getBaselineCost();
        if (number != null && number.intValue() != 0) {
            bl = true;
            baseline.setCost(DatatypeConverter.printExtendedAttributeCurrency(number));
        }
        if ((date = resourceAssignment.getBaselineFinish()) != null) {
            bl = true;
            baseline.setFinish(DatatypeConverter.printExtendedAttributeDate(date));
        }
        if ((date = resourceAssignment.getBaselineStart()) != null) {
            bl = true;
            baseline.setStart(DatatypeConverter.printExtendedAttributeDate(date));
        }
        if ((duration = resourceAssignment.getBaselineWork()) != null && duration.getDuration() != 0.0) {
            bl = true;
            baseline.setWork(DatatypeConverter.printDuration(this, duration));
        }
        if (bl) {
            baseline.setNumber("0");
            assignment.getBaseline().add(baseline);
        }
        for (int i = 1; i <= 10; ++i) {
            baseline = this.m_factory.createProjectAssignmentsAssignmentBaseline();
            bl = false;
            number = resourceAssignment.getBaselineCost(i);
            if (number != null && number.intValue() != 0) {
                bl = true;
                baseline.setCost(DatatypeConverter.printExtendedAttributeCurrency(number));
            }
            if ((date = resourceAssignment.getBaselineFinish(i)) != null) {
                bl = true;
                baseline.setFinish(DatatypeConverter.printExtendedAttributeDate(date));
            }
            if ((date = resourceAssignment.getBaselineStart(i)) != null) {
                bl = true;
                baseline.setStart(DatatypeConverter.printExtendedAttributeDate(date));
            }
            if ((duration = resourceAssignment.getBaselineWork(i)) != null && duration.getDuration() != 0.0) {
                bl = true;
                baseline.setWork(DatatypeConverter.printDuration(this, duration));
            }
            if (!bl) continue;
            baseline.setNumber(Integer.toString(i));
            assignment.getBaseline().add(baseline);
        }
    }

    private void writeAssignmentExtendedAttributes(Project.Assignments.Assignment assignment, ResourceAssignment resourceAssignment) {
        List<Project.Assignments.Assignment.ExtendedAttribute> list = assignment.getExtendedAttribute();
        for (AssignmentField assignmentField : this.getAllAssignmentExtendedAttributes()) {
            Object object;
            if (!FieldTypeHelper.valueIsNotDefault(assignmentField, object = resourceAssignment.getCachedValue(assignmentField))) continue;
            this.m_extendedAttributesInUse.add(assignmentField);
            Integer n = MPPAssignmentField.getID(assignmentField) | 0xF400000;
            Project.Assignments.Assignment.ExtendedAttribute extendedAttribute = this.m_factory.createProjectAssignmentsAssignmentExtendedAttribute();
            list.add(extendedAttribute);
            extendedAttribute.setFieldID(n.toString());
            extendedAttribute.setValue(DatatypeConverter.printExtendedAttribute(this, object, assignmentField.getDataType()));
            extendedAttribute.setDurationFormat(this.printExtendedAttributeDurationFormat(object));
        }
    }

    private void writeAssignmentTimephasedData(ResourceAssignment resourceAssignment, Project.Assignments.Assignment assignment) {
        if (this.m_writeTimphasedData && resourceAssignment.getHasTimephasedData()) {
            List<TimephasedDataType> list = assignment.getTimephasedData();
            ProjectCalendar projectCalendar = resourceAssignment.getCalendar();
            BigInteger bigInteger = assignment.getUID();
            List<TimephasedWork> list2 = resourceAssignment.getTimephasedActualWork();
            List<TimephasedWork> list3 = resourceAssignment.getTimephasedWork();
            if (this.m_splitTimephasedAsDays) {
                TimephasedWork timephasedWork = null;
                if (list2 != null && !list2.isEmpty()) {
                    timephasedWork = list2.get(list2.size() - 1);
                }
                TimephasedWork timephasedWork2 = null;
                if (list3 != null && !list3.isEmpty()) {
                    timephasedWork2 = list3.get(0);
                }
                if (list3 != null) {
                    list3 = this.splitDays(projectCalendar, resourceAssignment.getTimephasedWork(), null, timephasedWork);
                }
                if (list2 != null) {
                    list2 = this.splitDays(projectCalendar, list2, timephasedWork2, null);
                }
            }
            if (list3 != null) {
                this.writeAssignmentTimephasedData(bigInteger, list, list3, 1);
            }
            if (list2 != null) {
                this.writeAssignmentTimephasedData(bigInteger, list, list2, 2);
            }
        }
    }

    private List<TimephasedWork> splitDays(ProjectCalendar projectCalendar, List<TimephasedWork> list, TimephasedWork timephasedWork, TimephasedWork timephasedWork2) {
        LinkedList<TimephasedWork> linkedList = new LinkedList<TimephasedWork>();
        for (TimephasedWork timephasedWork3 : list) {
            Object object;
            Object object2;
            Comparable<Calendar> comparable;
            Date date;
            Date date2 = timephasedWork3.getStart();
            Date date3 = timephasedWork3.getFinish();
            Date date4 = DateHelper.getDayStartDate(date2);
            Date date5 = DateHelper.getDayStartDate(date3);
            if (date4.getTime() == date5.getTime()) {
                Object object3;
                date = projectCalendar.getStartTime(date4);
                comparable = DateHelper.setTime(date4, date);
                if (date2.getTime() > ((Date)comparable).getTime()) {
                    Object object4;
                    boolean bl = true;
                    if (timephasedWork2 != null) {
                        object2 = timephasedWork2.getFinish();
                        if (((Date)object2).getTime() == date2.getTime()) {
                            bl = false;
                        } else {
                            object4 = DateHelper.getDayStartDate((Date)object2);
                            if (date4.getTime() == ((Date)object4).getTime()) {
                                comparable = object2;
                            }
                        }
                    }
                    if (bl) {
                        object2 = Duration.getInstance(0, TimeUnit.HOURS);
                        object4 = new TimephasedWork();
                        ((TimephasedItem)object4).setStart((Date)comparable);
                        ((TimephasedItem)object4).setFinish(date2);
                        ((TimephasedItem)object4).setTotalAmount(object2);
                        ((TimephasedItem)object4).setAmountPerDay(object2);
                        linkedList.add((TimephasedWork)object4);
                    }
                }
                linkedList.add(timephasedWork3);
                Date date6 = projectCalendar.getFinishTime(date4);
                object2 = DateHelper.setTime(date4, date6);
                if (date3.getTime() >= ((Date)object2).getTime()) continue;
                boolean bl = true;
                if (timephasedWork != null) {
                    object = timephasedWork.getStart();
                    if (((Date)object).getTime() == date3.getTime()) {
                        bl = false;
                    } else {
                        object3 = DateHelper.getDayStartDate((Date)object);
                        if (date5.getTime() == ((Date)object3).getTime()) {
                            object2 = object;
                        }
                    }
                }
                if (!bl) continue;
                object = Duration.getInstance(0, TimeUnit.HOURS);
                object3 = new TimephasedWork();
                ((TimephasedItem)object3).setStart(date3);
                ((TimephasedItem)object3).setFinish((Date)object2);
                ((TimephasedItem)object3).setTotalAmount(object);
                ((TimephasedItem)object3).setAmountPerDay(object);
                linkedList.add((TimephasedWork)object3);
                continue;
            }
            date = date2;
            comparable = Calendar.getInstance();
            boolean bl = projectCalendar.isWorkingDate(date);
            while (date.getTime() < date3.getTime()) {
                if (bl) {
                    object2 = projectCalendar.getFinishTime(date);
                    Date date7 = DateHelper.setTime(date, (Date)object2);
                    if (date7.getTime() > date3.getTime()) {
                        date7 = date3;
                    }
                    object = new TimephasedWork();
                    ((TimephasedItem)object).setStart(date);
                    ((TimephasedItem)object).setFinish(date7);
                    ((TimephasedItem)object).setTotalAmount(timephasedWork3.getAmountPerDay());
                    ((TimephasedItem)object).setAmountPerDay(timephasedWork3.getAmountPerDay());
                    linkedList.add((TimephasedWork)object);
                }
                ((Calendar)comparable).setTime(date);
                ((Calendar)comparable).add(6, 1);
                date = ((Calendar)comparable).getTime();
                bl = projectCalendar.isWorkingDate(date);
                if (!bl) continue;
                object2 = projectCalendar.getStartTime(date);
                DateHelper.setTime(comparable, object2);
                date = ((Calendar)comparable).getTime();
            }
        }
        return linkedList;
    }

    private void writeAssignmentTimephasedData(BigInteger bigInteger, List<TimephasedDataType> list, List<TimephasedWork> list2, int n) {
        for (TimephasedWork timephasedWork : list2) {
            TimephasedDataType timephasedDataType = this.m_factory.createTimephasedDataType();
            list.add(timephasedDataType);
            timephasedDataType.setStart(DatatypeConverter.printDate(timephasedWork.getStart()));
            timephasedDataType.setFinish(DatatypeConverter.printDate(timephasedWork.getFinish()));
            timephasedDataType.setType(BigInteger.valueOf(n));
            timephasedDataType.setUID(bigInteger);
            timephasedDataType.setUnit(DatatypeConverter.printDurationTimeUnits((Duration)timephasedWork.getTotalAmount(), false));
            timephasedDataType.setValue(DatatypeConverter.printDuration(this, (Duration)timephasedWork.getTotalAmount()));
        }
    }

    private List<AssignmentField> getAllAssignmentExtendedAttributes() {
        ArrayList<AssignmentField> arrayList = new ArrayList<AssignmentField>();
        arrayList.addAll(Arrays.asList(AssignmentFieldLists.CUSTOM_COST));
        arrayList.addAll(Arrays.asList(AssignmentFieldLists.CUSTOM_DATE));
        arrayList.addAll(Arrays.asList(AssignmentFieldLists.CUSTOM_DURATION));
        arrayList.addAll(Arrays.asList(AssignmentFieldLists.ENTERPRISE_COST));
        arrayList.addAll(Arrays.asList(AssignmentFieldLists.ENTERPRISE_DATE));
        arrayList.addAll(Arrays.asList(AssignmentFieldLists.ENTERPRISE_DURATION));
        arrayList.addAll(Arrays.asList(AssignmentFieldLists.ENTERPRISE_FLAG));
        arrayList.addAll(Arrays.asList(AssignmentFieldLists.ENTERPRISE_NUMBER));
        arrayList.addAll(Arrays.asList(AssignmentFieldLists.ENTERPRISE_RESOURCE_MULTI_VALUE));
        arrayList.addAll(Arrays.asList(AssignmentFieldLists.ENTERPRISE_RESOURCE_OUTLINE_CODE));
        arrayList.addAll(Arrays.asList(AssignmentFieldLists.ENTERPRISE_TEXT));
        arrayList.addAll(Arrays.asList(AssignmentFieldLists.CUSTOM_FINISH));
        arrayList.addAll(Arrays.asList(AssignmentFieldLists.CUSTOM_FLAG));
        arrayList.addAll(Arrays.asList(AssignmentFieldLists.CUSTOM_NUMBER));
        arrayList.addAll(Arrays.asList(AssignmentFieldLists.CUSTOM_START));
        arrayList.addAll(Arrays.asList(AssignmentFieldLists.CUSTOM_TEXT));
        return arrayList;
    }

    private List<TaskField> getAllTaskExtendedAttributes() {
        ArrayList<TaskField> arrayList = new ArrayList<TaskField>();
        arrayList.addAll(Arrays.asList(TaskFieldLists.CUSTOM_TEXT));
        arrayList.addAll(Arrays.asList(TaskFieldLists.CUSTOM_START));
        arrayList.addAll(Arrays.asList(TaskFieldLists.CUSTOM_FINISH));
        arrayList.addAll(Arrays.asList(TaskFieldLists.CUSTOM_COST));
        arrayList.addAll(Arrays.asList(TaskFieldLists.CUSTOM_DATE));
        arrayList.addAll(Arrays.asList(TaskFieldLists.CUSTOM_FLAG));
        arrayList.addAll(Arrays.asList(TaskFieldLists.CUSTOM_NUMBER));
        arrayList.addAll(Arrays.asList(TaskFieldLists.CUSTOM_DURATION));
        arrayList.addAll(Arrays.asList(TaskFieldLists.CUSTOM_OUTLINE_CODE));
        arrayList.addAll(Arrays.asList(TaskFieldLists.ENTERPRISE_COST));
        arrayList.addAll(Arrays.asList(TaskFieldLists.ENTERPRISE_DATE));
        arrayList.addAll(Arrays.asList(TaskFieldLists.ENTERPRISE_DURATION));
        arrayList.addAll(Arrays.asList(TaskFieldLists.ENTERPRISE_FLAG));
        arrayList.addAll(Arrays.asList(TaskFieldLists.ENTERPRISE_NUMBER));
        arrayList.addAll(Arrays.asList(TaskFieldLists.ENTERPRISE_TEXT));
        return arrayList;
    }

    private List<ResourceField> getAllResourceExtendedAttributes() {
        ArrayList<ResourceField> arrayList = new ArrayList<ResourceField>();
        arrayList.addAll(Arrays.asList(ResourceFieldLists.CUSTOM_TEXT));
        arrayList.addAll(Arrays.asList(ResourceFieldLists.CUSTOM_START));
        arrayList.addAll(Arrays.asList(ResourceFieldLists.CUSTOM_FINISH));
        arrayList.addAll(Arrays.asList(ResourceFieldLists.CUSTOM_COST));
        arrayList.addAll(Arrays.asList(ResourceFieldLists.CUSTOM_DATE));
        arrayList.addAll(Arrays.asList(ResourceFieldLists.CUSTOM_FLAG));
        arrayList.addAll(Arrays.asList(ResourceFieldLists.CUSTOM_NUMBER));
        arrayList.addAll(Arrays.asList(ResourceFieldLists.CUSTOM_DURATION));
        arrayList.addAll(Arrays.asList(ResourceFieldLists.CUSTOM_OUTLINE_CODE));
        arrayList.addAll(Arrays.asList(ResourceFieldLists.ENTERPRISE_COST));
        arrayList.addAll(Arrays.asList(ResourceFieldLists.ENTERPRISE_DATE));
        arrayList.addAll(Arrays.asList(ResourceFieldLists.ENTERPRISE_DURATION));
        arrayList.addAll(Arrays.asList(ResourceFieldLists.ENTERPRISE_FLAG));
        arrayList.addAll(Arrays.asList(ResourceFieldLists.ENTERPRISE_NUMBER));
        arrayList.addAll(Arrays.asList(ResourceFieldLists.ENTERPRISE_TEXT));
        return arrayList;
    }

    ProjectFile getProjectFile() {
        return this.m_projectFile;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance("net.sf.mpxj.mspdi.schema", MSPDIWriter.class.getClassLoader());
        }
        catch (JAXBException jAXBException) {
            CONTEXT_EXCEPTION = jAXBException;
            CONTEXT = null;
        }
        DAY_MASKS = new int[]{0, 1, 2, 4, 8, 16, 32, 64};
        BIGINTEGER_ZERO = BigInteger.valueOf(0L);
        NULL_RESOURCE_ID = -65535;
    }
}

