
# Command name: /crazy3
# Description:  Characters are displayed in different styles
#               (upper, lower, bold, underlined, reverse and some
#               characters will be exchanged through numbers).
#
# Date:         2000-08-19
# Author:       Andreas Gelhausen, atte@netsplit.de
#
# Changes:      2000-08-19  Changes for tkirc's first release of version 2.
#                  [..]
#
# Install:
#               1. copy this file to `~/.tkirc2/autoload/crazy3.tcl'
#               2. reload your tkircrc or restart tkirc


proc on_command_crazy3 {window arguments} {
  set len [lLength "$arguments"]
  if {$len < 1} {
    print2crap "+++ Usage: /crazy3 \[( /msg | /notice | /describe ) <nick> | /me \] <message>"
    return
  }
  set command "" ; set newline ""
  if {[regexp -- {^(/msg|/notice|/describe) .*} "$arguments"]} {
    set command "[leftwords "$arguments" 2] "
    set arguments "[cutwords "$arguments" 2]"
  } elseif {[regexp -- {^(/me) .*} "$arguments"]} {
    set command "[leftwords "$arguments" 1] "
    set arguments "[cutwords "$arguments" 1]"
  }
  set next 0
  set vorher  "oIlEAST"
  set nachher "0113457"
  for {set i 0} {$i < [string length "$arguments"]} {incr i} {
    set char "[string index "$arguments" $i]"
    if {"$char" >= "A" && "$char" <= "z"} {
      if {$next == 0} {
	set char "[string tolower "$char"]"
      } else {
	set char "[string toupper "$char"]"
      }
      if {[expr round(rand())] == 0} {
	append newline "\x02"
      }
      if {[expr round(rand())] == 0} {
	append newline "\x1f"
      }
      if {[expr round(rand())] == 0} {
	append newline "\x16"
      }

      set j [string first "$char" "$vorher"]
      if {$j != -1} {
        set char [string index "$nachher" $j]
      }

      if {$next == 0} {
	append newline "[string tolower "$char"]"
      } else {
	append newline "[string toupper "$char"]"
      }
      set next [expr ($next-1)*(-1)]

    } else {
      append newline "$char"
    }
  }
  send2irc "$command$newline"
}
