/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.config;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import de.rub.nds.tlsattacker.attacks.config.AttackConfig;
import de.rub.nds.tlsattacker.attacks.config.delegate.AttackDelegate;
import de.rub.nds.tlsattacker.attacks.pkcs1.BleichenbacherWorkflowType;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.CiphersuiteDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.ClientDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.GeneralDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.ProtocolVersionDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.StarttlsDelegate;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.KeyExchangeAlgorithm;
import java.util.LinkedList;

public class BleichenbacherCommandConfig
extends AttackConfig {
    public static final String ATTACK_COMMAND = "bleichenbacher";
    @ParametersDelegate
    private ClientDelegate clientDelegate;
    @ParametersDelegate
    private CiphersuiteDelegate ciphersuiteDelegate;
    @ParametersDelegate
    private ProtocolVersionDelegate protocolVersionDelegate;
    @ParametersDelegate
    private AttackDelegate attackDelegate;
    @Parameter(names={"-encrypted_premaster_secret"}, description="Encrypted premaster secret from the RSA client key exchange message. You can retrieve this message from the Wireshark traffic. Find the client key exchange message, right click on the \"EncryptedPremaster\" value and copy this value as a Hex Stream.")
    private String encryptedPremasterSecret;
    @Parameter(names={"-type"}, description="Type of the Bleichenbacher test. FAST contains only basic server test queries. FULL results in a comprehensive server evaluation.")
    private Type type = Type.FAST;
    @Parameter(names={"-msgPkcsConform"}, description="Used by the real Bleichenbacher attack. Indicates whether the original message that we are going to decrypt is PKCS#1 conform or not (more precisely, whether it starts with 0x00 0x02).", arity=1)
    private boolean msgPkcsConform = true;
    @ParametersDelegate
    private StarttlsDelegate starttlsDelegate;
    @Parameter(names={"-workflowType"}, description="Which workflow traces should be tested with")
    private BleichenbacherWorkflowType workflowType = BleichenbacherWorkflowType.CKE_CCS_FIN;

    public BleichenbacherCommandConfig(GeneralDelegate delegate) {
        super(delegate);
        this.clientDelegate = new ClientDelegate();
        this.ciphersuiteDelegate = new CiphersuiteDelegate();
        this.protocolVersionDelegate = new ProtocolVersionDelegate();
        this.attackDelegate = new AttackDelegate();
        this.starttlsDelegate = new StarttlsDelegate();
        this.addDelegate(this.clientDelegate);
        this.addDelegate(this.ciphersuiteDelegate);
        this.addDelegate(this.protocolVersionDelegate);
        this.addDelegate(this.attackDelegate);
        this.addDelegate(this.starttlsDelegate);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public Config createConfig() {
        Config config = super.createConfig();
        if (this.ciphersuiteDelegate.getCipherSuites() == null) {
            LinkedList<CipherSuite> cipherSuites = new LinkedList<CipherSuite>();
            for (CipherSuite suite : CipherSuite.getImplemented()) {
                if (AlgorithmResolver.getKeyExchangeAlgorithm(suite) != KeyExchangeAlgorithm.RSA && AlgorithmResolver.getKeyExchangeAlgorithm(suite) != KeyExchangeAlgorithm.PSK_RSA) continue;
                cipherSuites.add(suite);
            }
            config.setDefaultClientSupportedCiphersuites(cipherSuites);
        }
        config.setQuickReceive(true);
        config.setEarlyStop(true);
        config.setStopActionsAfterIOException(true);
        config.setStopActionsAfterFatal(false);
        config.setStopReceivingAfterFatal(false);
        config.setAddRenegotiationInfoExtension(true);
        config.setAddServerNameIndicationExtension(true);
        config.setAddSignatureAndHashAlgorithmsExtension(true);
        config.setAddECPointFormatExtension(false);
        config.setAddEllipticCurveExtension(false);
        config.setWorkflowExecutorShouldClose(false);
        return config;
    }

    @Override
    public boolean isExecuteAttack() {
        return this.attackDelegate.isExecuteAttack();
    }

    public String getEncryptedPremasterSecret() {
        return this.encryptedPremasterSecret;
    }

    public boolean isMsgPkcsConform() {
        return this.msgPkcsConform;
    }

    public BleichenbacherWorkflowType getWorkflowType() {
        return this.workflowType;
    }

    public void setWorkflowType(BleichenbacherWorkflowType workflowType) {
        this.workflowType = workflowType;
    }

    public static enum Type {
        FULL,
        FAST;

    }
}

