/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto;

import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.tls.TlsECCUtils;

public class ECCUtilsBCWrapper {
    public static ECDomainParameters readECParameters(NamedGroup[] namedGroups, ECPointFormat[] pointFormats, InputStream input) throws IOException {
        int[] nc = ECCUtilsBCWrapper.convertNamedCurves(namedGroups);
        short[] pf = ECCUtilsBCWrapper.convertPointFormats(pointFormats);
        return TlsECCUtils.readECParameters((int[])nc, (short[])pf, (InputStream)input);
    }

    public static ECDomainParameters readECParameters(NamedGroup namedGroup, ECPointFormat pointFormat, InputStream input) throws IOException {
        int[] nc = ECCUtilsBCWrapper.convertNamedCurves(new NamedGroup[]{namedGroup});
        short[] pf = ECCUtilsBCWrapper.convertPointFormats(new ECPointFormat[]{pointFormat});
        return TlsECCUtils.readECParameters((int[])nc, (short[])pf, (InputStream)input);
    }

    public static ECDomainParameters readECParameters(InputStream input) throws IOException {
        NamedGroup[] namedCurves = NamedGroup.values();
        ECPointFormat[] poinFormats = ECPointFormat.values();
        return ECCUtilsBCWrapper.readECParameters(namedCurves, poinFormats, input);
    }

    private static int[] convertNamedCurves(NamedGroup[] namedGroups) {
        if (namedGroups == null || namedGroups.length == 0) {
            return new int[0];
        }
        int[] nc = new int[namedGroups.length];
        for (int i = 0; i < namedGroups.length; ++i) {
            nc[i] = namedGroups[i].getIntValue();
        }
        return nc;
    }

    private static short[] convertPointFormats(ECPointFormat[] pointFormats) {
        if (pointFormats == null || pointFormats.length == 0) {
            return new short[0];
        }
        short[] pf = new short[pointFormats.length];
        for (int i = 0; i < pointFormats.length; ++i) {
            pf[i] = pointFormats[i].getShortValue();
        }
        return pf;
    }

    private ECCUtilsBCWrapper() {
    }
}

