/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SRPExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.SRPExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.SRPExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.SRPExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SrpExtensionHandler
extends ExtensionHandler<SRPExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SrpExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public SRPExtensionParser getParser(byte[] message, int pointer) {
        return new SRPExtensionParser(pointer, message);
    }

    public SRPExtensionPreparator getPreparator(SRPExtensionMessage message) {
        return new SRPExtensionPreparator(this.context.getChooser(), message, this.getSerializer(message));
    }

    public SRPExtensionSerializer getSerializer(SRPExtensionMessage message) {
        return new SRPExtensionSerializer(message);
    }

    @Override
    public void adjustTLSExtensionContext(SRPExtensionMessage message) {
        this.context.setSecureRemotePasswordExtensionIdentifier((byte[])message.getSrpIdentifier().getValue());
        LOGGER.debug("Adjusted the TLSContext secure remote password extension identifier to " + ArrayConverter.bytesToHexString((byte[])this.context.getSecureRemotePasswordExtensionIdentifier()));
    }
}

