/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.reports.common;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.api.security.PermissionsService;
import org.traccar.mail.MailManager;
import org.traccar.model.User;
import org.traccar.reports.common.ReportExecutor;
import org.traccar.storage.StorageException;

public class ReportMailer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportMailer.class);
    private final PermissionsService permissionsService;
    private final MailManager mailManager;

    @Inject
    public ReportMailer(PermissionsService permissionsService, MailManager mailManager) {
        this.permissionsService = permissionsService;
        this.mailManager = mailManager;
    }

    public void sendAsync(long userId, ReportExecutor executor) {
        new Thread(() -> {
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                executor.execute(stream);
                MimeBodyPart attachment = new MimeBodyPart();
                attachment.setFileName("report.xlsx");
                attachment.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(stream.toByteArray(), "application/octet-stream")));
                User user = this.permissionsService.getUser(userId);
                this.mailManager.sendMessage(user, false, "Report", "The report is in the attachment.", attachment);
            }
            catch (MessagingException | IOException | StorageException e) {
                LOGGER.warn("Email report failed", e);
            }
        }).start();
    }
}

