/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.utils;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.graalvm.visualvm.jfr.model.JFRModel;

public final class ValuesConverter {
    private ValuesConverter() {
    }

    public static long instantToNanos(Instant instant) {
        return TimeUnit.SECONDS.toNanos(instant.getEpochSecond()) + (long)instant.getNano();
    }

    public static long instantToRelativeNanos(Instant instant, JFRModel model) {
        return ValuesConverter.durationToNanos(model.toRelativeTime(instant));
    }

    public static long instantToMillis(Instant instant) {
        return instant.toEpochMilli();
    }

    public static long instantToRelativeMillis(Instant instant, JFRModel model) {
        return ValuesConverter.durationToMillis(model.toRelativeTime(instant));
    }

    public static long durationToNanos(Duration duration) {
        return duration.toNanos();
    }

    public static long durationToMicros(Duration duration) {
        long micros = duration.getSeconds() * 1000000L;
        return micros += (long)(duration.getNano() / 1000);
    }

    public static long durationToMillis(Duration duration) {
        return duration.toMillis();
    }

    public static long nanosToMillis(long nanos) {
        return nanos / 1000000L;
    }
}

