/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.spi.KeymapManager;
import org.netbeans.modules.options.keymap.CompoundAction;
import org.netbeans.modules.options.keymap.LayersBridge;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class KeymapModel {
    static final RequestProcessor RP = new RequestProcessor(KeymapModel.class);
    private static final Logger LOG = Logger.getLogger(KeymapModel.class.getName());
    private static final Logger UI_LOG = Logger.getLogger("org.netbeans.ui.options");
    private static volatile List<KeymapManager> managers = null;
    private static volatile KeymapModel INSTANCE;
    private volatile AL actionData;
    private volatile PL profileData;
    private volatile KL keymapData;
    static final Object LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KeymapModel create() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<KeymapModel> clazz = KeymapModel.class;
        synchronized (KeymapModel.class) {
            INSTANCE = new KeymapModel();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<? extends KeymapManager> getKeymapManagerInstances() {
        if (managers != null) {
            return managers;
        }
        final Lookup.Result result = Lookup.getDefault().lookupResult(KeymapManager.class);
        ArrayList<KeymapManager> arrayList = new ArrayList<KeymapManager>(result.allInstances());
        arrayList.trimToSize();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Dumping registered KeymapManagers: ");
            for (KeymapManager keymapManager : arrayList) {
                LOG.fine("    KeymapManager: " + KeymapModel.s2s(keymapManager));
            }
            LOG.fine("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
        Class<KeymapModel> clazz = KeymapModel.class;
        synchronized (KeymapModel.class) {
            if (managers == null) {
                managers = arrayList;
                result.addLookupListener(new LookupListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void resultChanged(LookupEvent lookupEvent) {
                        Class<KeymapModel> clazz = KeymapModel.class;
                        synchronized (KeymapModel.class) {
                            managers = null;
                            result.removeLookupListener((LookupListener)this);
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            if (INSTANCE != null) {
                                INSTANCE.refreshActions();
                            }
                            return;
                        }
                    }
                });
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return arrayList;
        }
    }

    public Set<String> getActionCategories() {
        AL aL = this.ensureActionsLoaded();
        return aL.categories;
    }

    private PL ensureProfilesLoaded() {
        PL pL = this.profileData;
        if (pL == null) {
            pL = new PL();
            KeymapModel.waitFinished(pL);
        }
        return pL.current;
    }

    private KL ensureKeymapsLoaded(String string) {
        KL kL = this.keymapData;
        if (kL == null || kL.keyMaps.get(string) == null) {
            kL = new KL(this.ensureActionsLoaded(), string);
            KeymapModel.waitFinished(kL);
        }
        return kL.current;
    }

    private static void findDuplicateIds(String string, Collection<ShortcutAction> collection, Set<String> set, Set<String> set2) {
        for (ShortcutAction shortcutAction : collection) {
            String string2 = shortcutAction.getId();
            if (!set.add(string2)) {
                set2.add(string2);
                continue;
            }
            string2 = LayersBridge.getOrigActionClass(shortcutAction);
            if (string2 == null || set.add(string2)) continue;
            set2.add(string2);
        }
    }

    public Set<ShortcutAction> getActions(String string) {
        AL aL = this.ensureActionsLoaded();
        Set set = (Set)aL.categoryToActions.get(string);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Category '" + string + "' actions (" + set.size() + "), KeymapModel=" + this + ":");
            for (ShortcutAction shortcutAction : set) {
                LOG.fine("    id='" + shortcutAction.getId() + "', did='" + shortcutAction.getDelegatingActionId() + ", " + KeymapModel.s2s(shortcutAction));
            }
            LOG.fine("---------------------------");
        }
        return set;
    }

    boolean isDuplicateId(String string) {
        AL aL = this.ensureActionsLoaded();
        if (!aL.duplicateIds.contains(string)) {
            return false;
        }
        LOG.log(Level.WARNING, "Duplicate action ID used: {0}", new Object[]{string});
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshActions() {
        KeymapModel keymapModel = this;
        synchronized (keymapModel) {
            this.actionData = null;
            this.profileData = null;
            this.keymapData = null;
        }
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            Object object = LOCK;
            synchronized (object) {
                keymapManager.refreshActions();
            }
        }
    }

    public String getCurrentProfile() {
        return this.ensureProfilesLoaded().currentProfile;
    }

    public void setCurrentProfile(String string) {
        Object object;
        String string2 = this.getCurrentProfile();
        if (!string2.equals(string)) {
            object = new LogRecord(Level.CONFIG, "KEYMAP_SET_PROFILE");
            ((LogRecord)object).setParameters(new Object[]{string, string2});
            ((LogRecord)object).setResourceBundle(NbBundle.getBundle(KeymapModel.class));
            ((LogRecord)object).setResourceBundleName(KeymapModel.class.getPackage().getName() + ".Bundle");
            ((LogRecord)object).setLoggerName(UI_LOG.getName());
            UI_LOG.log((LogRecord)object);
        }
        object = this.displayNameToName(string);
        KeymapModel.waitFinished(new Runnable((String)object){
            final /* synthetic */ String val$profile;
            {
                this.val$profile = string;
            }

            @Override
            public void run() {
                for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
                    keymapManager.setCurrentProfile(this.val$profile);
                }
                KeymapModel.this.profileData = null;
            }
        });
    }

    public void revertActions(final Collection<ShortcutAction> collection) throws IOException {
        final IOException[] iOExceptionArray = new IOException[1];
        KeymapModel.waitFinished(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
                        Object object;
                        if (keymapManager instanceof KeymapManager.WithRevert) {
                            try {
                                ((KeymapManager.WithRevert)((Object)keymapManager)).revertActions(KeymapModel.this.getCurrentProfile(), collection);
                                continue;
                            }
                            catch (IOException iOException) {
                                iOExceptionArray[0] = iOException;
                                object = KeymapModel.this;
                                synchronized (object) {
                                    KeymapModel.this.keymapData = null;
                                }
                                return;
                            }
                        }
                        Map<ShortcutAction, Set<String>> map = keymapManager.getDefaultKeymap(KeymapModel.this.getCurrentProfile());
                        object = new HashMap<ShortcutAction, Set<String>>(keymapManager.getKeymap(KeymapModel.this.getCurrentProfile()));
                        for (ShortcutAction shortcutAction : collection) {
                            Set<String> set = map.get(shortcutAction);
                            if (set == null) {
                                object.remove(shortcutAction);
                                continue;
                            }
                            object.put(shortcutAction, set);
                        }
                        keymapManager.saveKeymap(KeymapModel.this.getCurrentProfile(), (Map<ShortcutAction, Set<String>>)object);
                    }
                }
                finally {
                    KeymapModel keymapModel = KeymapModel.this;
                    synchronized (keymapModel) {
                        KeymapModel.this.keymapData = null;
                    }
                }
            }
        });
        if (iOExceptionArray[0] != null) {
            throw iOExceptionArray[0];
        }
    }

    public void revertProfile(final String string) throws IOException {
        final IOException[] iOExceptionArray = new IOException[1];
        KeymapModel.waitFinished(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
                        if (keymapManager instanceof KeymapManager.WithRevert) {
                            try {
                                ((KeymapManager.WithRevert)((Object)keymapManager)).revertProfile(string);
                                continue;
                            }
                            catch (IOException iOException) {
                                iOExceptionArray[0] = iOException;
                                KeymapModel keymapModel = KeymapModel.this;
                                synchronized (keymapModel) {
                                    KeymapModel.this.profileData = null;
                                    KeymapModel.this.keymapData = null;
                                }
                                return;
                            }
                        }
                        keymapManager.saveKeymap(string, keymapManager.getDefaultKeymap(string));
                    }
                }
                finally {
                    KeymapModel keymapModel = KeymapModel.this;
                    synchronized (keymapModel) {
                        KeymapModel.this.profileData = null;
                        KeymapModel.this.keymapData = null;
                    }
                }
            }
        });
        if (iOExceptionArray[0] != null) {
            throw iOExceptionArray[0];
        }
    }

    public List<String> getProfiles() {
        return new ArrayList<String>(this.getProfilesMap().keySet());
    }

    public boolean isCustomProfile(String string) {
        string = this.displayNameToName(string);
        Boolean bl = (Boolean)this.ensureProfilesLoaded().customProfiles.get(string);
        return bl == null || bl != false;
    }

    public Map<ShortcutAction, Set<String>> getKeymap(String string) {
        string = this.displayNameToName(string);
        return (Map)this.ensureKeymapsLoaded(string).keyMaps.get(string);
    }

    public Map<ShortcutAction, Set<String>> getKeymapDefaults(String string) {
        string = this.displayNameToName(string);
        return (Map)this.ensureKeymapsLoaded(string).keyMapDefaults.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProfile(String string) {
        string = this.displayNameToName(string);
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            Object object = LOCK;
            synchronized (object) {
                keymapManager.deleteProfile(string);
            }
        }
    }

    public void changeKeymap(String string, Map<ShortcutAction, Set<String>> map) {
        final String string2 = this.displayNameToName(string);
        this.log("changeKeymap.actionToShortcuts", map.entrySet());
        final HashMap<ShortcutAction, Set<String>> hashMap = new HashMap<ShortcutAction, Set<String>>(this.getKeymap(string2));
        hashMap.putAll(map);
        KeymapModel.waitFinished(new Runnable(){

            @Override
            public void run() {
                KL kL = KeymapModel.this.keymapData;
                if (kL != null) {
                    HashMap<String, Map> hashMap2 = new HashMap<String, Map>();
                    hashMap2.putAll(kL.keyMaps);
                    hashMap2.put(string2, hashMap);
                    kL.keyMaps = hashMap2;
                }
                KeymapModel.this.log("changeKeymap.m", hashMap.entrySet());
                for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
                    keymapManager.saveKeymap(string2, hashMap);
                }
            }
        });
    }

    private void log(String string, Collection collection) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        LOG.fine(string);
        for (Object e : collection) {
            LOG.fine("  " + e);
        }
    }

    static Set<ShortcutAction> mergeActions(Collection<ShortcutAction> collection, Collection<ShortcutAction> collection2, String string, Map<ShortcutAction, CompoundAction> map) {
        Object object;
        String string2;
        HashSet<ShortcutAction> hashSet = new HashSet<ShortcutAction>();
        HashMap<String, ShortcutAction> hashMap = new HashMap<String, ShortcutAction>();
        HashMap<String, ShortcutAction> hashMap2 = new HashMap<String, ShortcutAction>();
        for (ShortcutAction shortcutAction : collection) {
            string2 = shortcutAction.getId();
            hashMap.put(string2, shortcutAction);
            object = shortcutAction.getDelegatingActionId();
            if (object == null) continue;
            hashMap2.put((String)object, shortcutAction);
        }
        for (ShortcutAction shortcutAction : collection2) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            string2 = shortcutAction.getId();
            if (hashMap2.containsKey(string2)) {
                object = (ShortcutAction)hashMap2.remove(string2);
                hashMap.remove(object.getId());
                object5 = KeymapModel.findOriginator((ShortcutAction)object);
                object4 = new HashMap();
                object4.put(((KeymapManager)object5).getName(), object);
                object4.put(string, shortcutAction);
                object3 = new CompoundAction((Map<String, ShortcutAction>)object4);
                hashSet.add((ShortcutAction)object3);
                map.put((ShortcutAction)object, (CompoundAction)object3);
                map.put(shortcutAction, (CompoundAction)object3);
                continue;
            }
            object = shortcutAction.getDelegatingActionId();
            if (hashMap.containsKey(object)) {
                object5 = (ShortcutAction)hashMap.remove(object);
                object4 = KeymapModel.findOriginator((ShortcutAction)object5);
                object3 = new HashMap<String, Object>();
                object3.put(((KeymapManager)object4).getName(), object5);
                object3.put(string, shortcutAction);
                object2 = new CompoundAction((Map<String, ShortcutAction>)object3);
                hashSet.add((ShortcutAction)object2);
                map.put((ShortcutAction)object5, (CompoundAction)object2);
                map.put(shortcutAction, (CompoundAction)object2);
                continue;
            }
            object5 = (ShortcutAction)hashMap.get(string2);
            if (object5 != null) {
                if (object5 instanceof CompoundAction) {
                    ((CompoundAction)object5).addAction(string, shortcutAction);
                    map.put(shortcutAction, (CompoundAction)object5);
                    continue;
                }
                hashMap.remove(string2);
                object4 = object5;
                object3 = KeymapModel.findOriginator((ShortcutAction)object4);
                object2 = new HashMap<String, Object>();
                object2.put(((KeymapManager)object3).getName(), object4);
                object2.put(string, shortcutAction);
                CompoundAction compoundAction = new CompoundAction((Map<String, ShortcutAction>)object2);
                hashSet.remove(object4);
                hashSet.add(compoundAction);
                map.put((ShortcutAction)object4, compoundAction);
                map.put(shortcutAction, compoundAction);
                continue;
            }
            if (map.containsKey(shortcutAction)) continue;
            hashSet.add(shortcutAction);
        }
        hashSet.addAll(hashMap.values());
        return hashSet;
    }

    static Collection<ShortcutAction> filterSameScope(Set<ShortcutAction> set, ShortcutAction shortcutAction) {
        KeymapManager keymapManager = KeymapModel.findOriginator(shortcutAction);
        if (keymapManager == null) {
            return Collections.emptyList();
        }
        LinkedList<ShortcutAction> linkedList = null;
        for (ShortcutAction shortcutAction2 : set) {
            KeymapManager keymapManager2 = KeymapModel.findOriginator(shortcutAction2);
            if (keymapManager != keymapManager2) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<ShortcutAction>();
            }
            linkedList.add(shortcutAction2);
        }
        return linkedList == null ? Collections.emptyList() : linkedList;
    }

    private static KeymapManager findOriginator(ShortcutAction shortcutAction) {
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            if (shortcutAction.getKeymapManagerInstance(keymapManager.getName()) == null) continue;
            return keymapManager;
        }
        return null;
    }

    private static Map<ShortcutAction, Set<String>> mergeShortcuts(Map<ShortcutAction, Set<String>> map, Map<ShortcutAction, Set<String>> map2, Map<ShortcutAction, CompoundAction> map3) {
        for (Map.Entry<ShortcutAction, Set<String>> entry : map2.entrySet()) {
            ShortcutAction shortcutAction = entry.getKey();
            Set<String> set = entry.getValue();
            if (set.isEmpty()) continue;
            if (map3.containsKey(shortcutAction)) {
                shortcutAction = map3.get(shortcutAction);
            }
            map.put(shortcutAction, set);
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Action='" + shortcutAction.getId() + "' (" + KeymapModel.s2s(shortcutAction) + ") shortcuts: " + set);
        }
        return map;
    }

    private AL ensureActionsLoaded() {
        AL aL = this.actionData;
        if (aL != null) {
            return aL;
        }
        aL = new AL();
        KeymapModel.waitFinished(aL);
        return aL.current;
    }

    private String displayNameToName(String string) {
        String string2 = this.getProfilesMap().get(string);
        return string2 == null ? string : string2;
    }

    String getProfileName(String string) {
        Map<String, String> map = this.getProfilesMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return entry.getKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitFinished(Runnable runnable) {
        Object object = LOCK;
        synchronized (object) {
            runnable.run();
        }
    }

    private Map<String, String> getProfilesMap() {
        return this.ensureProfilesLoaded().profilesMap;
    }

    private static String s2s(Object object) {
        return object == null ? "null" : object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    static {
        LOCK = new String("Keymap lock");
    }

    private class KL
    implements Runnable {
        private AL actionData;
        private String profile;
        private volatile KL current;
        private volatile Map<String, Map<ShortcutAction, Set<String>>> keyMaps = new HashMap<String, Map<ShortcutAction, Set<String>>>();
        private Map<String, Map<ShortcutAction, Set<String>>> keyMapDefaults = new HashMap<String, Map<ShortcutAction, Set<String>>>();

        public KL(AL aL, String string) {
            this.actionData = aL;
            this.profile = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.current = KeymapModel.this.keymapData;
            if (this.current != null && this.current.keyMaps.get(this.profile) != null) {
                return;
            }
            Map map = new HashMap();
            Map map2 = new HashMap();
            for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
                Map<ShortcutAction, Set<String>> map3 = keymapManager.getKeymap(this.profile);
                map = KeymapModel.mergeShortcuts(map, map3, this.actionData.sharedActions);
                map3 = keymapManager.getDefaultKeymap(this.profile);
                map2 = KeymapModel.mergeShortcuts(map2, map3, this.actionData.sharedActions);
            }
            KL kL = this;
            synchronized (kL) {
                if (KeymapModel.this.keymapData != null && ((KeymapModel)KeymapModel.this).keymapData.keyMaps.get(this.profile) != null) {
                    this.current = KeymapModel.this.keymapData;
                } else {
                    if (KeymapModel.this.keymapData != null) {
                        this.keyMaps.putAll(((KeymapModel)KeymapModel.this).keymapData.keyMaps);
                        this.keyMapDefaults.putAll(((KeymapModel)KeymapModel.this).keymapData.keyMapDefaults);
                    }
                    this.keyMaps.put(this.profile, map);
                    this.keyMapDefaults.put(this.profile, map2);
                    this.current = this;
                    KeymapModel.this.keymapData = this.current;
                }
            }
        }
    }

    private class PL
    implements Runnable {
        private volatile PL current;
        private Map<String, String> profilesMap = new HashMap<String, String>();
        private String currentProfile;
        private Map<String, Boolean> customProfiles = new HashMap<String, Boolean>();

        private PL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.current = KeymapModel.this.profileData;
            if (this.current != null) {
                return;
            }
            for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
                List<String> list = keymapManager.getProfiles();
                if (this.currentProfile == null) {
                    this.currentProfile = keymapManager.getCurrentProfile();
                }
                if (list == null || !this.profilesMap.isEmpty()) continue;
                for (String string : list) {
                    this.profilesMap.put(keymapManager.getProfileDisplayName(string), string);
                    this.customProfiles.put(string, Boolean.TRUE.equals(this.customProfiles.get(string)) || keymapManager.isCustomProfile(string));
                }
            }
            if (this.currentProfile == null) {
                this.currentProfile = "NetBeans";
            }
            KeymapModel keymapModel = KeymapModel.this;
            synchronized (keymapModel) {
                this.current = KeymapModel.this.profileData == null ? (KeymapModel.this.profileData = this) : KeymapModel.this.profileData;
            }
        }
    }

    private class AL
    implements Runnable {
        private volatile AL current;
        private Set<String> categories;
        private Set<String> allActionIds = new HashSet<String>();
        private Set<String> duplicateIds = new HashSet<String>();
        private Map<String, Set<ShortcutAction>> categoryToActions = new HashMap<String, Set<ShortcutAction>>();
        private Map<ShortcutAction, CompoundAction> sharedActions = new HashMap<ShortcutAction, CompoundAction>();

        private AL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            this.current = KeymapModel.this.actionData;
            if (this.current != null) {
                return;
            }
            ArrayList<Map<String, Set<ShortcutAction>>> arrayList = new ArrayList<Map<String, Set<ShortcutAction>>>();
            HashSet<String> hashSet = new HashSet<String>();
            HashMap<String, Set<ShortcutAction>> hashMap = new HashMap<String, Set<ShortcutAction>>();
            Collection<? extends KeymapManager> collection = KeymapModel.getKeymapManagerInstances();
            for (KeymapManager object22 : collection) {
                object = object22.getActions();
                arrayList.add((Map<String, Set<ShortcutAction>>)object);
                hashSet.addAll(object.keySet());
            }
            HashSet hashSet2 = new HashSet();
            HashSet<String> hashSet3 = new HashSet<String>();
            hashSet.add("");
            for (String string : hashSet) {
                Iterator<? extends KeymapManager> iterator = collection.iterator();
                Set<ShortcutAction> set = new HashSet<ShortcutAction>();
                for (Map map : arrayList) {
                    Set set2 = (Set)map.get(string);
                    KeymapManager keymapManager = iterator.next();
                    if (set2 == null) continue;
                    set = KeymapModel.mergeActions(set, set2, keymapManager.getName(), this.sharedActions);
                }
                KeymapModel.findDuplicateIds(string, set, hashSet2, hashSet3);
                hashMap.put(string, set);
            }
            this.allActionIds = hashSet2;
            this.duplicateIds = hashSet3;
            this.categoryToActions = hashMap;
            this.categories = hashSet;
            object = KeymapModel.this;
            synchronized (object) {
                this.current = KeymapModel.this.actionData != null ? KeymapModel.this.actionData : (KeymapModel.this.actionData = this);
            }
        }
    }
}

